<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta name="description" content="AppWorks Technology">
      <meta name="author" content="AppWorks Technology">
      <link rel="shortcut icon" type="image/png" href="<?php echo e(url('/').'/'.asset('/images/config/logo/'.config('SITE_LOGO'))); ?>">
      <title><?php echo e(config('SITE_NAME')); ?></title>
      <!-- Bootstrap core CSS -->
      <link href="<?php echo e(asset('auth/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
      <!-- Custom styles for this template -->
      <link href="<?php echo e(asset('auth/css/auth.css')); ?>" rel="stylesheet">
      <!-- Font -->
      <link rel="preconnect" href="https://fonts.gstatic.com">
      <script src="https://kit.fontawesome.com/cc527ccbca.js" crossorigin="anonymous"></script>
      <link href="https://fonts.googleapis.com/css2?family=Rubik&display=swap" rel="stylesheet">
   </head>
   <body class="bg-white login">
      <div class="container-fluid">
         <div class="position-relative zindex mobhide">
            <a href="<?php echo e(url('/')); ?>" class="intro-x flex items-center pt-4 mb-5">
            <img alt="logo" class="w-24" src="<?php echo e(url('/').'/'.asset('/images/config/logo/'.config('SITE_LOGO'))); ?>" width="30px">
            <span class="text-white text-lg ml-3"><span class="font-medium"><?php echo e(config('SITE_NAME')); ?></span></span>
            </a>
         </div>
         <div class="row seccenter">
            <div class="col-md-4 mobhide">
               <div class="loginimg">
                  <div class="my40">
                     <img src="<?php echo e(asset('auth/images/illustration.svg')); ?>">
                     <h2 class="text-white mt-5">A few more clicks to
                        sign in to your account.
                     </h2>
                     <h5 class="text-white mt-5">Manage all your accounts in one place</h5>
                  </div>
               </div>
            </div>
            <div class="col-xl-4 offset-xl-1 loginwidth">
               <div class="my40">
                  <div class="p-5 logform">
                     <p class="webhide">
                        <a href="<?php echo e(url('/')); ?>" class="intro-x d-flex items-center pt-4 mb-5 justify-content-center text-center">
                        <img alt="logo" class="w-24" src="<?php echo e(url('/').'/'.asset('/images/config/logo/'.config('SITE_LOGO'))); ?>" width="30px">
                        <span class=" text-dark text-lg ml-3"> <?php echo e(config('SITE_NAME')); ?> </span>
                        </span>
                        </a>
                     </p>
                     <h3 class="mb-4 mt-3">Verify Account</h3>
                 
                        <form action="<?php echo e(url('/verify_otp')); ?>" method="POST">

                        <?php if(Session::has('message')): ?> 
                           <div class="alert alert-<?php echo e(Session::get('type')); ?> alert-dismissible  show" role="alert">
                             <h4 class="alert-heading"><?php echo e(Session::get("message")); ?></h4>
                               <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                 <span aria-hidden="true">&times;</span>
                               </button>
                           </div>
                        <?php endif; ?>
                        
                        <?php echo e(csrf_field()); ?>

                        
                        <div class="form-group">
                            <input type="hidden" name="txt_username" id="txt_username" value="<?php echo e(Session()->get('mobileno')); ?>" required>
                           <input type="text" class="form-control" placeholder="Enter TOP" name="txt_otp" id="txt_otp" required>
                           <span class="text-danger" id="divtxt_otp"></span>
                        </div>
                        <div class="mt-3">
                           <button class="btn btn-primary w-32 mr-2 mb-2 zoom-in" type="submit" style="width: 100%;">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></button>
                           
                        </div>
                        <div class="mt-3" style="text-align: center;">
                           <a  href="<?php echo e(url('login')); ?>" class="text-muted">  <i class="fa fa-arrow-left" aria-hidden="true"></i> Back to Login</a>
                        </div>
                     </form>
                     <div class="mt-5">
                        <p class=" text-muted">By signin up, you agree to our <a href="#">Terms and Conditions</a> & <a href="#">Privacy Policy</a></p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- /#wrapper -->
      <!-- Bootstrap core JavaScript -->
      <script src="<?php echo e(asset('auth/vendor/jquery/jquery.min.js')); ?>"></script>
      <script src="<?php echo e(asset('auth/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
      <script type="text/javascript">
         $(document).ready(function() {
          $("#show_hide_password a").on('click', function(event) {
            event.preventDefault();
            if($('#show_hide_password input').attr("type") == "text"){
              $('#show_hide_password input').attr('type', 'password');
              $('#show_hide_password i').addClass( "fa-eye-slash" );
              $('#show_hide_password i').removeClass( "fa-eye" );
            }
            else if($('#show_hide_password input').attr("type") == "password"){
              $('#show_hide_password input').attr('type', 'text');
              $('#show_hide_password i').removeClass( "fa-eye-slash" );
              $('#show_hide_password i').addClass( "fa-eye" );
            }
          });
         });
            
      </script>
   </body>
</html><?php /**PATH /home/rctradeco/public_html/soft/resources/views/Auth/verify_otp.blade.php ENDPATH**/ ?>