<?php
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/employee_register', function ()
{
$POS="";
$SPONSOR=""; 
return view('Auth.employee_register',compact('POS','SPONSOR'));
});*/

Route::get('/update_directbusiness', 'UserController@update_business');
Route::get('/update_directbusiness1', 'UserController@update_business1');
Route::get('/sms_test', 'AuthController@sms_test');
Route::get('/get_coupan_amount', 'CartController@get_coupan_amount');

Route::get('/invite/{info}', 'FrontController@invite');

Route::get('/fun_test', 'TestingController@fun_test');
Route::get('/testing_pay', 'TestingController@testing_pay');

Route::get('/clear', function () {
	Artisan::call('route:clear');
	return "Route cache file removed";
});

Route::get('/cron_jobs/{command}/{param}','FrontController@show');

Route::get('/shutdown', function(){
return Artisan::call('down');
});

Route::get('/metamask_login', 'FrontController@metamask_login');


Route::get('/dk', 'FrontController@testing');
Route::get('/send_mail', 'FrontController@send_mail');

  Route::get('/', function () {
  return view('Auth.login');
});

//Route::get('/', 'FrontController@index');

Route::post('/front_check_mobile_roffer', 'FrontController@check_mobile_roffer');
Route::post('/front_get_dth_roffer', 'FrontController@get_dth_roffer');
Route::post('/front_fetch_bill','FrontController@check_bill');


Route::group(['middleware' => 'prevent-back-history'],function(){

Route::post('select_get_notificat','NotificationController@get_notification');
Route::post('update_get_notificat','NotificationController@UpdateGetNotificat');
Route::post('update_get_notificats','NotificationController@UpdateGetNotificats');

Route::get('/login', function () {
	return view('Auth.login');
});

Route::get('/dapp_login','B2CController@dapp_login')->middleware('Cors');
Route::get('/dapp_logins','B2CController@dapp_logins')->middleware('Cors');


Route::get('/sign-in', function () {
	return view('Auth.login');
});
Route::post('/sign_in', 'B2CController@signin');

Route::get('/sign_out', 'B2CController@logout');

Route::get('/bill-receipt/{id}', 'ActionController@bill_receipt');

Route::get('/user-verification', function () {
    return view('Auth.b2c_verify_otp');
});


Route::post('/otp_verify', 'B2CController@login_verification');

Route::match(['get','post'], '/recharge-history', 'B2CController@user_rechargereport');
Route::match(['get','post'], '/bill-pay-history', 'B2CController@billpay_report');
Route::match(['get','post'], '/account-statement', 'B2CController@user_account_statement');
Route::post('/ledger', 'B2CController@ledger');
Route::post('/check_user_login', 'B2CController@check_user_login');

Route::post('do-recharge','B2CController@do_recharges');
Route::post('dth-recharge','B2CController@do_dthrecharges');//do_dthrecharge
Route::post('boardband-recharge','B2CController@do_utilitypayments');//do_utilitypayment
Route::post('landline-recharge','B2CController@do_utilitypayments');
Route::post('electricity-pay-bill','B2CController@do_utilitypayments');
Route::post('gas-pay-bill','B2CController@do_utilitypayments');
Route::post('water-pay-bill','B2CController@do_utilitypayments');

 Route::get('/profile', 'B2CController@profile');
 Route::get('/profile/password', 'B2CController@profile');
Route::get('/profile/add-money-wallet', 'B2CController@profile');
 Route::get('/offers', 'B2CController@offers');
 Route::post('/update-user-info', 'B2CController@update_user_info');
 Route::post('/user-change-password', 'B2CController@user_change_password');
Route::post('/add-money-wallet', 'B2CController@btoc_add_money_wallet');
Route::post('payment-completebtoc', 'B2CController@payment_complete');
Route::post('payment-completebtocdth', 'B2CController@payment_complete_dth');
Route::post('/payment-completebtoc-addmoneywall', 'B2CController@AddMoneyWallet');
Route::post('/payment-failedbtoc-addmoneywall', 'B2CController@failedbtoc');
Route::post('/payment-faileduser-addmoneywall', 'UserController@faileduser');



Route::get('/employee_login', function () {
	return view('Auth.employee_login');
});
Route::get('/franchisee_login', function () {
	return view('Auth.franchisee_login');
});
});

Route::get('/admin_login', function () {
	return view('Auth.login');
});
Route::post('/login', 'AuthController@signin');
Route::get('/update_token', 'FrontController@update_token');

Route::post('/employee_login', 'EmployeeController@signin');
Route::post('/employee_signup', 'EmployeeController@signup');

Route::post('/franchisee_login','FranchiseController@franchisee_login');

/* Route::get('/refferal/{sponsor}/{pos}', function ($sponsor,$pos)
{
$POS=$pos;
$SPONSOR=$sponsor; 
return view('Auth.register',compact('POS','SPONSOR'));
}); */

Route::get('/refferal/{memberID}','AuthController@registration');
Route::get('/refferal/{memberID}/{pos}','AuthController@registration');
Route::get('/refferal/{memberID}/{pos}/{bnb_address}','AuthController@registration');
Route::get('/retailor_refferal/{memberID}','AuthController@registration_retail');

Route::post('/sign-up-verification', 'AuthController@add_user_verification');
Route::post('/sign-up', 'AuthController@add_user');


Route::get('/register','AuthController@registrations');
Route::get('/register-verify','AuthController@registrations_verify');


Route::post('/signup', 'AuthController@signup');

Route::get('/forget_password', function () {
return view('Auth.forget_pass');
});


Route::get('/verification', function () {
    return view('Auth.admin_user_verify_otp');
});

Route::post('/top_verification', 'AuthController@login_verification');

Route::post('/forget_password', 'AuthController@forget_password');
Route::get('/verify_otp', function () 
{
return view('Auth.verify_otp');
});



Route::post('/verify_otp', 'AuthController@verify_otp');
Route::get('/logout', 'AuthController@logout');


Route::post('autocomplete','AuthController@autocomplete');
Route::post('get_details','AuthController@get_details');
Route::post('get_mem_details','AuthController@get_mem_details');

//for user
Route::post('create_win_data','UserController@create_win_data');
Route::post('user_get_details','UserController@get_details');
Route::post('user_get_mem_details','UserController@get_mem_details');

Route::post('get_roles_name','AuthController@get_roles_name');


 Route::get('/home', 'FrontController@index');
 Route::get('/all_games', 'FrontController@games');

 Route::get('/how_to_play', 'FrontController@how_to_play');
 Route::get('/your_referral', 'FrontController@your_referral');
 Route::match(['get','post'],'/latest_winner', 'FrontController@latest_winner');

 Route::get('/spin-games/{name}', 'FrontController@playspingames');
 Route::get('/games/{name}', 'FrontController@playgames');
 Route::post('/get_all_game_data', 'FrontController@get_all_game_data');
 Route::post('/get_index_data', 'FrontController@get_index_data');
 Route::post('/buy_lottery_ticket', 'FrontController@buy_lottery_ticket');
 Route::get('/live_purchase_lottery_data', 'FrontController@live_purchase_lottery_data');
 Route::get('/create_live_game', 'FrontController@create_live_game');
 Route::get('/dummy_game_play', 'FrontController@dummy_game_play');
 Route::get('product/{name}', 'FrontController@product_info');
 Route::get('product/{name}/{id}', 'FrontController@product_info');
 Route::get('product/{name}/{id}/{vid}', 'FrontController@product_variant_info');
 Route::get('products/{cat_name}/{cat_parent_id}', 'FrontController@cat_product_info');
 Route::get('productlist/{cat_name}/{cat_parent_id}', 'FrontController@cat_product_allinfo');
 Route::get('info/{page_name}', 'FrontController@static_content_page');
 Route::get('checkout', 'FrontController@checkout');
 Route::post('add_user_address', 'FrontController@add_user_address');
 Route::post('update_user_address', 'FrontController@update_user_address');
 Route::post('change_cart_type', 'CartController@change_cart_type');
 Route::get('order_confirm/{id}', 'CartController@order_confirm');

 Route::get('view_invoice/{number}', 'FrontController@view_invoice');
 Route::get('view_invoices/{number}', 'FrontController@view_invoices');
 Route::get('my_orders', 'FrontController@my_orders');
 
 Route::post('add_to_cart', 'CartController@addtocart');
 Route::get('get_cart_data', 'CartController@get_cart_data');
 Route::post('remove_cart_pro', 'CartController@remove_cart_pro');
 Route::post('decrease_value_cart_pro', 'CartController@decrease_value_cart_pro');
 Route::post('increase_value_cart_pro', 'CartController@increase_value_cart_pro');


 Route::get('/about_us', 'FrontController@about_us');
 Route::get('/frequently_asked_questions', 'FrontController@frequently_asked_questions');
 Route::get('/dth', 'FrontController@dth');
 Route::get('/broadband', 'FrontController@broadband');
 Route::get('/landline', 'FrontController@landline');
 Route::get('/electricity', 'FrontController@electricity');
 Route::get('/gas', 'FrontController@gas');
 Route::get('/water', 'FrontController@water');
 Route::get('/about-us', 'FrontController@about_us');
 Route::get('/front-services', 'FrontController@services');
 Route::get('/contact_us', 'FrontController@contact_us');
 Route::get('/privacy_policy', 'FrontController@privacy_policy');
 Route::get('/T&C', 'FrontController@T_C');
 Route::get('/contact-us', 'FrontController@contact_us');
 Route::get('/recharges', 'FrontController@recharge');
 Route::get('/moneytransfer', 'FrontController@moneytransfer');
 Route::get('/rental', 'FrontController@rental');
 Route::get('/aeps', 'FrontController@aeps');
 Route::get('/billpayment', 'FrontController@billpayment');
 Route::get('/gst', 'FrontController@gst');
 Route::get('/gstreturn', 'FrontController@gstreturn');

 Route::get('/recharge_card', 'FrontController@recharge_card');
 Route::get('/prepaid_card', 'FrontController@prepaid_card');
 Route::get('/bbps', 'FrontController@bbps');
 Route::get('/fasttag', 'FrontController@fasttag');
 Route::get('/egoverance', 'FrontController@egoverance');
 Route::get('/microatm', 'FrontController@microatm');
 Route::get('/pancard', 'FrontController@pancard');


Route::post('/getMemberName','FrontController@getMemberName');
Route::post('/getEmployeeName','FrontController@getEmployeeName');
Route::post('/getStoreName','FrontController@getStoreName');
Route::post('/getPackageAmount','FrontController@getPackageAmount');
Route::post('/get_city', 'FrontController@get_city');
Route::post('/getIFSCode', 'FrontController@getIFSCode');
Route::post('/fetch_dmrcharge','FrontController@getPDMRcharge');
Route::get('/get_BTCADDRESS', 'FrontController@get_BTCADDRESS');
Route::post('/get_cat', 'FrontController@get_cat');
Route::post('/get_sub_cat', 'FrontController@get_sub_cat');
Route::post('/get_optype', 'FrontController@get_optype');
Route::post('/get_prods', 'FrontController@get_prods');
Route::post('/find_city_by_pincode','FrontController@find_city_by_pincode');

Route::post('get-state','CRMController@get_state');
Route::post('get-city','CRMController@get_city');


Route::get('bbps-testing/{type}', 'BBPSController@bbps_testing');
/************** AFTER LOGIN ADMIN PANEL START******************/


Route::group(['middleware' => 'CheckLogin'], function () {

Route::get('admin_dashboard', 'DashboardController@index');

//BBPS  // By Durgesh
Route::get('bbps-services', 'BBPSController@bbps_services');
Route::get('bbps-bill-payment', 'BBPSController@bbps_bill_payment');
Route::get('search-biller', 'BBPSController@search_biller');
Route::get('bill-fetch', 'BBPSController@bill_fetch');
Route::get('bill-pay-receipt', 'BBPSController@bbps_receipt');
Route::get('bill-quickpay-receipt', 'BBPSController@bbps_quickpay_receipt');
Route::get('bbps-recharge-report', 'BBPSController@bbps_recharge_report');
Route::get('transaction-based-view-complaint', 'BBPSController@bbps_service_based_complaint');
Route::get('transaction-based-complaint', 'BBPSController@bbps_transaction_based_complaint');
Route::get('bbps-complaint-tracking', 'BBPSController@bbps_complaint_tracking');
Route::get('quick-pay-bill', 'BBPSController@bbps_quick_pay_bill');
Route::get('quick-bill-payment', 'BBPSController@quick_bill_payment');

/* active url li route  */ /* BY durgesh */
Route::post('/set_url_name', 'Controller@set_url_name');

/* Registration route  */

Route::get('/setting', function(){
return view('Master.setting-page');
});

Route::get('/shping-setting', function(){
return view('Master.shopingmlm_setting-page');
});


Route::get('/images_size', 'MasterController@ecom_image_size');
Route::post('/ecom_image_size_save', 'MasterController@ecom_image_size_save');
Route::get('/imagesize_status/{id}', 'MasterController@imagesize_status');
Route::get('/imagesize_edit/{id}', 'MasterController@imagesize_edit');
Route::post('/ecom_image_size_update/{id}', 'MasterController@ecom_image_size_update');
Route::post('/check_img_height_width', 'MasterController@ajax_check_img_height_width');


Route::post('/update_shoping_setting', 'MasterController@update_shoping_setting');

Route::get('/registration', 'ProfileController@registration');
Route::post('/add_user', 'ProfileController@add_user');

Route::get('/view_user', 'ProfileController@view_user');
Route::post('/view_user', 'ProfileController@view_user');

Route::get('/edit_user', 'ProfileController@edit_user');
Route::post('/edit_user', 'ProfileController@edit_user');
Route::post('/update_profile','ProfileController@update_userprofile');


Route::get('/reassigned_employee', 'ProfileController@reassigned_employee');
Route::post('/reassigned_employee', 'ProfileController@reassigned_employee');
Route::post('/update_reassigned_emp','ProfileController@update_reassigned_employee');


Route::get('/edit_userbankdetails', 'ProfileController@edit_userbankdetails');
Route::post('/edit_userbankdetails', 'ProfileController@edit_userbankdetails');
Route::post('/update_bankdetails','ProfileController@update_userbankdetails');

Route::get('/edit_userkycdetails', 'ProfileController@edit_userkycdetails');
Route::post('/edit_userkycdetails', 'ProfileController@edit_userkycdetails');
Route::post('/update_kyc','ProfileController@update_userkyc');

Route::get('/edit_shopdetails', 'ProfileController@edit_shopdetails');
Route::post('/edit_shopdetails', 'ProfileController@edit_shopdetails');
Route::post('/update_shop','ProfileController@update_shop');

Route::get('/all_user', 'ProfileController@all_user');
Route::post('/all_user', 'ProfileController@all_user');

Route::get('/all_White_label', 'ProfileController@AllWhiteLabel');
Route::post('/all_White_label', 'ProfileController@AllWhiteLabel');

Route::get('/all_api_user', 'ProfileController@AllApiUser');
Route::post('/all_api_user', 'ProfileController@AllApiUser');

Route::get('/kyc', 'ProfileController@kyc');
Route::post('/kyc', 'ProfileController@kyc');

Route::get('/show_password','ProfileController@change_password');
Route::post('/show_password','ProfileController@change_password');
Route::post('/update_password', 'ProfileController@update_userpassword');

Route::get('/change_gmae_win_number','ProfileController@change_gmae_win_number');
Route::post('/update_game_winning_number','ProfileController@update_game_winning_number');



Route::get('/show_trans_password','ProfileController@change_trans_password');
Route::post('/show_trans_password','ProfileController@change_trans_password');
Route::post('/update_trans_password', 'ProfileController@update_trans_password');


Route::get('/change_mobile','ProfileController@change_mobile');
Route::get('/change_trans_pass','ProfileController@change_trans_pass1');

Route::match(['get','post'],'/transaction_history_list','ProfileController@transaction_history');
Route::post('/chnage_status_coin_transaction', 'ProfileController@chnage_status_coin_transaction');


/* Service route  */
Route::match(['get','post'],'userwise_operator_report', 'ReportController@userwise_operator_report');
Route::match(['get','post'],'commission_report', 'ReportController@commission_reports');
Route::match(['get','post'],'cash-collection-form', 'ReportController@cash_collocation_reports');

Route::get('/aeps_service_request', 'ServiceController@aeps_service_request');
Route::post('/aeps_service_request', 'ServiceController@aeps_service_request');
Route::post('/generate_aepsbcid', 'ServiceController@generate_aepsbcid');
Route::get('/aeps_service_report', 'ServiceController@aeps_service_report');
Route::post('/aeps_service_report', 'ServiceController@aeps_service_report');
Route::post('/generate_dmtbcid', 'ServiceController@generate_dmtbcid');
Route::post('/generate_pancardbcid', 'ServiceController@generate_pancardbcid');
Route::post('/status_pancardpsa', 'ServiceController@status_pancardpsa');

// Employee Registration
Route::get('/employee_reg', 'ProfileController@employee_reg');

Route::get('/edit_employee', 'ProfileController@edit_employee');
Route::post('/edit_employee', 'ProfileController@edit_employee');
Route::post('/update_empprofile','ProfileController@update_empprofile');

Route::get('/edit_empbankdetails', 'ProfileController@edit_empbankdetails');
Route::post('/edit_empbankdetails', 'ProfileController@edit_empbankdetails');
Route::post('/update_empbankdetails','ProfileController@update_empbankdetails');

Route::get('/edit_empkycdetails', 'ProfileController@edit_empkycdetails');
Route::post('/edit_empkycdetails', 'ProfileController@edit_empkycdetails');
Route::post('/update_empkyc','ProfileController@update_empkyc');

Route::get('/view_employee', 'ProfileController@view_employee');
Route::post('/view_employee', 'ProfileController@view_employee');

Route::get('/all_employee', 'ProfileController@all_employee');
Route::post('/all_employee', 'ProfileController@all_employee');

Route::get('/employee_kyc', 'ProfileController@employee_kyc');
Route::post('/employee_kyc', 'ProfileController@employee_kyc');


Route::get('/emp_showpassword','ProfileController@emp_showpassword');
Route::post('/emp_showpassword','ProfileController@emp_showpassword');
Route::post('/update_emppassword', 'ProfileController@update_emppassword');

Route::get('/emp_showtrans_password','ProfileController@change_emptrans_password');
Route::post('/emp_showtrans_password','ProfileController@change_emptrans_password');
Route::post('/update_emptrans_password', 'ProfileController@update_emptrans_password');



Route::post('/user_status', 'ProfileController@user_status');
Route::post('/update_usergroup', 'ProfileController@update_usergroup');
Route::post('/update_usermobileno', 'ProfileController@update_usermobileno');
Route::post('/update_userteam', 'ProfileController@update_userteam');
Route::post('/update_userpassword', 'ProfileController@update_userpassword');
Route::post('/update_userparent', 'ProfileController@update_userparent');

Route::get('/change_status', 'ProfileController@change_status');
Route::post('/change_status', 'ProfileController@change_status');

Route::patch('/update_status', 'ProfileController@update_status');
Route::patch('/stop_all_user', 'ProfileController@stop_all_user');

Route::get('/active_users', 'ProfileController@active_users');
Route::post('/active_users', 'ProfileController@active_users');
Route::get('/deactive_users', 'ProfileController@deactive_users');
Route::post('/deactive_users', 'ProfileController@deactive_users');

Route::get('/emp_changestatus', 'ProfileController@emp_changestatus');
Route::post('/emp_changestatus', 'ProfileController@emp_changestatus');

Route::patch('/emp_updatestatus', 'ProfileController@emp_updatestatus');
Route::patch('/stop_all_emp', 'ProfileController@stop_all_emp');

Route::get('/active_emps', 'ProfileController@active_emps');
Route::post('/active_emps', 'ProfileController@active_emps');
Route::get('/deactive_emps', 'ProfileController@deactive_emps');
Route::post('/deactive_emps', 'ProfileController@deactive_emps');

/* Shop Details Routes Start Here*/
Route::get('/shop_details', 'ProfileController@shop_details');
Route::post('/shop_details', 'ProfileController@shop_details');
Route::post('/user_shopstatus', 'ProfileController@update_shop_status');
/* Shop Details Routes End Here*/

Route::post('/user_kycstatus', 'ProfileController@update_kyc_status');
Route::post('/user_kycresubmit', 'ProfileController@update_kyc_resubmit');


/* Action route  */

Route::get('/change_mobileno', 'ProfileController@change_mobileno');
Route::post('/change_mobileno', 'ProfileController@change_mobileno');
Route::post('/update_mobileno', 'ProfileController@update_usermobileno');


Route::get('/change_email', 'ProfileController@change_email');
Route::post('/change_email', 'ProfileController@change_email');
Route::post('/update_email', 'ProfileController@update_email');


Route::get('/emp_changemobileno', 'ProfileController@emp_changemobileno');
Route::post('/emp_changemobileno', 'ProfileController@emp_changemobileno');
Route::post('/update_empmobileno', 'ProfileController@update_empmobileno');

Route::get('/change_team', 'ProfileController@change_team');
Route::post('/change_team', 'ProfileController@change_team');

Route::get('/change_role', 'ProfileController@change_role');
Route::post('/change_role', 'ProfileController@change_role');
Route::post('/update_user_role', 'ProfileController@update_user_role');

Route::get('/change_slab', 'ProfileController@change_slab');
Route::post('/change_slab', 'ProfileController@change_slab');

Route::post('/update_usergroup', 'ProfileController@update_usergroup');

Route::get('/change_parent', 'ProfileController@change_parent');
Route::post('/change_parent', 'ProfileController@change_parent');


Route::get('/change_password', 'ProfileController@change_password');
Route::post('/change_password', 'ProfileController@change_password');


Route::get('/topup_report', 'ProfileController@topup_report');
Route::post('/topup_report', 'ProfileController@topup_report');
Route::get('/next_topup_report', 'ProfileController@next_topup_report');
Route::post('/next_topup_report', 'ProfileController@next_topup_report');

Route::get('/topup','ProfileController@buy_subscription');
Route::post('/topup','ProfileController@buy_subscription');

Route::get('/datewise_business_detail','ProfileController@datewise_business_detail');
Route::post('/datewise_business_detail','ProfileController@datewise_business_detail');

Route::get('/retopup','ProfileController@renew_subscription');
Route::post('/retopup','ProfileController@renew_subscription');

Route::get('/topup_report', 'ProfileController@topup_report');
Route::post('/topup_report', 'ProfileController@topup_report');


Route::get('/directteam','ProfileController@direct_referal');
Route::post('/directteam','ProfileController@direct_referal');


Route::match(['get','post'],'/all_lotteries', 'ProfileController@all_lotteries');
Route::match(['get','post'],'/live_game_reports', 'ProfileController@live_game_reports');
Route::match(['get','post'],'/all_game_results', 'ProfileController@all_game_results');

Route::match(['get','post'],'/level_wise_team', 'ProfileController@level_wise_team');
Route::match(['get','post'],'/level_userwise_team', 'UserController@level_userwise_team');
Route::match(['get','post'],'/game_results', 'UserController@game_results');
Route::get('/downline', 'ProfileController@user_downline');
Route::post('/downline', 'ProfileController@user_downline');
Route::get('/level_view', 'ProfileController@user_level_view');
Route::get('/tree/{id}', 'ProfileController@tree');
Route::post('/tree', 'ProfileController@tree');

Route::get('/level_applicable', 'ProfileController@level_applicable');
Route::post('/level_applicable', 'ProfileController@level_applicable');


// Recharge Report Routes

Route::match(['get','post'],'/recharge_report_mobile', 'ReportController@recharge_report_mobile');
Route::get('/recharge_report/{status}', 'ReportController@recharge_reports');
Route::get('/recharge_report', 'ReportController@recharge_report');
Route::post('/recharge_report', 'ReportController@recharge_report');

Route::get('/pendingrecharge_report', 'ReportController@pendingrecharge_report');
Route::post('/pendingrecharge_report', 'ReportController@pendingrecharge_report');

Route::get('/refund_report', 'ReportController@refund_report');
Route::post('/refund_report', 'ReportController@refund_report');

Route::get('/ledger', 'ReportController@ledger');
Route::post('/ledger', 'ReportController@ledger');

Route::get('/rechargepayment_summary', 'ReportController@rechargepayment_summary');
Route::post('/rechargepayment_summary', 'ReportController@rechargepayment_summary');

Route::get('/operator_wise', 'ReportController@operator_wise');
Route::post('/operator_wise', 'ReportController@operator_wise');

Route::get('/user_wise', 'ReportController@user_wise');
Route::post('/user_wise', 'ReportController@user_wise');

Route::get('/api_wise', 'ReportController@api_wise');
Route::post('/api_wise', 'ReportController@api_wise');

Route::get('/date_wise', 'ReportController@date_wise');
Route::post('/date_wise', 'ReportController@date_wise');

Route::get('/day_book', 'ReportController@day_book');
Route::post('/day_book', 'ReportController@day_book');
// Recharge Report Routes End Here


// Bill Payment Report Routes
Route::get('/billpay_report', 'ReportController@billpay_report');
Route::post('/billpay_report', 'ReportController@billpay_report');



Route::get('/pendingbillpay_report', 'ReportController@pendingbillpay_report');
Route::post('/pendingbillpay_report', 'ReportController@pendingbillpay_report');

Route::get('/refundbillpay_report', 'ReportController@refundbillpay_report');
Route::post('/refundbillpay_report', 'ReportController@refundbillpay_report');

Route::get('/ledger', 'ReportController@ledger');
Route::post('/ledger', 'ReportController@ledger');

Route::get('/rechargepayment_summary', 'ReportController@rechargepayment_summary');
Route::post('/rechargepayment_summary', 'ReportController@rechargepayment_summary');

Route::get('/operator_wise', 'ReportController@operator_wise');
Route::post('/operator_wise', 'ReportController@operator_wise');



Route::get('/user_wise', 'ReportController@user_wise');
Route::post('/user_wise', 'ReportController@user_wise');

Route::get('/api_wise', 'ReportController@api_wise');
Route::post('/api_wise', 'ReportController@api_wise');

Route::get('/date_wise', 'ReportController@date_wise');
Route::post('/date_wise', 'ReportController@date_wise');
// Bill payment Report Routes End Here

// MONEY TRANSFER Report Routes

Route::match(['get','post'],'/find_moneytransfer', 'ReportController@find_moneytransfer');

Route::get('/dmt_service_request', 'ServiceController@dmt_service_request');
Route::post('/dmt_service_request', 'ServiceController@dmt_service_request');

Route::get('/mtransfer_report/{status}', 'ReportController@mtransfer_reports');
Route::get('/mtransfer_report', 'ReportController@mtransfer_report');
Route::post('/mtransfer_report', 'ReportController@mtransfer_report');

Route::get('/trade_bonustransfer_report/{status}', 'ReportController@trade_bonustransfer_reports');
Route::get('/trade_bonustransfer_report', 'ReportController@trade_bonustransfer_report');
Route::post('/trade_bonustransfer_report', 'ReportController@trade_bonustransfer_report');


Route::post('/refund_mtransfer','ReportController@refund_mtransfer');


Route::get('/pendingmtransfer_report', 'ReportController@pendingmtransfer_report');
Route::post('/pendingmtransfer_report', 'ReportController@pendingmtransfer_report');

Route::get('/refund_mtransfer_report', 'ReportController@refund_mtransfer_report');
Route::post('/refund_mtransfer_report', 'ReportController@refund_mtransfer_report');


Route::get('/user_wise_mtransfer', 'ReportController@user_wise_mtransfer');
Route::post('/user_wise_mtransfer', 'ReportController@user_wise_mtransfer');

Route::get('/api_wise_mtransfer', 'ReportController@api_wise_mtransfer');
Route::post('/api_wise_mtransfer', 'ReportController@api_wise_mtransfer');

Route::get('/date_wise_mtransfer', 'ReportController@date_wise_mtransfer');
Route::post('/date_wise_mtransfer', 'ReportController@date_wise_mtransfer');
// MONEY TRANSFER Report Routes End Here

// AEPS Report Routes
Route::get('/apestransfer_report/{status}', 'ReportController@apestransfer_reports');
Route::get('/apestransfer_report', 'ReportController@apestransfer_report');
Route::post('/apestransfer_report', 'ReportController@apestransfer_report');
Route::post('/refund_apestransfer','ReportController@refund_apestransfer');


Route::get('/pendingapestransfer_report', 'ReportController@pendingapestransfer_report');
Route::post('/pendingapestransfer_report', 'ReportController@pendingapestransfer_report');

Route::get('/refund_apestransfer_report', 'ReportController@refund_apestransfer_report');
Route::post('/refund_apestransfer_report', 'ReportController@refund_apestransfer_report');


Route::get('/user_wise_apestransfer', 'ReportController@user_wise_apestransfer');
Route::post('/user_wise_apestransfer', 'ReportController@user_wise_apestransfer');

Route::get('/api_wise_apestransfer', 'ReportController@api_wise_apestransfer');
Route::post('/api_wise_apestransfer', 'ReportController@api_wise_apestransfer');

Route::get('/date_wise_apestransfer', 'ReportController@date_wise_apestransfer');
Route::post('/date_wise_apestransfer', 'ReportController@date_wise_apestransfer');
// AEPS Report Routes End Here

// MPOS Report Routes
Route::get('/mpostransfer_report', 'ReportController@mpostransfer_report');
Route::post('/mpostransfer_report', 'ReportController@mpostransfer_report');
Route::post('/refund_apestransfer','ReportController@refund_mpostransfer');


Route::get('/pendingmpostransfer_report', 'ReportController@pendingmpostransfer_report');
Route::post('/pendingmpostransfer_report', 'ReportController@pendingmpostransfer_report');

Route::get('/refund_mpostransfer_report', 'ReportController@refund_mpostransfer_report');
Route::post('/refund_mpostransfer_report', 'ReportController@refund_mpostransfer_report');


Route::get('/user_wise_mpostransfer', 'ReportController@user_wise_mpostransfer');
Route::post('/user_wise_mpostransfer', 'ReportController@user_wise_mpostransfer');

Route::get('/api_wise_mpostransfer', 'ReportController@api_wise_mpostransfer');
Route::post('/api_wise_mpostransfer', 'ReportController@api_wise_mpostransfer');

Route::get('/date_wise_mpostransfer', 'ReportController@date_wise_mpostransfer');
Route::post('/date_wise_mpostransfer', 'ReportController@date_wise_mpostransfer');
// MPOS Report Routes End Here


// PANCARD Report Routes

Route::get('/pancard_service_request', 'ServiceController@pancard_service_request');
Route::post('/pancard_service_request', 'ServiceController@pancard_service_request');


Route::get('/pancard_report', 'ReportController@pancard_report');
Route::post('/pancard_report', 'ReportController@pancard_report');
Route::post('/refund_pancard_report','ReportController@refund_pancard_report');


Route::get('/pendingpancard_report', 'ReportController@pendingpancard_report');
Route::post('/pendingpancard_report', 'ReportController@pendingpancard_report');

Route::get('/refund_pancard_report', 'ReportController@refund_pancard_report');
Route::post('/refund_pancard_report', 'ReportController@refund_pancard_report');


Route::get('/user_wise_pancard_report', 'ReportController@user_wise_pancard_report');
Route::post('/user_wise_pancard_report', 'ReportController@user_wise_pancard_report');

Route::get('/api_wise_pancard_report', 'ReportController@api_wise_pancard_report');
Route::post('/api_wise_pancard_report', 'ReportController@api_wise_pancard_report');

Route::get('/date_wise_pancard_report', 'ReportController@date_wise_pancard_report');
Route::post('/date_wise_pancard_report', 'ReportController@date_wise_pancard_report');


//REQUEST AND RESPONSE REPORT
Route::get('/request_of_user', 'ReportController@request_of_user');
Route::post('/request_of_user', 'ReportController@request_of_user');
Route::get('/response_to_user', 'ReportController@response_to_user');
Route::post('/response_to_user', 'ReportController@response_to_user');
Route::get('/request_to_vendor', 'ReportController@request_to_vendor');
Route::post('/request_to_vendor', 'ReportController@request_to_vendor');
Route::get('/response_by_vendor', 'ReportController@response_by_vendor');
Route::post('/response_by_vendor', 'ReportController@response_by_vendor');


// PANCARD Report Routes End Here


Route::patch('/update_rechargestatus','ActionController@update_rechargestatus');
Route::post('/update_rechargetid','ActionController@update_rechargetid');
Route::post('/refund_recharge','ActionController@refund_recharge');
Route::post('/complaint_recharge','ActionController@complaint_recharge');

Route::get('/mt_receipt/{id}', 'ActionController@mt_receipt');
Route::get('/bill_receipt/{id}', 'ActionController@bill_receipt');
Route::post('/hit_callback','ActionController@hit_callback');


Route::post('/api_log','ActionController@api_log');


Route::patch('/update_billpaystatus','ActionController@update_billpaystatus');
Route::post('/update_billpaytid','ActionController@update_billpaytid');
Route::post('/refund_billpay','ActionController@refund_billpay');
Route::post('/complaint_billpay','ActionController@complaint_billpay');
Route::get('/billpay_receipt/{id}', 'ActionController@billpay_receipt');
Route::post('/hitbillpay_callback','ActionController@hitbillpay_callback');



Route::patch('/update_mtstatus','ActionController@update_mtstatus');
Route::post('/update_dmttid','ActionController@update_dmttid');
Route::post('/refund_dmt','ActionController@refund_dmt');
Route::post('/complaint_dmt','ActionController@complaint_dmt');
Route::get('/mt_receipt/{id}', 'ActionController@mt_receipt');
Route::post('/hitmt_callback','ActionController@hitmt_callback');


// Slab Routes
Route::get('/create_slab', 'SlabController@create_slab');
Route::post('/add_slab', 'SlabController@add_slab');
Route::get('/view_slab/{id}', 'SlabController@create_slab');
Route::post('/update_slab/{id}', 'SlabController@update_slab');
Route::post('/slab_status', 'SlabController@slab_status');

Route::get('/prepaid_margin', 'SlabController@prepaid_margin');
Route::post('/prepaid_margin', 'SlabController@prepaid_margin');
Route::post('/update_all_margin', 'SlabController@update_all_margin');
Route::post('/update_margin/{id}', 'SlabController@update_margin');

Route::get('/utility_surcharge', 'SlabController@utility_surcharge');
Route::post('/utility_surcharge', 'SlabController@utility_surcharge');
Route::post('/update_all_utility_surcharge', 'SlabController@update_all_utility_surcharge');
Route::post('/update_utility_surcharge/{id}', 'SlabController@update_utility_surcharge');

Route::get('/dmr_surcharge', 'SlabController@dmr_surcharge');
Route::post('/dmr_surcharge', 'SlabController@dmr_surcharge');
Route::post('/update_all_dmr_surchage', 'SlabController@update_all_dmr_surchage');
Route::post('/update_dmr_surchage/{id}', 'SlabController@update_dmr_surchage');

Route::get('/aeps_margin', 'SlabController@aeps_margin');
Route::post('/update_aepsmargin/{aeps_id}', 'SlabController@update_aepsmargin');
Route::post('/fetch_aepsmargin', 'SlabController@aeps_margin');
Route::patch('/update_aepsmarginto_all', 'SlabController@update_aepsmarginto_all'); 

Route::get('/prepaidapi_sequences', 'SlabController@prepaidapi_sequences');
Route::post('/prepaidapi_sequences', 'SlabController@prepaidapi_sequences');
Route::post('/update_all_prepaidapi_sequences', 'SlabController@update_all_prepaidapi_sequences');
Route::post('/update_prepaidapi_sequences/{id}', 'SlabController@update_prepaidapi_sequences');

Route::get('/denomination_range_sequences', 'SlabController@denomination_range_sequences');
Route::post('/denomination_range_sequences', 'SlabController@denomination_range_sequences');
Route::post('/update_all_denomination_range_sequences', 'SlabController@update_all_denomination_range_sequences');
Route::post('/update_denomination_range_sequences/{id}', 'SlabController@update_denomination_range_sequences');

Route::get('/circle_range_sequences', 'SlabController@circle_range_sequences');
Route::post('/circle_range_sequences', 'SlabController@circle_range_sequences');
Route::post('/update_all_circle_range_sequences', 'SlabController@update_all_circle_range_sequences');
Route::post('/update_circle_range_sequences/{id}', 'SlabController@update_circle_range_sequences');

Route::get('/utilityapi_sequences', 'SlabController@utilityapi_sequences');
Route::post('/utilityapi_sequences', 'SlabController@utilityapi_sequences');
Route::post('/update_all_utilityapi_sequences', 'SlabController@update_all_utilityapi_sequences');
Route::post('/update_utilityapi_sequences/{id}', 'SlabController@update_utilityapi_sequences');

Route::get('/prepaidapi_limit', 'SlabController@prepaidapi_limit');
Route::post('/fetch_prepaidapilimit', 'SlabController@prepaidapi_limit');
Route::post('/update_prepaidapi_limit/{sequence_id}','SlabController@update_prepaidapi_limit');
Route::post('/update_prepaidapilimitto_all', 'SlabController@update_prepaidapilimitto_all');

Route::get('/utilityapi_limit', 'SlabController@utilityapi_limit');
Route::post('/fetch_utilityapilimit', 'SlabController@utilityapi_limit');
Route::post('/update_utilityapi_limit/{sequence_id}','SlabController@update_utilityapi_limit');
Route::post('/update_utilityapilimitto_all', 'SlabController@update_utilityapilimitto_all');

Route::get('/aeps_margin', 'SlabController@aeps_margin');
Route::post('/aeps_margin', 'SlabController@aeps_margin');
Route::post('/update_aepsmarginto_all', 'SlabController@update_aepsmarginto_all');
Route::post('/update_aepsmargin/{id}', 'SlabController@update_aepsmargin');

Route::get('/pan_margin', 'SlabController@pan_margin');
Route::post('/pan_margin', 'SlabController@pan_margin');
Route::post('/update_pantoken_margin/{id}', 'SlabController@update_pantoken_margin');
Route::post('/update_pantokento_all', 'SlabController@update_pantokento_all');
//Slab Routes End Here

//Api Routes End Here
Route::get('/add_api', 'ApiController@add_api');
Route::post('/create_api', 'ApiController@create_api');
Route::get('/view_api/{id}', 'ApiController@view_api');
Route::post('/update_api/{id}', 'ApiController@update_api');
Route::post('/update_all_api', 'ApiController@update_all_api');

Route::get('/api_operator', 'ApiController@api_operator');
Route::post('/api_operator', 'ApiController@api_operator');

Route::get('/ticket_reply','TicketController@ticket_reply');
Route::get('/ticket_assigned','TicketController@ticket_assigned');
Route::post('/ticket_reply','TicketController@submit_reply');
Route::post('/filter-tickets-replys','TicketController@filter_ticket_reply');
Route::post('/filter-assign-tickets','TicketController@filter_ticket_assign');

Route::post('/assigned_ticket','TicketController@assigned_ticket');
Route::post('/reassigned_ticket','TicketController@reassigned_ticket');

Route::get('/ticket-close/{id}','TicketController@ticket_close');




// FUND CONTROLLER 
Route::get('/fund_request', 'FundController@fund_request');
Route::post('/fund_request', 'FundController@fund_request');
Route::post('/fundrequest_status', 'FundController@fundrequest_updatestatus');
Route::post('/wdrequest_status', 'FundController@wdrequest_updatestatus');

Route::get('/fund_transfer', 'FundController@fund_transfer');
Route::post('/fund_transfer', 'FundController@fund_transfer');

Route::match(['get','post'],'cash_collection', 'FundController@cash_collocation');

Route::get('/fund_transfer_store', 'FundController@fund_transfer_store');
Route::post('/fund_transfer_store', 'FundController@fund_transfer_store');

Route::get('/main_ledger', 'FundController@main_ledger');
Route::post('/main_ledger', 'FundController@main_ledger');

Route::get('/fund_ledger', 'FundController@fund_ledger');
Route::post('/fund_ledger', 'FundController@fund_ledger');

Route::get('/payout_ledger', 'FundController@payout_ledger');
Route::post('/payout_ledger', 'FundController@payout_ledger');

Route::get('/payment_summary', 'FundController@payment_summary');
Route::post('/payment_summary', 'FundController@payment_summary');

Route::match(['get','post'],'gateway_request', 'FundController@gateway_request');

/// CLOSING MASTER
// GENERATE LEVEL INCOME REPORT HERE
Route::get('/generate_levelincome','ClosingController@gen_levelbonus');
Route::post('/generate_levelincome','ClosingController@gen_levelbonus');

// GENERATE CASHBACK BONUS REPORT HERE
Route::get('/gen_cashbackbonus','ClosingController@gen_cashback');
Route::post('/gen_cashbackbonus','ClosingController@gen_cashback');

// GENERATE LEVEL INCOME HERE
Route::get('/calculate_final_closing','ClosingController@final_closing');
Route::post('/calculate_final_closing','ClosingController@final_closing');

// CASHBACK BONUS REPORT HERE
Route::get('/bonus_report','ClosingController@cashbackbonus');
Route::post('/bonus_report','ClosingController@cashbackbonus');

// CASHBACK LEVEL BONUS REPORT HERE
Route::get('/chblvl_bonus_report','ClosingController@cashback_lvlbonus');
Route::post('/chblvl_bonus_report','ClosingController@cashback_lvlbonus');


// BINARY CLOSING
Route::get('/binary_closing','ClosingController@binary_closing');
Route::post('/binary_closing','ClosingController@binary_closing');


Route::get('/binary_closing_report','ClosingController@binary_closing_report');
Route::post('/binary_closing_report','ClosingController@binary_closing_report');

Route::get('/binary_closing_reverse','ClosingController@binary_closing_reverse');
Route::post('/binary_closing_reverse','ClosingController@binary_closing_reverse');

Route::get('/binary_closing_publish','ClosingController@binary_closing_publish');
Route::post('/binary_closing_publish','ClosingController@binary_closing_publish');

Route::get('/binary_closing_userwise','ClosingController@binary_closing_userwise');
Route::post('/binary_closing_userwise','ClosingController@binary_closing_userwise');

// GENERATE CASH BACK HERE
Route::get('/generate_bonus','ClosingController@generate_bonus');
Route::post('/generate_bonus','ClosingController@generate_bonus');

// DIRECT BONUS REPORT HERE
Route::get('/refferal_bonus_report','ClosingController@refferal_bonus');
Route::post('/refferal_bonus_report','ClosingController@refferal_bonus');
// LEVEL INCOME BONUS REPORT HERE
Route::get('/level_bonus_report','ClosingController@level_bonus');
Route::post('/level_bonus_report','ClosingController@level_bonus');

// ROI LEVEL INCOME BONUS REPORT HERE
Route::get('/roi_level_bonus_report','ClosingController@roi_level_bonus');
Route::post('/roi_level_bonus_report','ClosingController@roi_level_bonus');


// PAYMENT REPORT HERE
Route::get('/payment_report','ClosingController@payment_report');
Route::post('/payment_report','ClosingController@payment_report');

Route::get('/payment_release','ClosingController@payment_release');
Route::post('/payment_release','ClosingController@payment_release');
Route::post('/pay_payment','ClosingController@pay_payment');

Route::get('/payment_release_report','ClosingController@payment_release_report');
Route::post('/payment_release_report','ClosingController@payment_release_report');



// Vendor routes  MLM PROJECT 
Route::get('/category', 'VendorController@category');
Route::get('/category/{cat_id}', 'VendorController@category');
Route::post('/add_category', 'VendorController@add_category');
Route::post('/update_category/{cat_id}', 'VendorController@update_category');

Route::get('/subcategory', 'VendorController@subcategory');
Route::get('/subcategory/{subcategory_id}', 'VendorController@subcategory');
Route::post('/add_subcategory', 'VendorController@add_subcategory');
Route::post('/update_subcategory/{subcategory_id}', 'VendorController@update_subcategory');

Route::post('/get_subcat','VendorController@get_subcat');

Route::get('/vendor_entry', 'VendorController@vendor');
Route::post('/add_vendor', 'VendorController@add_vendor');
Route::get('/view_vendor/{id}', 'VendorController@vendor');
Route::post('/edit_vendor/{id}', 'VendorController@update_vendor');

Route::get('/product_detail', 'VendorController@product_detail');
Route::post('/add_product', 'VendorController@add_product');
Route::get('/view_product/{id}', 'VendorController@product_detail');
Route::post('/edit_product/{id}', 'VendorController@update_product');
Route::get('/delete_product/{id}', 'VendorController@delete_product');

Route::get('/product_stock', 'VendorController@product_stock');
Route::post('/add_stock', 'VendorController@add_stock');

Route::post('/get_user','VendorController@get_user');
Route::get('/store', 'VendorController@store');
Route::post('/add_store', 'VendorController@add_store');
Route::get('/view_store/{id}', 'VendorController@store');
Route::post('/edit_store/{id}', 'VendorController@update_store');

Route::get('/prod_reqfrmstr', 'VendorController@prod_reqfrmstr');
Route::get('/prev_req', 'VendorController@prev_req');
Route::get('/verify_status/{id}', 'VendorController@req_verifystatus');
Route::get('/reject_status/{id}', 'VendorController@req_rejectstatus');






// Franchisee Controller Routes MLM PRODUCT
Route::get('/product_req', 'FranchiseController@product_req');
Route::post('/get_request', 'FranchiseController@get_request');

Route::get('/product_req_history', 'FranchiseController@product_req_history');
Route::get('/product_purchase', 'FranchiseController@product_purchase');
Route::get('/product_cancel', 'FranchiseController@product_cancel');
Route::get('/product_sale', 'FranchiseController@product_sale');

Route::post('/purchase_entry', 'FranchiseController@buy_product');
Route::get('/cancel_invoice/{id}', 'FranchiseController@cancel_invoice');

Route::get('/invoice_entry', 'FranchiseController@view_invcentry');
Route::post('/invoice_entry', 'FranchiseController@invoice_entry');
Route::post('/prod_autocomplete','FranchiseController@prod_autocomplete');
Route::post('/get_prod','FranchiseController@get_prod');
Route::post('/getuser_details','FranchiseController@getuser_details');
Route::post('/get_packamt','FranchiseController@get_packamt');

Route::get('/invoice_listing', 'FranchiseController@invoice_listing');
Route::get('view_goldinvoice/{id}', 'FranchiseController@view_invoice');

Route::get('/franchisee_dashboard','FranchiseController@franchisee_dashboard');

Route::get('/finvoice_entry', 'FranchiseController@fview_invcentry');
Route::post('/finvoice_entry', 'FranchiseController@finvoice_entry');

//Franchise Controller Routes End Here


Route::get('/view_soft_login', 'MasterController@view_soft_login');
Route::post('/update_soft_login/{id}', 'MasterController@update_soft_login');
Route::post('/update_soft_logins/{id}', 'MasterController@update_soft_logins');

Route::get('/view_bank', 'MasterController@view_bank');
Route::get('/view_bank/{id}', 'MasterController@view_bank');
Route::post('/add_bank_master', 'MasterController@add_bank');
Route::post('/update_bank_detail/{id}', 'MasterController@update_bank_detail');
Route::post('/bank_status', 'MasterController@bank_status');


Route::get('/bank_account', 'MasterController@bank_account');
Route::get('/bank_account/{id}', 'MasterController@bank_account');
Route::post('/add_bank_account', 'MasterController@add_bank_account');
Route::post('/update_bank_account/{id}','MasterController@update_bank_account');
Route::post('/bank_account_status','MasterController@bank_account_status');


Route::get('/user_directory/', 'MasterController@user_directory');

Route::get('/view_news/', 'MasterController@view_news');
Route::get('/view_event/', 'MasterController@view_event');
Route::post('/add_news/', 'MasterController@add_news');
Route::get('/view_news/{id}', 'MasterController@view_news');
Route::post('/update_news_detail/{id}', 'MasterController@update_news_detail');
Route::post('/news_status', 'MasterController@news_status');


Route::get('/view_config', 'MasterController@view_config');
Route::get('/view_config/{config}', 'MasterController@view_config');
Route::post('/update_siteconfig/{admin}', 'MasterController@update_siteconfig');
Route::post('/add_mainconfig', 'MasterController@add_mainconfig');
Route::patch('/update_mainconfig/{admin}', 'MasterController@update_mainconfig');
Route::post('/update_siteimage/{config}', 'MasterController@update_siteimage');

// Country routes
Route::get('/country', 'MasterController@country');
Route::get('/country/{country_id}', 'MasterController@country');
Route::post('/add_country', 'MasterController@add_country');
Route::post('/update_country/{country_id}', 'MasterController@update_country');
Route::post('/country_status', 'MasterController@country_status');

// State routes
Route::get('/state', 'MasterController@state');
Route::get('/state/{state_id}', 'MasterController@state');
Route::post('/add_state', 'MasterController@add_state');
Route::post('/update_state/{state_id}', 'MasterController@update_state');
Route::post('/state_status', 'MasterController@state_status');

// City routes
Route::get('/city', 'MasterController@city');
Route::get('/city/{city_id}', 'MasterController@city');
Route::post('/add_city', 'MasterController@add_city');
Route::post('/update_city/{city_id}', 'MasterController@update_city');
Route::post('/city_status', 'MasterController@city_status');


// Package routes
Route::get('/package', 'MasterController@view_package');
Route::post('/package', 'MasterController@view_package');
Route::post('/add_package', 'MasterController@add_package');
Route::get('/view_package/{package}', 'MasterController@view_package');
Route::post('/update_package/{package}', 'MasterController@update_package');
Route::post('/package_status','MasterController@package_status');


// Operator routes
Route::get('/operator', 'MasterController@operator');
Route::post('/add_operator', 'MasterController@add_operator');
Route::get('/operator/{operator_id}', 'MasterController@operator');
Route::post('/update_operator/{operator_id}', 'MasterController@update_operator');
Route::post('/operator_status', 'MasterController@operator_status');

Route::get('/service', 'MasterController@service');
Route::post('/create_service', 'MasterController@create_service');
Route::get('/edit_service/{id}', 'MasterController@service');
Route::post('/update_service/{id}', 'MasterController@update_service');

Route::get('/message', 'MasterController@message');
Route::get('/message/{message_id}', 'MasterController@message');
Route::post('/add_message', 'MasterController@add_message');
Route::post('/update_message/{message_id}', 'MasterController@update_message');
Route::post('/message_status', 'MasterController@message_status');

Route::get('/static_cnt', 'MasterController@static_cnt');
Route::get('/static_cnt/{static_cnt_id}', 'MasterController@static_cnt');
Route::post('/add_static_cnt', 'MasterController@add_static_cnt');
Route::post('/update_static_cnt/{static_cnt_id}', 'MasterController@update_static_cnt');
Route::post('/static_cnt_status', 'MasterController@static_cnt_status');


Route::get('/banner', 'MasterController@view_banner');
Route::post('/add_banner', 'MasterController@create_banner');
Route::get('/view_banner/{id}', 'MasterController@view_banner');
Route::post('/update_banner/{id}', 'MasterController@update_banner');


Route::get('/banner_images', 'MasterController@ecom_bannerimages');
Route::post('/add_banners', 'MasterController@user_add_banner');
Route::get('/edit_banner/{id}', 'MasterController@user_edit_banner');
Route::post('/update_banners/{id}', 'MasterController@user_update_banner');
Route::get('/status_change/{id}', 'MasterController@banner_status_change');

Route::get('/assign_menu', 'MasterController@assign_menu');
Route::post('/add_menu', 'MasterController@add_menu');
Route::get('/view_menu/{id}', 'MasterController@assign_menu');
Route::post('/update_menu/{id}', 'MasterController@update_menu');
Route::post('/menu_status', 'MasterController@menu_status');

Route::get('/user_menu', 'MasterController@user_menu');
Route::post('/add_usermenu', 'MasterController@add_usermenu');
Route::get('/view_usermenu/{id}', 'MasterController@user_menu');
Route::post('/update_usermenu/{id}', 'MasterController@update_usermenu');
Route::post('/usermenu_status', 'MasterController@usermenu_status');

Route::get('/user_assign_menu', 'MasterController@user_assign_menu');
Route::post('/user_assign_menu', 'MasterController@user_assign_menu');
Route::post('/add_user_assign_menu','MasterController@add_user_assign_menu');

Route::get('/emp_assign_menu', 'MasterController@emp_assign_menu');
Route::post('/emp_assign_menu', 'MasterController@emp_assign_menu');
Route::post('/add_emp_assign_menu','MasterController@add_emp_assign_menu');

Route::get('/user_assign_services', 'MasterController@user_assign_services');
Route::post('/user_assign_services', 'MasterController@user_assign_services');
Route::post('/add_user_assign_services','MasterController@add_user_assign_services');

Route::get('/setting', 'MasterController@setting');
Route::post('/update-setting', 'MasterController@update_setting');


//PRODUCT CONTROLLER ROUTES STARTS HERE  SHOPPING CART

Route::get('/parent_cat', 'ProductController@parent_cat');
Route::post('/add_parentcat', 'ProductController@add_parentcat');
Route::get('/edit_parentcat/{id}', 'ProductController@parent_cat');
Route::post('/update_parentcat/{id}', 'ProductController@update_parentcat');

Route::get('/categories', 'ProductController@view_category');
Route::post('/create_cat', 'ProductController@create_category');
Route::get('/view_cat/{id}', 'ProductController@view_category');
Route::post('/update_cat/{id}', 'ProductController@update_category');
Route::post('/cat_status', 'ProductController@category_status');

Route::get('/sub_categories', 'ProductController@view_subcategory');
Route::post('/create_subcat', 'ProductController@create_subcategory');
Route::get('/view_subcat/{id}', 'ProductController@view_subcategory');
Route::post('/update_subcat/{id}', 'ProductController@update_subcategory');
Route::post('/subcat_status', 'ProductController@subcategory_status');


Route::get('/brand', 'ProductController@view_brand');
Route::post('/create_brand', 'ProductController@create_brand');
Route::get('/view_brand/{id}', 'ProductController@view_brand');
Route::post('/update_brand/{id}', 'ProductController@update_brand');
Route::post('/brand_status', 'ProductController@brand_status');

Route::get('/option', 'ProductController@view_option');
Route::post('/create_option', 'ProductController@create_option');
Route::get('/view_option/{id}', 'ProductController@view_option');
Route::post('/update_option/{id}', 'ProductController@update_option');
Route::post('/option_status', 'ProductController@option_status');

Route::get('/option_type', 'ProductController@view_option_type');
Route::post('/create_option_type', 'ProductController@create_option_type');
Route::get('/view_option_type/{id}', 'ProductController@view_option_type');
Route::post('/update_option_type/{id}', 'ProductController@update_option_type');
Route::post('/option_type_status', 'ProductController@option_type_status');

Route::get('/unit', 'ProductController@view_unit');
Route::post('/create_unit', 'ProductController@create_unit');
Route::get('/view_unit/{id}', 'ProductController@view_unit');
Route::post('/update_unit/{id}', 'ProductController@update_unit');
Route::post('/unit_status', 'ProductController@unit_status');

Route::get('/market_listing', 'ProductController@market_listing');
Route::get('/create_market', 'ProductController@create_market');
Route::post('/add_market', 'ProductController@add_market');
Route::get('/edit_market/{id}', 'ProductController@edit_market');
Route::post('/update_market/{id}', 'ProductController@update_market');
Route::post('/prod_market', 'ProductController@market_status');

Route::get('/products', 'ProductController@view_product');
Route::get('/create_prod', 'ProductController@create_prod');
Route::post('/create_prod', 'ProductController@create_product');
Route::get('/view_prod/{id}', 'ProductController@edit_product');
Route::post('/update_prod/{id}', 'ProductController@update_product');
Route::post('/prod_status', 'ProductController@product_status');

Route::get('/product_variant', 'ProductController@product_variant');
Route::get('/create_variant', 'ProductController@create_variant');
Route::post('/create_variant', 'ProductController@add_variant');
Route::get('/view_variant/{id}', 'ProductController@edit_variant');
Route::post('/update_variant/{id}', 'ProductController@update_variant');
Route::post('/variant_status', 'ProductController@update_variant');

Route::get('/orders', 'OrderController@orders');
Route::post('/orders', 'OrderController@orders');

Route::get('/send_orders', 'OrderController@send_orders');
Route::post('/send_orders', 'OrderController@send_orders');
//shiprocet 
Route::get('/view_send_order/{id}', 'OrderController@view_send_order');
Route::post('/order_send', 'OrderController@send_order');
Route::post('/assign_awb', 'OrderController@assign_awb');
Route::post('/shipmentpickuprequest', 'OrderController@shipmentpickuprequest');
Route::post('/generate_invoice', 'OrderController@generateinvoice');
Route::post('/order_cancel', 'OrderController@ordercancel');


Route::get('/delivered_orders', 'OrderController@delivered_orders');
Route::post('/delivered_orders', 'OrderController@delivered_orders');

Route::get('/view_order', 'OrderController@view_order');
Route::post('/view_order', 'OrderController@view_order');

Route::get('/edit_order', 'OrderController@edit_order');
Route::post('/edit_order', 'OrderController@edit_order');
Route::post('/update_order', 'OrderController@update_order');
Route::post('/update_revised_qty', 'OrderController@update_revised_qty');



//for user 
Route::get('/user_orders', 'UserController@orders');
Route::post('/user_orders', 'UserController@orders');

Route::post('/user_cancel_order', 'UserController@user_cancel_order');

Route::get('/user_delivered_orders', 'UserController@delivered_orders');
Route::post('/user_delivered_orders', 'UserController@delivered_orders');

Route::get('/user_view_order', 'UserController@view_order');
Route::post('/user_view_order', 'UserController@view_order');

Route::get('/user_edit_order', 'UserController@edit_order');
Route::post('/user_edit_order', 'UserController@edit_order');
Route::post('/user_update_order', 'UserController@update_order');
Route::post('/user_update_revised_qty', 'UserController@update_revised_qty');


//for employee user 
Route::get('/emp_orders', 'EmployeeController@orders');
Route::post('/emp_orders', 'EmployeeController@orders');

Route::get('/emp_delivered_orders', 'EmployeeController@delivered_orders');
Route::post('/emp_delivered_orders', 'EmployeeController@delivered_orders');

Route::get('/emp_view_order', 'EmployeeController@view_order');
Route::post('/emp_view_order', 'EmployeeController@view_order');

Route::get('/emp_edit_order', 'EmployeeController@edit_order');
Route::post('/emp_edit_order', 'EmployeeController@edit_order');
Route::post('/emp_update_order', 'EmployeeController@update_order');
Route::post('/emp_update_revised_qty', 'EmployeeController@update_revised_qty');

//PRODUCT CONTROLLER ROUTES ENDS HERE


Route::get('translation_en','LocaleController@translation_en');
Route::get('translation_gu','LocaleController@translation_gu');
Route::get('translation_hi','LocaleController@translation_hi');
Route::get('translation_mr','LocaleController@translation_mr');
Route::get('translation_pu','LocaleController@translation_pu');
Route::get('translation_bg','LocaleController@translation_bg');
Route::post('translation','LocaleController@add_translation');
Route::post('edit_translation','LocaleController@edit_translation');



Route::get('/bonanza', 'MasterController@bonanza');


/************** AFTER LOGIN ADMIN PANEL END******************/

/************** AFTER LOGIN USER PANEL START******************/


//////////////////////////////// USER Panel ////////////////////////////////
Route::get('/user_dashboard','UserController@index');
Route::post('/user_dashboard','UserController@index');

Route::get('/user_registration','UserController@registration');
Route::post('/user_adduser', 'UserController@add_user');
Route::get('/user_paypal_payment', 'UserController@paypal_view');

//////////USER RECHARGE PANEL///////
Route::get('/user-add-money-wallet','UserController@user_add_money_wallet');
Route::post('/user-add-money-wallet','UserController@user_add_money_wallets');
Route::post('/payment-completeuser-addmoneywall','UserController@AddMoneyWallet');


Route::get('/add-fund-wallet', 'UserController@add_fund_wallet');
Route::post('/add-fund-wallet', 'UserController@add_fundwallet');


Route::get('/add-fund-wallet-vcl', 'UserController@add_fund_wallet_vcl');
Route::post('/add-fund-wallet-vcl', 'UserController@add_fundwallet_vcl');
Route::post('/add-fund-wallet-vcl-verify', 'UserController@add_fundwallet_vcl_verify');
Route::get('/cancelled-vcl-verify', 'UserController@cancelled_fundwallet_vcl');

Route::post('/do_tronrecharge','UserController@do_tronrecharge');
Route::get('/do_tronrecharge_status','UserController@status_check');
Route::get('/do_tronrecharge_status_cron','UserController@status_check_cron');
Route::get('/do_tronrecharge_back','UserController@do_tronrecharge_back');

Route::get('/user_recharge_panel','UserController@user_recharge_panel');
Route::post('/user_recharge_panel','UserController@user_recharge_panel');

Route::post('/recharge','UserController@do_recharge');
Route::post('/dthrecharge','UserController@do_dthrecharge');

Route::get('/user_dth_panel','UserController@user_dth_panel');
Route::get('/user_broadband_panel','UserController@user_broadband_panel');
Route::get('/user_landline_panel','UserController@user_landline_panel');
Route::get('/user_electricity_panel','UserController@user_electricity_panel');
Route::get('/user_gasbill_panel','UserController@user_gasbill_panel');
Route::get('/user_waterbill_panel','UserController@user_waterbill_panel');

Route::post('/boardband','UserController@do_utilitypayment');
Route::post('/landline','UserController@do_utilitypayment');
Route::post('/electricity','UserController@do_utilitypayment');
Route::post('/gas','UserController@do_utilitypayment');
Route::post('/water','UserController@do_utilitypayment');

Route::post('/fetch_plan','UserController@fetch_rechargeplan');
Route::post('/fetch_dthinfo','UserController@fetch_dthinfo');
Route::post('/fetch_bill','UserController@check_bill');

//////////USER RECHARGE PANEL ENDS HERE///////

Route::get('/user_payu_payment', 'UserController@payu_view');
Route::post('/user_payu_payment', 'UserController@payu_view');

Route::get('/user_refferal_center','UserController@refferalcenter');
Route::post('/user_refferal_center','UserController@refferalcenter');

Route::get('/user_profile','UserController@view_userprofile');
Route::get('/edit_userprofile','UserController@edit_userprofile');
Route::post('/update_userprofile','UserController@update_userprofile');

Route::get('/user/pan_user_history','UserController@panuserhistory');
Route::post('/user/pan_user_history','UserController@postpanuserhistory');


Route::get('/edit_userkyc','UserController@edit_userkyc');
Route::post('/update_userkyc','UserController@update_userkyc');

Route::get('/edit_userbank','UserController@edit_userbank');
Route::post('/update_userbankdetails','UserController@update_userbankdetails');

Route::get('/user_update_shopdetails','UserController@user_update_shopdetails');
Route::post('/user_update_shop_details','UserController@user_update_shop_details');


Route::get('/change_userpassword','UserController@change_password');
Route::post('/change_userpassword','UserController@update_password');

Route::get('/change_transpassword','UserController@change_transpassword');
Route::post('/change_transpassword','UserController@update_transpassword');

Route::get('/doc','UserController@welcome_letter');


Route::get('/user_topup','UserController@usertopup');
Route::post('/buy_subscription','UserController@buy_subscription');
Route::get('/user_topup_detail','UserController@usertopupdetail');
Route::post('/user_topup_detail','UserController@usertopupdetail');

Route::get('/transaction_history','UserController@transaction_history');
Route::post('/transaction_history','UserController@transaction_history');

Route::get('/user_ftopup_detail','UserController@userftopupdetail');
Route::post('/user_ftopup_detail','UserController@userftopupdetail');

Route::get('/user_datewise_business','UserController@user_datewise_business');
Route::post('/user_datewise_business','UserController@user_datewise_business');



Route::get('/usertree/{id}', 'UserController@usertreeview');
Route::post('/user_tree', 'UserController@usertreeview');
Route::get('/user_tree_view', 'UserController@usertreeview');

Route::get('/user_team_downline','UserController@userteamdownline');
Route::post('/user_team_downline','UserController@userteamdownline');

Route::get('/direct_referral','UserController@directreferral');
Route::post('/direct_referral','UserController@directreferral');

Route::get('/user/level_downline','UserController@leveldownline');
Route::post('/user/level_downline','UserController@postleveldownline');


// USER FUND REQUEST ROUTES START HERE
Route::get('/user_fundrequestto_admin_view','UserController@user_fundrequestto_admin_view');
Route::post('/user_fundrequestto_admin','UserController@user_fundrequestto_admin');

Route::get('/user_fundtransferto_team_view','UserController@user_fundtransferto_team_view');
Route::post('/user_fundtransferto_team','UserController@user_fundtransferto_team');

Route::get('/user_fundrequestto_upline_view','UserController@user_fundrequestto_upline_view');
Route::post('/user_fundrequestto_upline','UserController@user_fundrequestto_upline');

Route::get('/user_wallettowallet','UserController@user_wallettowallet');
Route::post('/user_wallettowallet','UserController@user_wallettowallet');
// USER FUND REQUEST ROUTES END HERE


Route::get('/user_fund_transfer', 'UserController@fund_transfer');
Route::post('/user_fund_transfer', 'UserController@fund_transfer');


Route::post('/generate_btcaddress','UserController@generate_btcaddress');
Route::post('/generate_ethaddress','UserController@generate_ethaddress');


Route::get('/user_fund_request_status','UserController@fundrequeststatus');
Route::post('/user_fund_request_status','UserController@fundrequeststatus');


Route::get('/user_creditstatement','UserController@user_creditstatement');
Route::post('/user_creditstatement','UserController@user_creditstatement');

Route::get('/user_accountstatement','UserController@user_accountstatement');
Route::post('/user_accountstatement','UserController@user_accountstatement');

Route::get('/user_fundtransferto_team','UserController@user_fundtransferto_team');
Route::post('/user_fundtransferto_team','UserController@user_fundtransferto_team');

Route::get('/user_team_bonus','UserController@matchingbonus');
Route::post('/user_team_bonus','UserController@matchingbonus');

Route::get('/user_refferal_bonus','UserController@refferalbonus');
Route::post('/user_refferal_bonus','UserController@refferalbonus');

Route::get('/user_level_bonus','UserController@levelbonus');
Route::post('/user_level_bonus','UserController@levelbonus');

Route::get('/user_genlevel_bonus','UserController@gen_levelbonus');
Route::post('/user_genlevel_bonus','UserController@gen_levelbonus');

Route::get('/user_coin_bonus','UserController@coinbonus');
Route::post('/user_coin_bonus','UserController@coinbonus');

Route::get('/user_cashback_bonus','UserController@cashbackbonus');
Route::post('/user_cashback_bonus','UserController@cashbackbonus');

Route::get('/user_cashback_lvl','UserController@cashback_lvl');
Route::post('/user_cashback_lvl','UserController@cashback_lvl');

Route::get('/user/bonanza_status','UserController@bonanzastatus');
Route::post('/user/bonanza_status','UserController@postbonanzastatus');
Route::get('/user/bonanza_reward_status','UserController@bonanzarewardstatus');
Route::post('/user/bonanza_reward_status','UserController@postbonanzarewardstatus');


Route::get('/user_rank_reward','UserController@user_rank_reward');
Route::post('/update_reward','UserController@update_reward');

Route::get('/user_payout_ledger','UserController@user_payout_ledger');
Route::post('/user_payout_ledger','UserController@user_payout_ledger');

Route::get('/user_coin_ledger','UserController@user_coin_ledger');
Route::post('/user_coin_ledger','UserController@user_coin_ledger');

Route::get('/user_cashback_ledger','UserController@user_cashback_ledger');
Route::post('/user_cashback_ledger','UserController@user_cashback_ledger');

Route::get('/user_promotional_ledger','UserController@user_promotional_ledger');
Route::post('/user_promotional_ledger','UserController@user_promotional_ledger');

//DIRECT OR REFERRAL BONUS POINT WITHDRAW REQUEST & REPORT
Route::get('/referral_withdraw_request','UserController@direct_withdraw_request');
Route::post('/referral_withdraw_request','UserController@direct_withdraw_request');

Route::get('/referral_withdraw_req_status','UserController@direct_withdraw_req_status');
Route::post('/referral_withdraw_req_status','UserController@direct_withdraw_req_status');

Route::get('/referral_withdraw_report','UserController@direct_withdraw_report');
Route::post('/referral_withdraw_report','UserController@direct_withdraw_report');

//MATCHING OR TEAM BONUS POINT WITHDRAW REQUEST & REPORT

Route::get('/withdraw_request','UserController@matchingwithdraw_request');
Route::post('/withdraw_request','UserController@matchingwithdraw_request');

Route::get('/trade_withdraw_request','UserController@trade_withdraw_request');
Route::post('/trade_withdraw_request','UserController@trade_withdraw_request');

Route::get('/withdraw_req_status','UserController@matchingwithdraw_req_status');
Route::post('/withdraw_req_status','UserController@matchingwithdraw_req_status');

Route::get('/withdraw_report','UserController@matchingwithdraw_report');
Route::post('/withdraw_report','UserController@matchingwithdraw_report');

Route::get('/trade_withdraw_report','UserController@trade_withdraw_report');
Route::post('/trade_withdraw_report','UserController@trade_withdraw_report');


Route::get('/bonanza_status','UserController@bonanza_status');
Route::get('/bonanza_reward_status','UserController@bonanza_reward_status');


//CASH BACK OR BONUS POINT WITHDRAW REQUEST & REPORT
Route::get('/cbwithdraw_request','UserController@cbwithdraw_request');
Route::post('/cbwithdraw_req_status','UserController@cbwithdraw_request');

Route::get('/cbwithdraw_req_status','UserController@cbwithdraw_req_status');
Route::post('/user/cashback_request_status','UserController@cbwithdraw_req_status');

Route::get('/cbwithdraw_report','UserController@cbwithdraw_report');
Route::post('/cbwithdraw_report','UserController@cbwithdraw_report');


Route::get('ppt','UserController@ppt');
Route::get('plan','UserController@plan');

Route::get('/user/news','UserController@news');
Route::post('/user/news','UserController@postnews');
Route::get('/user_sent_query','UserController@usersentquery');
Route::post('/user_sent_query','UserController@postusersentquery');
Route::get('/inbox','UserController@inbox');
Route::post('/inbox','UserController@postinbox');


Route::get('/sent_query','UserController@usersentquery');
Route::post('/sent_query','UserController@usersentquery');

Route::get('/new_inbox','UserController@inbox');
Route::post('/new_inbox','UserController@inbox');

Route::get('/unread_query','UserController@unread_query');
Route::post('/unread_query','UserController@unread_query');

Route::get('/mail', function () {
return view('Email.mail');
});


//USER RECHARGE ROUTES HERE
Route::get('/user_rechargereport','UserController@user_rechargereport');
Route::post('/user_rechargereport','UserController@user_rechargereport');

Route::get('/user_refundereport','UserController@user_refundereport');
Route::post('/user_refundereport','UserController@user_refundereport');

Route::get('/user_operatorwise','UserController@user_operatorwise');
Route::post('/user_operatorwise','UserController@user_operatorwise');

Route::get('/user_datewise','UserController@date_wise');
Route::post('/user_datewise','UserController@date_wise');

Route::get('/user_dmtreport','UserController@user_dmtreport');
Route::post('/user_dmtreport','UserController@user_dmtreport');

Route::get('/user_refund_mtransfer_report', 'UserController@refund_mtransfer_report');
Route::post('/user_refund_mtransfer_report', 'UserController@refund_mtransfer_report');

Route::get('/user_dw_mtransfer', 'UserController@date_wise_mtransfer');
Route::post('/user_dw_mtransfer', 'UserController@date_wise_mtransfer');

Route::get('/aeps_settelment_report', 'UserController@aeps_settelment_report');
Route::post('/aeps_settelment_report', 'UserController@aeps_settelment_reports');

Route::get('/aeps_settelmentreport', 'ReportController@aeps_settelmentreport');
Route::post('/aeps_settelmentreport', 'ReportController@aeps_settelmentreport');

Route::get('/aeps_login','UserController@aeps_web_login');
Route::get('/user_aepsreport','UserController@user_aepsreport');
Route::post('/user_aepsreport','UserController@user_aepsreport');

Route::get('/user_refund_apestransfer_report', 'UserController@refund_apestransfer_report');
Route::post('/user_refund_apestransfer_report', 'UserController@refund_apestransfer_report');

Route::get('/user_dw_apestransfer', 'UserController@date_wise_apestransfer');
Route::post('/user_dw_apestransfer', 'UserController@date_wise_apestransfer');

Route::get('/user_account_statement','UserController@user_account_statement');
Route::post('/user_account_statement','UserController@user_account_statement');

Route::get('/user_credit_statement','UserController@user_credit_statement');
Route::post('/user_credit_statement','UserController@user_credit_statement');

Route::get('/money_transfer','UserController@money_transfer');
Route::post('/user_dmtlogin','UserController@user_dmtlogin');
Route::get('/user_dmtbeneficiary_list','UserController@user_dmtbeneficiary_list');

Route::post('/account_validate_bc','UserController@account_validate_bc');

Route::get('/airtel_money','UserController@airtel_money');
Route::post('/user_dmtairtel_expresslogin','UserController@user_dmtairtel_expresslogin');
Route::get('/user_dmtairtel_dashboard','UserController@user_dmtairtel_expressdashboard');

Route::get('/user_dmtairtelbeneficiary','UserController@user_dmtairtel_expressbeneficiary');
Route::post('/add_dmtairtelbeneficiary','UserController@user_add_dmtairtel_express_beneficiary');

Route::get('/verify_dmtairtel_express_beneficiary/{ac}/{bcno}/{no}','UserController@verify_dmtairtel_express_beneficiary');
Route::post('/verify_dmtairtel_express_beneficiary/{ac}/{bcno}/{no}','UserController@verify_dmtairtel_express_beneficiary');


Route::get('/user_dmtregisterairtel_express','UserController@user_dmtregisterairtel_express');
Route::post('/user_dmtregisterairtel_express','UserController@user_dmtregisterairtel_express');

Route::post('/send_dmt_otp','UserController@send_dmt_otp');
Route::post('/verification_dmt_otp','UserController@verification_dmt_otp');




Route::get('user_bill_payreport','UserController@billpay_report');
Route::post('user_bill_payreport','UserController@billpay_report');

Route::get('all_remitter','UserController@all_remitter');
Route::post('all_remitter','UserController@all_remitter');

//USER RECHARGE ROUTES ENDS HERE



//EMPLOYEE ROUTES HERE


Route::get('/employee_dashboard', 'EmployeeController@index');

Route::get('/accountsemp_dashboard', 'EmployeeController@index');

Route::get('/supportemp_dashboard', 'EmployeeController@index');

Route::get('/technicalemp_dashboard', 'EmployeeController@index');

Route::get('/backofficeemp_dashboard', 'EmployeeController@index');

Route::get('/salesemp_dashboard', 'EmployeeController@index');

Route::get('/employee_ticket_reply','EmployeeController@ticket_reply');
Route::get('/employee_close_ticket','EmployeeController@ticket_reply_close');
Route::post('/filter_ticket_reply','EmployeeController@filter_ticket_reply');

Route::get('/employee_ticket_reply/{id}','EmployeeController@view_help_desk');
Route::post('/employee_ticket_reply','EmployeeController@submit_reply');



Route::get('/emp_profile','EmployeeController@view_empprofile');
Route::get('/emp_edit_profile','EmployeeController@edit_employeeprofile');
Route::post('/emp_updateprofile','EmployeeController@update_employeeprofile');

Route::get('/emp_edit_bank','EmployeeController@edit_empbank');
Route::post('/emp_updatebankdetails','EmployeeController@update_employeebank');

Route::get('/emp_edit_kyc','EmployeeController@edit_empkyc');
Route::post('/emp_updatekyc','EmployeeController@update_employeekyc');

Route::get('/emp_change_password','EmployeeController@change_emppassword');
Route::post('/emp_change_password','EmployeeController@update_emppassword');

Route::get('/emp_change_transpassword','EmployeeController@change_emptranspassword');
Route::post('/emp_change_transpassword','EmployeeController@update_emptranspassword');









// Employee Fund Request Routes
Route::get('/emp_fund_request', 'EmployeeController@fund_request');
Route::post('/emp_fund_request', 'EmployeeController@fund_request');
Route::post('/emp_fundrequest_status', 'EmployeeController@fundrequest_updatestatus');

Route::get('/emp_fund_transfer', 'EmployeeController@fund_transfer');
Route::post('/emp_fund_transfer', 'EmployeeController@fund_transfer');

Route::get('/emp_fund_transfer_store', 'EmployeeController@fund_transfer_store');
Route::post('/emp_fund_transfer_store', 'EmployeeController@fund_transfer_store');

Route::get('/emp_main_ledger', 'EmployeeController@main_ledger');
Route::post('/emp_main_ledger', 'EmployeeController@main_ledger');

Route::get('/emp_fund_ledger', 'EmployeeController@fund_ledger');
Route::post('/emp_fund_ledger', 'EmployeeController@fund_ledger');

Route::get('/emp_payout_ledger', 'EmployeeController@payout_ledger');
Route::post('/emp_payout_ledger', 'EmployeeController@payout_ledger');

Route::get('/emp_payment_summary', 'EmployeeController@payment_summary');
Route::post('/emp_payment_summary', 'EmployeeController@payment_summary');

// EMPLOYEE Profile Routes
Route::get('/emp_registration', 'EmployeeController@registration');
Route::post('/emp_add_user', 'EmployeeController@add_user');

Route::get('/emp_view_user', 'EmployeeController@view_user');
Route::post('/emp_view_user', 'EmployeeController@view_user');

Route::get('/emp_edit_user', 'EmployeeController@edit_user');
Route::post('/emp_edit_user', 'EmployeeController@edit_user');
Route::post('/emp_update_profile','EmployeeController@update_userprofile');

Route::get('/emp_edit_userbankdetails', 'EmployeeController@edit_userbankdetails');
Route::post('/emp_edit_userbankdetails', 'EmployeeController@edit_userbankdetails');
Route::post('/emp_update_bankdetails','EmployeeController@update_userbankdetails');

Route::get('/emp_edit_userkycdetails', 'EmployeeController@edit_userkycdetails');
Route::post('/emp_edit_userkycdetails', 'EmployeeController@edit_userkycdetails');
Route::post('/emp_update_kyc','EmployeeController@update_userkyc');

Route::get('/emp_all_user', 'EmployeeController@all_user');
Route::post('/emp_all_user', 'EmployeeController@all_user');

Route::get('/emp_kyc', 'EmployeeController@kyc');
Route::post('/emp_kyc', 'EmployeeController@kyc');

Route::get('/emp_show_password','EmployeeController@change_password');
Route::post('/emp_show_password','EmployeeController@change_password');
Route::post('/emp_update_password', 'EmployeeController@update_userpassword');

// EMPLOYEE Topup Routes
Route::get('/emp_topup_report', 'EmployeeController@topup_report');
Route::post('/emp_topup_report', 'EmployeeController@topup_report');
Route::get('/emp_topup','EmployeeController@buy_subscription');
Route::post('/emp_topup','EmployeeController@buy_subscription');

Route::get('/emp_datewise_business_detail','EmployeeController@datewise_business_detail');
Route::post('/emp_datewise_business_detail','EmployeeController@datewise_business_detail');

// EMPLOYEE Team Routes
Route::get('/emp_directteam','EmployeeController@direct_referal');
Route::post('/emp_directteam','EmployeeController@direct_referal');

Route::get('/emp_downline', 'EmployeeController@user_downline');
Route::post('/emp_downline', 'EmployeeController@user_downline');

Route::get('/emp_level_view', 'EmployeeController@user_level_view');

Route::get('/emp_tree/{id}', 'EmployeeController@tree');
Route::post('/emp_tree', 'EmployeeController@tree');

// EMPLOYEE  CASHBACK BONUS REPORT HERE
Route::get('/emp_bonus_report','EmployeeController@cashbackbonus');
Route::post('/emp_bonus_report','EmployeeController@cashbackbonus');

// EMPLOYEE DIRECT BONUS REPORT HERE
Route::get('/emp_refferal_bonus_report','EmployeeController@refferal_bonus');
Route::post('/emp_refferal_bonus_report','EmployeeController@refferal_bonus');

// EMPLOYEE MATCHING INCOME REPORT HERE
Route::get('/emp_binary_closing_report','EmployeeController@binary_closing_report');
Route::post('/emp_binary_closing_report','EmployeeController@binary_closing_report');

Route::get('/emp_binary_closing_reverse','EmployeeController@binary_closing_reverse');
Route::post('/emp_binary_closing_reverse','EmployeeController@binary_closing_reverse');

Route::get('/emp_binary_closing_publish','EmployeeController@binary_closing_publish');
Route::post('/emp_binary_closing_publish','EmployeeController@binary_closing_publish');

Route::get('/emp_binary_closing_userwise','EmployeeController@binary_closing_userwise');
Route::post('/emp_binary_closing_userwise','EmployeeController@binary_closing_userwise');

// EMPLOYEE PAYMENT REPORT HERE
Route::get('/emp_payment_report','EmployeeController@payment_report');
Route::post('/emp_payment_report','EmployeeController@payment_report');

Route::get('/emp_payment_release','EmployeeController@payment_release');
Route::post('/emp_payment_release','EmployeeController@payment_release');
Route::post('/emp_pay_payment','EmployeeController@pay_payment');

Route::get('/emp_payment_release_report','EmployeeController@payment_release_report');
Route::post('/emp_payment_release_report','EmployeeController@payment_release_report');


Route::get('/emp_change_mobileno', 'EmployeeController@change_mobileno');
Route::post('/emp_change_mobileno', 'EmployeeController@change_mobileno');
Route::post('/emp_update_mobileno', 'EmployeeController@update_usermobileno');


Route::get('/emp_change_status', 'EmployeeController@change_status');
Route::post('/emp_change_status', 'EmployeeController@change_status');

// EMPLOYEE UTILITY REPORT HERE
Route::get('/emp_recharge_report','EmployeeController@recharge_report');
Route::post('/emp_recharge_report','EmployeeController@recharge_report');

Route::get('/emp_pending_recharge_report','EmployeeController@pending_recharge_report');
Route::post('/emp_pending_recharge_report','EmployeeController@pending_recharge_report');

Route::patch('/emp_update_rechargestatus','EmployeeController@update_rechargestatus');
Route::post('/emp_update_rechargetid','EmployeeController@update_rechargetid');
Route::post('/emp_refund_recharge','EmployeeController@refund_recharge');

Route::get('/emp_moneytransfer_report','EmployeeController@moneytransfer_report');
Route::post('/emp_moneytransfer_report','EmployeeController@moneytransfer_report');
Route::get('/emp_pending_moneytransfer_report','EmployeeController@pending_moneytransfer_report');
Route::post('/emp_pending_moneytransfer_report','EmployeeController@pending_moneytransfer_report');

Route::patch('/emp_update_dmtstatus','EmployeeController@update_dmtstatus');
Route::post('/emp_update_dmttid','EmployeeController@update_dmttid');
Route::post('/emp_refund_dmt','EmployeeController@refund_dmt');

Route::get('/search_recharge', 'EmployeeController@search_recharge');
Route::post('/search_recharge', 'EmployeeController@search_recharge');

Route::get('/search_dmt', 'EmployeeController@search_dmt');
Route::post('/search_dmt', 'EmployeeController@search_dmt');




// Slab Routes
Route::get('/emp_create_slab', 'EmployeeController@create_slab');
Route::post('/emp_add_slab', 'EmployeeController@add_slab');
Route::get('/emp_view_slab/{id}', 'EmployeeController@create_slab');
Route::post('/emp_update_slab/{id}', 'EmployeeController@update_slab');
Route::post('/emp_slab_status', 'EmployeeController@slab_status');

Route::get('/emp_prepaid_margin', 'EmployeeController@prepaid_margin');
Route::post('/emp_prepaid_margin', 'EmployeeController@prepaid_margin');
Route::post('/emp_update_margin', 'EmployeeController@update_margin');

Route::get('/emp_utility_surcharge', 'EmployeeController@utility_surcharge');
Route::post('/emp_utility_surcharge', 'EmployeeController@utility_surcharge');

Route::get('/emp_dmr_surcharge', 'EmployeeController@dmr_surcharge');
Route::post('/emp_dmr_surcharge', 'EmployeeController@dmr_surcharge');

Route::get('/emp_prepaidapi_sequences', 'EmployeeController@prepaidapi_sequences');
Route::post('/emp_prepaidapi_sequences', 'EmployeeController@prepaidapi_sequences');

Route::get('/emp_utilityapi_sequences', 'EmployeeController@utilityapi_sequences');
Route::post('/emp_utilityapi_sequences', 'EmployeeController@utilityapi_sequences');

Route::get('/emp_prepaidapi_limit', 'EmployeeController@prepaidapi_limit');
Route::get('/emp_utilityapi_limit', 'EmployeeController@utilityapi_limit');
//Slab Routes End Here

//Api Routes End Here
Route::get('/emp_add_api', 'EmployeeController@add_api');
Route::post('/emp_create_api', 'EmployeeController@create_api');
Route::get('/emp_view_api/{id}', 'EmployeeController@view_api');
Route::post('/emp_update_api/{id}', 'EmployeeController@update_api');

Route::get('/emp_api_operator', 'EmployeeController@api_operator');
Route::post('/update_apioperator/{api_id}', 'ApiController@update_apioperator');


Route::get('/user_ticket_reply/{id}','UserController@view_help_desk');
Route::post('/user_ticket_replys/','UserController@submit_reply');
Route::get('/user_submit_query','UserController@get_user_submit_query');

Route::post('/filter-ticket-reply','UserController@filter_ticket_reply');

Route::get('/submit_query','UserController@get_query');
Route::get('/view_close_ticket','UserController@view_close_ticket');
Route::post('/submit_query','UserController@submit_query');
//Api Routes End Here

Route::get('/money_transfer','UserController@money_transfer');
Route::post('/user_dmtlogin','UserController@user_dmtlogin');

Route::get('/user_dmtregister','UserController@user_dmtregister');
Route::post('/user_dmtregister','UserController@user_dmtregister');

Route::post('/send_dmt_otp','UserController@send_dmt_otp');
Route::post('/verification_dmt_otp','UserController@verification_dmt_otp');


Route::get('/user_dmtdashboard','UserController@user_dmtdashboard');

Route::get('/user_dmtbeneficiary','UserController@user_dmtbeneficiary');
Route::post('/user_dmtbeneficiary','UserController@user_add_beneficiary');

Route::post('/add_beneficiary','UserController@user_add_beneficiary');
Route::post('/sent_otpbene/{for_otp}','UserController@sent_otpbene');
Route::post('/verifyotp_addbeneficiary','UserController@user_verifyotp_add_beneficiary');

Route::get('/delete_beneficiary/{bene_id}','UserController@deletebeneficiary');
Route::post('/sent_otpdelete_bene','UserController@sent_otpdelete_bene');
Route::post('/verifyotp_deletebeneficiary','UserController@user_verifyotp_delete_beneficiary');


Route::get('/transfer2beneficiary/{bene_id}','UserController@transfer2beneficiary');
Route::post('/sent_otpt2bank','UserController@sent_otpt2bank');
Route::post('/verifyotp_transto_beneficiary','UserController@user_verifyotp_transto_beneficiary');
Route::post('/user_transtobene_bank','UserController@user_transtobene_bank');

Route::post('/user_transtobene_airtel_bank','UserController@user_transtobene_airtel_bank');

Route::get('/ticket_reply/{id}','TicketController@view_help_desk');



Route::get('email-inbox','CampaignController@email_inbox');

Route::get('mailbox-message/{id}','CampaignController@mailbox_message');

Route::get('delete-email/{id}','CampaignController@delete_email');

Route::post('delete-emails','CampaignController@delete_emails');

Route::get('email-campaign','CampaignController@email_campaign');

Route::post('get_templates','CampaignController@get_templates');

Route::post('find_user_email','CampaignController@find_user_email');

Route::post('find_user_ccemail','CampaignController@find_user_ccemail');

Route::post('find_user_bccemail','CampaignController@find_user_bccemail');

Route::post('send-user-email','CampaignController@send_user_email');


Route::get('view-crm-account','CRMController@view_crm_account');

Route::get('view-crm-lead','CRMController@view_crm_lead');

Route::get('view-crm-opportunity','CRMController@view_crm_opportunity');

Route::get('view-crm-contact','CRMController@view_crm_contact');

Route::get('view-crm-task','CRMController@view_crm_task');

Route::get('view-crm-event','CRMController@view_crm_event');

Route::post('search-member-code','UserController@search_member_code');

Route::get('view-fund-request','UserController@view_fund_request');
Route::post('view-fund-request','UserController@view_fund_request');

Route::post('/user_fundrequest_status', 'UserController@user_fundrequest_updatestatus');

Route::post('get-role-type','MasterController@get_role_type');

Route::post('gte_affiliate_data','ProfileController@Get_Affiliate_Data');

Route::post('update_affiliate','ProfileController@update_affiliate');

Route::post('Get_User_Data','ProfileController@Get_User_Data');
Route::post('update_api_user_inof','ProfileController@update_api_user_data');

// ADMIN PAN TOKEN START HERE
Route::get('/user_pan_token', 'ProfileController@user_pan_token');
Route::post('/user_pan_token', 'ProfileController@user_pan_token');
Route::post('/pantoken_status', 'ProfileController@pantoken_status');
Route::get('/change_reqstatus/{id}', 'ProfileController@change_reqstatus');

Route::get('/coupon', 'ProfileController@coupon');
Route::post('/coupon', 'ProfileController@coupon');
Route::get('/add_coupon', 'ProfileController@add_coupon');
Route::post('/add_tocoupon', 'ProfileController@add_tocoupon');
Route::get('/edit_coupon/{id}', 'ProfileController@edit_coupon');
Route::post('/update_coupon/{id}', 'ProfileController@update_coupon');
Route::get('/view_coupon/{id}', 'ProfileController@view_coupon');

// ADMIN PAN TOKEN END HERE

// USER MARGIN ROUTES START HERE
Route::get('/user_prepaidmargin','UserController@user_prepaidmargin');
Route::get('/user_utilitysurcharge','UserController@user_utilitysurcharge');
Route::get('/user_dmrsurcharge','UserController@user_dmrsurcharge');
// USER MARGIN ROUTES ENDS HERE

// USER SETTINGS ROUTES START HERE
Route::get('/user_manage_settings','UserController@user_manage_settings');
Route::get('/user_manage_settings/{config}','UserController@user_manage_settings');

Route::post('/user_update_settings/{user}', 'UserController@update_siteconfig');
Route::post('/user_affiliate_updatesitelogo/{config}', 'UserController@update_siteimage');

Route::get('/wl_bank_account', 'UserController@bank_account');
Route::get('/wl_bank_account/{id}', 'UserController@bank_account');
Route::post('/add_wl_bank_account', 'UserController@add_bank_account');
Route::post('/update_wl_bank_account/{id}','UserController@update_bank_account');
Route::post('/wl_bank_account_status','UserController@bank_account_status');

Route::get('/view_wl_news/', 'UserController@view_news');
Route::post('/add_wl_news/', 'UserController@add_news');
Route::get('/view_wl_news/{id}', 'UserController@view_news');
Route::post('/update_wl_news_detail/{id}', 'UserController@update_news_detail');
Route::post('/wl_news_status', 'UserController@news_status');

Route::get('/user_manage_operatorstatus','UserController@user_manage_operatorstatus');
Route::get('/user_manage_prepaidmargin','UserController@user_manage_prepaidmargin');
Route::post('/user_manage_prepaidmargin','UserController@user_manage_prepaidmargin');
Route::post('/user_update_prepaidmargin/{margin_id}','UserController@user_update_prepaidmargin');

Route::get('/user_manage_utilitysurcharge','UserController@user_manage_utilitysurcharge');
Route::post('/user_manage_utilitysurcharge','UserController@user_manage_utilitysurcharge');
Route::post('/user_update_utilitysurcharge/{margin_id}','UserController@user_update_utilitysurcharge');

Route::get('/user_manage_dmrsurcharge','UserController@user_manage_dmrsurcharge');
Route::post('/user_manage_dmrsurcharge','UserController@user_manage_dmrsurcharge');
Route::post('/user_update_dmrsurcharge/{dmrId}','UserController@user_update_dmrsurcharge');

Route::get('/user_manage_aepsmargin','UserController@user_manage_aepsmargin');
Route::post('/user_manage_aepsmargin','UserController@user_manage_aepsmargin');
Route::post('/user_update_aepsmargin/{AEPSID}','UserController@user_update_aepsmargin');

Route::get('/user_apitoken','UserController@user_api_token');
Route::post('/generate_apitoken','UserController@create_token');

Route::post('/update_serverip','UserController@update_serverip');

Route::post('/update_callbackurl','UserController@update_callbackurl');
Route::post('/update_dmrcallbackurl','UserController@update_dmrcallbackurl');
Route::post('/update_aepscallbackurl','UserController@update_aepscallbackurl');
Route::post('/update_aepsstatuscallbackurl','UserController@update_aepsstatuscallbackurl');
// USER SETTINGS ROUTES ENDS HERE



// EMPLOYEE Recharge Report Routes
Route::get('/emp_recharge_report', 'EmployeeController@recharge_report');
Route::post('/emp_recharge_report', 'EmployeeController@recharge_report');
Route::post('/emp_refund_recharge','EmployeeController@refund_recharge');


Route::get('/emp_pendingrecharge_report', 'EmployeeController@pendingrecharge_report');
Route::post('/emp_pendingrecharge_report', 'EmployeeController@pendingrecharge_report');

Route::get('/emp_refund_report', 'EmployeeController@refund_report');
Route::post('/emp_refund_report', 'EmployeeController@refund_report');

Route::get('/emp_operator_wise', 'EmployeeController@operator_wise');
Route::post('/emp_operator_wise', 'EmployeeController@operator_wise');

Route::get('/emp_uw', 'EmployeeController@user_wise');
Route::post('/emp_uw', 'EmployeeController@user_wise');

Route::get('/emp_api_wise', 'EmployeeController@api_wise');
Route::post('/emp_api_wise', 'EmployeeController@api_wise');

Route::get('/emp_dw', 'EmployeeController@date_wise');
Route::post('/emp_dw', 'EmployeeController@date_wise');
// EMPLOYEE Recharge Report Routes End Here


// EMPLOYEE MONEY TRANSFER Report Routes
Route::get('/emp_mtransfer_report', 'EmployeeController@mtransfer_report');
Route::post('/emp_mtransfer_report', 'EmployeeController@mtransfer_report');

Route::post('/emp_refund_mtransfer_report','EmployeeController@refund_mtransfer');

Route::get('/emp_pendingmtransfer_report', 'EmployeeController@pendingmtransfer_report');
Route::post('/emp_pendingmtransfer_report', 'EmployeeController@pendingmtransfer_report');

Route::get('/emp_refund_mtransfer_report', 'EmployeeController@refund_mtransfer_report');
Route::post('/emp_refund_mtransfer_report', 'EmployeeController@refund_mtransfer_report');

Route::get('/emp_uw_mtransfer', 'EmployeeController@user_wise_mtransfer');
Route::post('/emp_uw_mtransfer', 'EmployeeController@user_wise_mtransfer');

Route::get('/emp_api_wise_mtransfer', 'EmployeeController@api_wise_mtransfer');
Route::post('/emp_api_wise_mtransfer', 'EmployeeController@api_wise_mtransfer');

Route::get('/emp_dw_mtransfer', 'EmployeeController@date_wise_mtransfer');
Route::post('/emp_dw_mtransfer', 'EmployeeController@date_wise_mtransfer');
// EMPLOYEE MONEY TRANSFER Report Routes End Here

// EMPLOYEE AEPS Report Routes
Route::get('/emp_apestransfer_report', 'EmployeeController@apestransfer_report');
Route::post('/emp_apestransfer_report', 'EmployeeController@apestransfer_report');

Route::post('/emp_refund_apestransfer','EmployeeController@refund_apestransfer');

Route::get('/emp_pendingapestransfer_report', 'EmployeeController@pendingapestransfer_report');
Route::post('/emp_pendingapestransfer_report', 'EmployeeController@pendingapestransfer_report');

Route::get('/emp_refund_apestransfer_report', 'EmployeeController@refund_apestransfer_report');
Route::post('/emp_refund_apestransfer_report', 'EmployeeController@refund_apestransfer_report');

Route::get('/emp_uw_apestransfer', 'EmployeeController@user_wise_apestransfer');
Route::post('/emp_uw_apestransfer', 'EmployeeController@user_wise_apestransfer');

Route::get('/emp_api_wise_apestransfer', 'EmployeeController@api_wise_apestransfer');
Route::post('/emp_api_wise_apestransfer', 'EmployeeController@api_wise_apestransfer');

Route::get('/emp_dw_apestransfer', 'EmployeeController@date_wise_apestransfer');
Route::post('/emp_dw_apestransfer', 'EmployeeController@date_wise_apestransfer');
// EMPLOYEE AEPS Report Routes End Here


Route::get('/user_banner', 'UserController@view_banner');
Route::post('/user_add_banner', 'UserController@create_banner');
Route::get('/user_view_banner/{id}', 'UserController@view_banner');
Route::post('/user_update_banner/{id}', 'UserController@update_banner');

Route::get('/employee_banner', 'EmployeeController@view_banner');
Route::post('/employee_add_banner', 'EmployeeController@create_banner');
Route::get('/employee_view_banner/{id}', 'EmployeeController@view_banner');
Route::post('/employee_update_banner/{id}', 'EmployeeController@update_banner');



Route::get('/view_config_employee', 'EmployeeController@view_config');
Route::get('/view_config_employee/{config}', 'EmployeeController@view_config');
Route::post('/update_siteconfig_employee/{admin}', 'EmployeeController@update_siteconfig');
Route::post('/add_mainconfig_employee', 'EmployeeController@add_mainconfig');
Route::patch('/update_mainconfig_employee/{admin}', 'EmployeeController@update_mainconfig');
Route::post('/update_siteimage_employee/{config}/{id}', 'EmployeeController@update_siteimage');


Route::get('view-certificate','UserController@view_certificates');

Route::get('/view_activity_log', 'UserController@view_activity_log');

Route::get('/view_login_log', 'UserController@view_login_log');

//USER REWARD ROUTES START HERE
Route::get('/user_reward_report', 'UserController@user_reward_report');
Route::post('/user_reward_apply', 'UserController@user_reward_apply');
Route::get('/user_reward_history', 'UserController@user_reward_history');

Route::get('/user_lucky_draw', 'UserController@user_lucky_draw');
Route::post('/user_lucky_draw', 'UserController@user_lucky_draw');

Route::get('/user_coupon', 'UserController@user_coupon');
Route::post('/user_coupon', 'UserController@user_coupon');

Route::get('/reward_history', 'ProfileController@reward_history');
Route::post('/change_reward_status', 'ProfileController@change_reward_status');
//USER REWARD ROUTES END HERE



//USER PAN REQUEST START HERE
Route::get('/user_pan_request', 'UserController@user_pan_request');
Route::post('/pan_request', 'UserController@pan_request');
//USER PAN REQUEST END HERE

Route::get('create-denomination','MasterController@create_denomination');
Route::post('add-denomination','MasterController@add_denomination');
Route::get('edit-denomination/{id}','MasterController@edit_denomination');
Route::post('update-denomination/{id}','MasterController@update_denomination');

Route::get('create-denomination-range','MasterController@create_denomination_range');
Route::post('add-denomination-range','MasterController@add_denomination_range');
Route::get('edit-denomination-range/{id}','MasterController@edit_denomination_range');
Route::post('update-denomination-range/{id}','MasterController@update_denomination_range');

Route::get('/admin_services', 'MasterController@admin_services');
Route::get('/view_admin_services/{id}', 'MasterController@admin_services');
Route::post('/add_admin_services', 'MasterController@add_admin_services');
Route::post('/update_admin_services/{id}', 'MasterController@update_admin_services');
Route::get('/status_admin_services/{id}/{st}', 'MasterController@status_admin_services');


Route::get('/view-balance-deduction-types', 'MasterController@view_balance_deduction_types');
Route::post('/create-balance-deduction-types', 'MasterController@create_balance_deduction_types');
Route::get('/edit-balance-deduction-types/{id}', 'MasterController@edit_balance_deduction_types');
Route::post('/update-balance-deduction-types/{id}', 'MasterController@update_balance_deduction_types');



Route::get('/view-level-commission', 'MasterController@view_level_commission');
Route::post('/create-level-commission', 'MasterController@create_level_commission');
Route::get('/edit-level-commission/{id}/{st}', 'MasterController@edit_level_commission');
Route::post('/update-level-commission/{id}', 'MasterController@update_level_commission');
Route::get('/status-level-commission/{id}/{st}', 'MasterController@status_level_commission');


Route::get('/view-custom-message', 'MasterController@view_custom_message');
Route::post('/create-custom-message', 'MasterController@create_custom_message');
Route::get('/edit-custom-message/{id}', 'MasterController@edit_custom_message');
Route::post('/update-custom-message/{id}', 'MasterController@update_custom_message');
Route::get('/status-custom-message/{id}/{st}', 'MasterController@status_custom_message');
Route::post('/get-template-types', 'MasterController@get_template_types');


Route::post('/check_mobile_roffer', 'UserController@check_mobile_roffer');
Route::post('/get_dth_roffer', 'UserController@get_dth_roffer');
Route::get('/change_twoFa/{st}', 'UserController@change_twoFa');

//Admin log 
Route::match(['get','post'],'login_users_log', 'LogController@view_user_login_log');
Route::get('/activity_log', 'LogController@activity_log');
Route::match(['get','post'],'activity_user_log', 'LogController@view_user_activity_log');
Route::match(['get','post'],'activity_employee_log', 'LogController@view_employee_activity_log');
Route::match(['get','post'],'/view-sms-log', 'LogController@view_sms_log');
Route::match(['get','post'],'/view-email-log', 'LogController@view_email_log');

// Jquery validation : How to check if email exists
Route::post('/check_email_id', 'AuthController@check_email_id');
Route::post('/check_mobile_id', 'AuthController@check_mobile_id');


//get service name
Route::post('/get-service-names', 'UserController@get_srv');
// user diactiv and active 
Route::post('/diactive-users', 'UserController@diactive_users');


Route::get('/subscription', 'MasterController@subscription');
Route::get('/subscription_status/{id}', 'MasterController@subscription_status_update');
Route::get('/subscription_details_edit/{id}', 'MasterController@subscription_details_edit');
Route::post('/add_subscription_details', 'MasterController@add_subscription_details');
Route::post('/update_subscription_details/{id}', 'MasterController@update_subscription_details');


Route::post('cashfree_payment', 'PaymentGatewayController@cashfree_payment')->name('cashfree_pay');
Route::post('cashfree_payments', 'PaymentGatewayController@cashfree_payments')->name('cashfree_pays');

Route::get('/coupons', 'MasterController@coupons');
Route::get('/faq', 'MasterController@faq');
Route::get('/productreview', 'MasterController@productreview');
Route::get('/socialauth', 'MasterController@socialauth');
Route::get('/paymentsetting', 'MasterController@paymentsetting');

});

Route::get('error-page','AuthController@view_error_page');
Route::post('b2crazorpay', 'PaymentGatewayController@b2crazorpay')->name('b2crazorpay');
Route::post('razorpay', 'PaymentGatewayController@razorpay')->name('razorpay');



