<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});



Route::prefix('v1')->namespace('API')->group(function () {

Route::get('payment_info','ShoppingWebService@payment_report');
Route::post('payment_info','ShoppingWebService@payment_report');
Route::post('cart_payment_info/{id}/{address}','ShoppingWebService@payment_reports');
Route::post('get_payment_info','ShoppingWebService@get_payment_info');
Route::post('/upload_image', 'AppWebService@upload_image');
Route::post('/get_spin_data', 'AppWebService@spin_data');
Route::post('/user_win_spin', 'AppWebService@create_win_data');

Route::post('/get_invite', 'AppWebService@get_invite');

Route::post('/razorpayapp','AppWebService@razorpayapp');

Route:: get('/bank_list','AppWebService@bank_list');
Route:: get('/package_list','AppWebService@package_list');
Route:: post('/login','AppWebService@login');
Route:: post('/dapp_login','AppWebService@dapp_login')->middleware('Cors');
Route:: post('/signup','AppWebService@signup');
Route:: post('/add_user','AppWebService@add_user');
Route::post('/forget_password', 'AppWebService@forget_password');
Route::post('/verify_fpotp', 'AppWebService@verify_fpotp');
Route::post('/verify_loginotp', 'AppWebService@verify_loginotp');

Route:: get('/mahagram_UpdateStatus','AepsWebService@mahagram_UpdateStatus');
Route:: get('/mahagram_CheckStatus','AepsWebService@mahagram_CheckStatus');

	Route:: get('/recharge_callback/{id}','ApiWebResponse@recharge_callback');
	Route:: get('/dmt_callback/{id}','ApiWebResponse@dmt_callback');
	Route:: get('/letslaunch_dmtresponse','ApiWebResponse@letslaunchapi_dmtresponse');
	Route:: post('/member_data','AppWebService@member_data');
	Route:: post('/refral_data','AppWebService@refral_data');
	Route::post('/get_operator_name','AppWebService@get_operators_show');
	Route::post('/get_static_content','AppWebService@get_content');

	Route:: post('/buy_coin','AppWebService@buy_coin');
	Route:: post('/sell_coin','AppWebService@sell_coin');

Route:: post('/buy_subscription','AppWebService@buy_subscription');
Route:: post('/bonus_withdraw','AppWebService@withdraw_vet');
Route:: post('/tradebonus_withdraw','AppWebService@withdraw_trade');
Route::post('/bw_statusupdate','AppWebService@refund_bonus');

Route:: post('/show_team','AppWebService@show_team');

Route:: post('/show_totalteam','AppWebService@show_totalteam');

Route:: post('/show_topup','AppWebService@show_topup');
Route:: post('/show_withdraw','AppWebService@matchingwithdraw_report');

/* Start Income report */
Route:: post('/direct_income','AppWebService@direct_income');
Route:: post('/level_income','AppWebService@level_income');
Route:: post('/matching_income','AppWebService@matching_income');
Route:: post('/cashback_income','AppWebService@cashback_income');
	// Protected with APIToken Middleware

	Route::middleware('APIToken')->group(function () {

	Route::post('/last_recharge_history','AppWebService@get_last_recharge');

    Route::post('/apitransaction','RechargeWebService@apitransaction');

    Route::get('/apitransaction','RechargeWebService@apitransaction');

	Route::get('/status_check','RechargeWebService@status_check');

	Route::get('/balance_check','RechargeWebService@balance_check');



	Route::get('/dthinfo_api','PlanCheckWebService@dthinfo_check');

	Route::get('/roffer_check','PlanCheckWebService@roffer_check');



	Route::get('/operator','AppWebService@operator');
    	Route::get('/banner','AppWebService@banner');
    

    Route:: post('/upi_pay','AppWebService@user_upipay');    



	Route:: post('/add_member','AppWebService@add_member');

	Route:: post('/profile','AppWebService@profile');

    Route:: post('/refresh_data','AppWebService@refresh_data');

	Route:: get('/get_userkyc','AppWebService@get_userkyc');
	Route:: get('/get_usershop','AppWebService@get_usershop');

	Route:: post('/transaction','AppWebService@transaction');

	Route:: post('/dth_transaction','AppWebService@dth_transaction');

	Route::post('/complaint','AppWebService@complaint');

	Route::post('/pay_bill','AppWebService@pay_bill');

    Route::post('/check_bill','AppWebService@check_bill');

	Route::post('/check_dthinfo','AppWebService@check_dthinfo');

	Route::post('/check_roffer','AppWebService@check_roffer');

	



Route:: post('/change_password','AppWebService@change_password');
Route:: post('/update_user','AppWebService@update_userprofile');
Route:: post('/update_password','AppWebService@update_password');
Route:: post('/update_userkyc','AppWebService@update_userkyc');
Route:: post('/update_userbankdetails','AppWebService@update_userbankdetails');
Route:: post('/update_usershopdetails','AppWebService@update_usershopdetails'); 
Route:: post('/update_transpassword','AppWebService@update_transpassword');
Route:: post('/show_ladger','AppWebService@show_ladger');
Route:: post('/show_recharge','AppWebService@show_recharge');
Route:: post('/show_aeps','AppWebService@show_aeps');
Route:: post('/show_aeps_settelmentreport','AppWebService@show_aeps_settelment');
Route:: post('/show_fundrequest','AppWebService@show_fundrequest');
Route:: post('/show_compliant','AppWebService@show_compliant');



/* End Income report */

Route:: post('/user_downline','AppWebService@user_downline');

Route::get('/bank_account','AppWebService@bank_account');
Route::get('/news','AppWebService@news');
Route::post('/fund_request','AppWebService@user_fundrequestto_admin');
Route::post('/fund_transfer','AppWebService@user_fundtransferto_team');
Route::post('/wallet_towallet','AppWebService@user_wallet_towallet');
Route::post('/user_margin','AppWebService@user_margin');
Route::post('/daily_purchase','AppWebService@user_dailypurchase');
Route::post('/daily_sale','AppWebService@user_operatorwise');
Route:: post('/show_downlineladger','AppWebService@show_downlineladger');
Route:: post('/show_downlinerecharge','AppWebService@show_downlinerecharge');

Route:: post('/renew_subscription','AppWebService@renew_subscription');

Route:: post('/dmt_login','AppWebService@dmt_login');
Route:: post('/dmt_userregister','AppWebService@dmt_userregister');
Route:: post('/add_beneficiary','AppWebService@add_beneficiary');
Route:: post('/delete_beneficiary','AppWebService@delete_beneficiary');
Route::post('/transferto_bank','AppWebService@payto_bank');
Route::post('/verify_account','AppWebService@verify_account');
Route:: post('/show_dmr','AppWebService@show_dmr');
Route::post('/checkstatus_from_bank','MoneyTransferWebService@checkstatus_from_bank');
Route::post('/apidmt_login','MoneyTransferWebService@dmt_login');
Route::post('/apidmt_register','MoneyTransferWebService@dmt_register');
Route::post('/apiadd_beneficiary','MoneyTransferWebService@addbeneficiary');
Route:: post('/apitransferto_bank','MoneyTransferWebService@payto_bank');
/*Route::post('/apipay_bill','UtilityWebService@pay_bill');
Route::get('/apibillpay_status','UtilityWebService@status_check');
Route::post('/apibill_check','UtilityWebService@bill_check');
Route::post('/generate_aepsbcid','UtilityWebService@generate_aepsbcid');*/
Route:: post('/apitransferto_icicibank','MoneyTransferWebService@payto_icicibank');
Route::post('/apiverify_account','MoneyTransferWebService@verify_account');
Route::post('/show_content','AppWebService@show_content');
  });

// SHOPPING WEB SERVICES ROUTES START HERE
Route::post('/get_config_value', 'ShoppingWebService@get_config_value');
Route::post('/get_cashfree_order', 'ShoppingWebService@get_cashfree_order');
Route::get('/parent_cat','ShoppingWebService@parent_cat');
Route::get('/get_cat/{id}','ShoppingWebService@get_cat');
Route::get('/categories','ShoppingWebService@categories');
Route::get('/sub_categories/{id}','ShoppingWebService@sub_categories');
Route::get('/get_cat_prods/{cat_id}','ShoppingWebService@get_cat_prods');
Route::get('/product_detail/{prod_id}','ShoppingWebService@product_detail');

Route::post('/add_favorites','ShoppingWebService@add_favorites');
Route::post('/user_favorites','ShoppingWebService@user_favorites');
Route::post('/delete_favorites','ShoppingWebService@delete_favorites');

Route::post('/add_wishlist','ShoppingWebService@add_wishlist');
Route::post('/user_wishlist','ShoppingWebService@user_wishlist');
Route::post('/delete_wishlist','ShoppingWebService@delete_wishlist');

Route::post('/get_coupan_amount','ShoppingWebService@get_coupan_amount');
Route::post('/add_address','ShoppingWebService@add_address');
Route::post('/update_address','ShoppingWebService@update_address');
Route::post('/user_address','ShoppingWebService@user_address');
Route::post('/delete_address','ShoppingWebService@delete_address');
Route::post('/address_default','ShoppingWebService@address_default');
Route::post('/user_default_address','ShoppingWebService@user_default_address');

Route::get('/date_slot','ShoppingWebService@date_slot');
Route::post('/placing_orders','ShoppingWebService@placing_orders');
Route::post('/user_orders','ShoppingWebService@user_orders');
Route::post('/user_cancel_order','ShoppingWebService@user_cancel_order');
Route::post('/aeps_amount_settelment','AppWebService@aeps_amount_settelment');

});

Route::prefix('pantoken')->namespace('API')->group(function () {
	Route:: post('/pay_panamount','PanWebService@pay_panamount');
	Route:: get('/double_check','PanWebService@double_check');
});