@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">VENDOR MASTER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">
            <div class="col-md-6 col-xs-12">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('vendor_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("vendor_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">VENDOR MASTER</h3>
                    </div>

                    <div class="collapse in">
                        @if(!isset($single_vendor[0]->m40_vendor_id))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('add_vendor')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">    

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Vendor Name *</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="text" id="txt_vendor" name="txt_vendor" class="form-control" placeholder="Enter Vendor Name.">
                                        </div>
                                    </div> 

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Vendor Url</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="text" id="txt_vendorurl" name="txt_vendorurl" class="form-control" placeholder="Enter Vendor Url">
                                        </div>
                                    </div>                             
                                
                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Image</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="file" name="vendor_icon" id="vendor_icon" class="form-control">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Description</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <textarea id="txt_venderdesc" name="txt_venderdesc" class="form-control" placeholder="Enter Vendor Description." rows="3"></textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                            
                            </div>
                        </form>
                        @elseif(isset($single_vendor[0]->m40_vendor_id))
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('edit_vendor/'.$single_vendor[0]->m40_vendor_id)}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">    

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Vendor Name *</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="text" id="txt_vendor" name="txt_vendor" class="form-control" value="{{$single_vendor[0]->m40_vendor_name}}">
                                        </div>
                                    </div> 

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Vendor Url</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="text" id="txt_vendorurl" name="txt_vendorurl" class="form-control" value="{{$single_vendor[0]->m40_vendor_url}}">
                                        </div>
                                    </div>  

                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Image</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <input type="file" name="vendor_icon" id="vendor_icon" class="form-control">
                                        </div>
                                    </div>                           
                                
                                    <div class="form-group">
                                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Description</label>
                                        <div class="col-md-9 col-sm-9 col-xs-12">
                                          <textarea id="txt_venderdesc" name="txt_venderdesc" class="form-control" rows="3">{{$single_vendor[0]->m40_vendor_desc}}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                            
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>
            </div>
            
            <div class="col-md-6 col-xs-12">
                <div class="panel">
                
                    <div class="panel-body">
                        <div class="text-right">
                            <div class="form-group">
                                <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Vendor');">Export To Excel</button>
                            </div>
                        </div>
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                  <th>S.No</th>
                                  <th>Vendor Name</th>
                                  <th>Vendor URL</th>
                                  <th>Description</th>
                                  <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($vendor as $value)
                                <tr>
                                    <td>#</td>
                                    <td>{{$value->m40_vendor_name}}</td>
                                    <td>{{$value->m40_vendor_url}}</td>
                                    <td>{{$value->m40_vendor_desc}}</td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('/view_vendor/'.$value->m40_vendor_id)}}">EDIT</a>
                                        <a class="btn btn-success btn-xs" href="{{url('/delete_vendor/'.$value->m40_vendor_id)}}">DELETE</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

