@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Dashboard</a></li>
        <li class="active">Sub Category Master</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-md-4">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('store_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("store_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Sub Category Master</h3>
                    </div>

                    <div class="collapse in">
                        
                        @if(isset($singlecategory[0]->m02_cat_id))
                        <form action="{{url('/update_subcategory/'.$singlecategory[0]->m02_cat_id)}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">

                                <div class="form-group">
                                    <label class="control-label" for="ddcat">Category</label>
                                    <select class="form-control" id="ddcat" name="ddcat" required>
                                        <option value="">Select</option>
                                        @foreach($category as $value)  
                                        <option value="{{$value->m02_cat_id}}" {{$value->m02_cat_id == $singlecategory[0]->m02_parent_id ? 'selected' : ''}}>{{$value->m02_cat_name}}</option>   
                                        @endforeach                    
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label class="control-label" for="txt_name">Sub Category Name</label>
                                    <input type="text" name="txt_name" id="txt_name" class="form-control"  value="{{$singlecategory[0]->m02_cat_name}}" required>
                                </div> 

                                <div class="form-group">
                                    <label class="control-label" for="txt_desc">Category Description</label>
                                    <textarea id="txt_desc" name="txt_desc" class="form-control" placeholder="Enter Description." rows="3">{{$singlecategory[0]->m02_cat_desc}}</textarea>
                                </div>

                            </div>
                           
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @elseif(!isset($singlecategory[0]->m02_cat_id))
                        <form action="{{url('/add_subcategory')}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body">

                                <div class="form-group">
                                    <label class="control-label" for="ddcat">Category</label>
                                    <select class="form-control" id="ddcat" name="ddcat" required>
                                        <option value="">Select</option>
                                        @foreach($category as $value)  
                                        <option value="{{$value->m02_cat_id}}">{{$value->m02_cat_name}}</option>   
                                        @endforeach                    
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label class="control-label" for="txt_name">Sub Category Name</label>
                                    <input type="text" name="txt_name" id="txt_name" class="form-control"  placeholder="Enter Sub Category Name." required>
                                </div> 

                                <div class="form-group">
                                    <label class="control-label" for="txt_desc">Category Description</label>
                                    <textarea id="txt_desc" name="txt_desc" class="form-control" placeholder="Enter Description." rows="3"></textarea>
                                </div>

                            </div>
                           
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Save</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>
            </div>

            <div class="col-md-8">
                <div class="panel">
                
                    <div class="panel-body">
                        <div class="text-right">
                            <div class="form-group">
                                <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Subcategorydetails');">Export To Excel</button>
                            </div>
                        </div>
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Category</th>
                                    <th>Sub-Category</th>
                                    <th class="min-tablet">Description</th>
                                    <th class="min-tablet">Edit</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($subcategory as $value)
                                    <tr>
                                        <td>#</td>
                                        @foreach($category as $c)
                                        @if($c->m02_cat_id == $value->m02_parent_id)
                                        <td>{{$c->m02_cat_name}}</td>
                                        @endif
                                        @endforeach
                                        <td>{{$value->m02_cat_name}}</td>
                                        <td>{{$value->m02_cat_desc}}</td>
                                        <td><a class="btn btn-success btn-xs" href="{{url('/subcategory/'.$value->m02_cat_id)}}">EDIT</a></td>
                                    </tr>
                                @endforeach
                             
                            </tbody>
                        </table>
                    </div>
                
                </div>
            </div>   
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

