@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">FRANCHISEE MASTER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">

                  @if ($errors->any())
                  <div class="alert alert-danger">
                      <ul>
                          @foreach ($errors->all() as $error)
                              <li>{{ $error }}</li>
                          @endforeach
                      </ul>
                  </div>
                  @endif

                  @if(Session::has('subcat_msg')) 
                  <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                      <h4 class="alert-heading">{{ Session::get("subcat_msg") }}</h4>
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  @endif

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">FRANCHISEE MASTER</h3>
                </div>

                <div class="collapse in">
                    @if(!isset($single_store[0]->m44_store_id))
                    <form class="form-horizontal" enctype="multipart/form-data" action="{{url('add_store')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_storename" name="txt_storename" class="form-control" placeholder="Enter Store Name.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Email</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_storeemail" name="txt_storeemail" class="form-control" placeholder="Enter Store Email.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee UserId</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_userid" name="txt_userid" class="form-control" placeholder="Enter User Id.">
                                        <input type="hidden" id="txt_uid" name="txt_uid" class="form-control">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee State</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_state" id="dd_state">
                                            <option>Select</option>
                                            @foreach($state as $value)
                                            <option value="{{$value->LOC_ID}}">{{$value->LOC_NAME}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Address</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea id="txt_storeadd" name="txt_storeadd" class="form-control" placeholder="Enter Store Description." rows="3"></textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">GST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_gst" name="txt_gst" class="form-control" placeholder="Enter GST.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">License No.</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_licno" name="txt_licno" class="form-control" placeholder="Enter License No.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">About</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea id="txt_storedesc" name="txt_storedesc" class="form-control" placeholder="Enter Store Description." rows="3"></textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Password</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="password" id="txt_pass" name="txt_pass" class="form-control">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Status</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_status" id="dd_status">
                                            <option>Select</option>
                                            <option value="1">Active</option>
                                            <option value="2">InActive</option>
                                        </select>
                                      </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Save</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                           
                        </div>
                    </form>
                    @elseif(isset($single_store[0]->m44_store_id))
                    <form class="form-horizontal" enctype="multipart/form-data" action="{{url('edit_store/'.$single_store[0]->m44_store_id)}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_storename" name="txt_storename" class="form-control" value="{{$single_store[0]->m44_store_name}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Email</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_storeemail" name="txt_storeemail" class="form-control" value="{{$single_store[0]->m44_store_email}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee UserId</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_userid" name="txt_userid" class="form-control" value="{{$single_store[0]->m44_store_userid}}">
                                        <input type="hidden" id="txt_uid" name="txt_uid" class="form-control" value="{{$single_store[0]->m44_store_uid}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee State</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_state" id="dd_state">
                                            <option>Select</option>
                                            @foreach($state as $value)
                                            <option value="{{$value->LOC_ID}}" {{$single_store[0]->m44_store_state == $value->LOC_NAME ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Address</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea id="txt_storeadd" name="txt_storeadd" class="form-control" rows="3">{{$single_store[0]->m44_store_address}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">GST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_gst" name="txt_gst" class="form-control" value="{{$single_store[0]->m44_store_gst}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">License No.</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_licno" name="txt_licno" class="form-control" value="{{$single_store[0]->m44_store_licnace}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">About</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea id="txt_storedesc" name="txt_storedesc" class="form-control" rows="3">{{$single_store[0]->m44_store_description}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Password</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="password" id="txt_pass" name="txt_pass" class="form-control" value="{{$single_store[0]->m44_store_pass}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Franchisee Status</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_status" id="dd_status">
                                            <option>Select</option>
                                            <option value="1">Active</option>
                                            <option value="2">InActive</option>
                                        </select>
                                      </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Save</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                           
                        </div>
                    </form>
                    @endif

                </div>
    
            </div>

        </div>    
            
        <div class="row">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">FRANCHISEE MASTER</h3>
                </div>
            
                <div class="collapse in">
                    <div class="panel-body">
                        <div class="text-right">
                            <div class="form-group">
                                <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Product');">Export To Excel</button>
                            </div>
                        </div>
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Store UserId</th>
                                    <th>Store Name</th>
                                    <th>Store Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($store as $value)
                                <tr>
                                    <td>#</td>
                                    <td>{{$value->m44_store_userid}}</td>
                                    <td>{{$value->m44_store_name}}</td>
                                    <td>{{$value->m44_store_email}}</td>
                                    <td><a class="btn btn-success btn-xs" href="{{url('/view_store/'.$value->m44_store_id)}}">EDIT</a></td>
                                </tr>      
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->


<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $('#txt_userid').keyup(function(){
        var userid = $(this).val();
        //alert(userid);
        if(userid){
            $.ajax({
               type:"POST",
               url:"{{url('/get_user')}}",
               data:{"_token": "{{ csrf_token() }}", "userid": userid},
               success:function(result)
               {     

                    if(result)
                    {
                        console.log(result);
                        $("#txt_uid").val(result[0].m11_user_id);
                    }
               }

            });
        }
        else{
            $("#txt_uid").empty();
        }

      });
});
</script>
@endsection