@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT MASTER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        

        <div class="row">
            
            <div class="panel">

              @if ($errors->any())
              <div class="alert alert-danger">
                  <ul>
                      @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                      @endforeach
                  </ul>
              </div>
              @endif

              @if(Session::has('product_msg')) 
              <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                  <h4 class="alert-heading">{{ Session::get("product_msg") }}</h4>
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
              @endif

              
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">PRODUCT MASTER</h3>
                </div>

                <div class="collapse in">
                    @if(!isset($single_product[0]->m41_product_id))
                    <form class="form-horizontal" enctype="multipart/form-data" action="{{url('add_product')}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Vendor Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_vndr" id="dd_vndr">
                                            <option>Select Vendor Name</option>
                                            @foreach($vendor as $value)
                                            <option value="{{$value->m40_vendor_id}}">{{$value->m40_vendor_name}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Category Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_prodcat" id="dd_prodcat">
                                            <option>Select Category Name</option>
                                            @foreach($category as $value)
                                            <option value="{{$value->m02_cat_id}}">{{$value->m02_cat_name}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Sub-Category Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_subprodcat" id="dd_subprodcat">
                                            <option>Select Sub-Category Name</option>
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodname" name="txt_prodname" class="form-control" placeholder="Enter Product Name.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">HSN Code</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_haxcode" name="txt_haxcode" class="form-control" placeholder="Enter Haxcode.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Expiry Date</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <div id="demo-dp-txtinput">
                                            <input type="text" id="txt_expdate" name="txt_expdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                        </div>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Batch No.</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_probatch" name="txt_probatch" class="form-control" placeholder="Enter Product Batch.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">MRP</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_price" name="txt_price" class="form-control" placeholder="Enter Product Price.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Discount Price</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_dprice" name="txt_dprice" class="form-control" placeholder="Enter Product Discount Price.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Weight</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodwt" name="txt_prodwt" class="form-control" placeholder="Enter Product Weight.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">CGST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_gst" name="txt_gst" class="form-control" placeholder="Enter GST.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">SGST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_sgst" name="txt_sgst" class="form-control" placeholder="Enter SGST.">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Stock (pcs)</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodbussvol" name="txt_prodbussvol" class="form-control" placeholder="Enter Product Bussines Vol.">
                                      </div>
                                    </div>
                                </div> 

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4 col-sm-4 col-xs-12">Images</label>
                                        <div class="col-md-8 col-sm-8 col-xs-12">
                                          <input type="file" name="prod_fimg[]" id="prod_fimg" class="form-control" multiple>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Short Description</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea type="text" id="txt_prodstrdesc" name="txt_prodstrdesc" class="form-control" placeholder="Enter Product Str Description."></textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Long Description</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea type="text" id="txt_proddesc" name="txt_proddesc" class="form-control" placeholder="Enter Product Description."></textarea>
                                      </div>
                                    </div>
                                </div>

                                           

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Save</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                           
                        </div>
                    </form>
                    @elseif(isset($single_product[0]->m41_product_id))
                    <form class="form-horizontal" enctype="multipart/form-data" action="{{url('edit_product/'.$single_product[0]->m41_product_id)}}" method="POST">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Vendor Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_vndr" id="dd_vndr">
                                            <option>Select Vendor Name</option>
                                            @foreach($vendor as $value)
                                            <option value="{{$value->m40_vendor_id}}" {{$value->m40_vendor_id == $single_product[0]->m41_product_vendor ? 'selected' : ''}}>{{$value->m40_vendor_name}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Category Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_prodcat" id="dd_prodcat">
                                            <option>Select Category Name</option>
                                            @foreach($category as $value)
                                            <option value="{{$value->m02_cat_id}}">{{$value->m02_cat_name}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Sub-Category Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <select class="form-control" name="dd_subprodcat" id="dd_subprodcat">
                                            @foreach($category as $value)
                                            <option value="{{$value->m02_cat_id}}" {{$value->m02_cat_id == $single_product[0]->m41_product_category ? 'selected' : ''}}>{{$value->m02_cat_name}}</option>
                                            @endforeach
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Name</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodname" name="txt_prodname" class="form-control" value="{{$single_product[0]->m41_product_name}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">HSN Code</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_haxcode" name="txt_haxcode" class="form-control" value="{{$single_product[0]->m41_haxcode}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Expiry Date</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <div id="demo-dp-txtinput">
                                            <input type="text" id="txt_expdate" name="txt_expdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" value="{{$single_product[0]->m41_product_date}}" required>
                                        </div>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Batch No.</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_probatch" name="txt_probatch" class="form-control" value="{{$single_product[0]->m41_product_batch}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">MRP</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_price" name="txt_price" class="form-control" value="{{$single_product[0]->m41_product_price}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Discount Price</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_dprice" name="txt_dprice" class="form-control" value="{{$single_product[0]->m41_product_dp}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Weight</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodwt" name="txt_prodwt" class="form-control" value="{{$single_product[0]->m41_product_weight}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">CGST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_gst" name="txt_gst" class="form-control" value="{{$single_product[0]->gst}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">SGST</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_sgst" name="txt_sgst" class="form-control" value="{{$single_product[0]->sgst}}">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Stock (pcs)</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <input type="text" id="txt_prodbussvol" name="txt_prodbussvol" class="form-control" value="{{$single_product[0]->m41_product_bussn_volume}}">
                                      </div>
                                    </div>
                                </div> 

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4 col-sm-4 col-xs-12">Images</label>
                                        <div class="col-md-8 col-sm-8 col-xs-12">
                                          <input type="file" name="prod_fimg[]" id="prod_fimg" class="form-control" multiple>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Short Description</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea type="text" id="txt_prodstrdesc" name="txt_prodstrdesc" class="form-control">{{$single_product[0]->m41_product_str_desc}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-sm-4 col-xs-12">Product Long Description</label>
                                      <div class="col-md-8 col-sm-8 col-xs-12">
                                        <textarea type="text" id="txt_proddesc" name="txt_proddesc" class="form-control" placeholder="Enter Product Description.">{{$single_product[0]->m41_product_desc}}</textarea>
                                      </div>
                                    </div>
                                </div>

                                           

                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button type="submit" class="btn btn-success">Save</button>
                            <button class="btn btn-primary" type="reset">Reset</button>                           
                        </div>
                    </form>
                    @endif
                </div>
    
            </div>

        </div>    
            
        <div class="row">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">PRODUCT MASTER</h3>
                </div>
            
                <div class="collapse in">
                    <div class="panel-body">
                        <div class="text-right">
                            <div class="form-group">
                                <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Product');">Export To Excel</button>
                            </div>
                        </div>
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Vendor Name</th>
                                    <th>Category Name</th>
                                    <th>Sub Category Name</th>
                                    <th>Product Image</th>
                                    <th>Product Name</th>
                                    <th>Quantity</th>
                                    <th>MRP</th>
                                    <th>DP</th>
                                    <th>BP</th>
                                    <th>Wt.</th>
                                    <th>CGST</th>
                                    <th>SGST</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($product as $value)
                                <tr>
                                    <td>#</td>
                                    @foreach($vendor as $v)
                                    @if($v->m40_vendor_id == $value->m41_product_vendor)
                                    <td>{{$v->m40_vendor_name}}</td>
                                    @endif
                                    @endforeach
                                    <td>
                                      @foreach($subcategory as $s)
                                      @if($s->m02_cat_id == $value->m41_product_category)
                                          @foreach($category as $c)
                                          @if($c->m02_cat_id == $s->m02_parent_id)
                                          {{$c->m02_cat_name}}
                                          @endif
                                          @endforeach
                                      @endif
                                      @endforeach
                                    </td>
                                    <td>
                                    @foreach($subcategory as $s)
                                    @if($s->m02_cat_id == $value->m41_product_category)
                                    {{$s->m02_cat_name}}
                                    @endif
                                    @endforeach
                                    </td>
                                    <td>
                                      <img src="{{asset('/images/vendor/'.$value->m41_product_fimage)}}" style="height:50px;width:50px;">
                                    </td>
                                    <td>{{$value->m41_product_name}}</td>
                                    <td>{{$value->m41_product_weight}}</td>
                                    <td>&#8377;{{$value->m41_product_price}}</td>
                                    <td>&#8377;{{$value->m41_product_dp}}</td>
                                    <td>{{$value->m41_product_bussn_volume}}</td>
                                    <td>{{$value->m41_product_weight}}</td>
                                    <td>{{round($value->gst)}}%</td>
                                    <td>{{round($value->sgst)}}%</td>
                                    <td>
                                        <a class="btn btn-success btn-xs" href="{{url('/view_product/'.$value->m41_product_id)}}">EDIT</a>
                                        <a class="btn btn-success btn-xs" href="{{url('/delete_product/'.$value->m41_product_id)}}">DELETE</a>
                                    </td>
                                </tr>      
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $('#dd_prodcat').change(function(){
        var id = $(this).val();
        if(id){
        $.ajax({
           type:"POST",
           url:"{{url('/get_subcat')}}",
           data:{"_token": "{{ csrf_token() }}", "id": id},
           success:function(result)
           {       
                if(result)
                {
                    $("#dd_subprodcat").empty();
                    $("#dd_subprodcat").html(result);
                }else{
                    $("#dd_subprodcat").empty(); 
                }
           }

        });
        }

    });
});
</script>

