@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT STOCK MASTER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <div class="row">
            <div class="col-md-4">
            
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PRODUCT STOCK MASTER</h3>
                    </div>

                    <div class="collapse in">
                        <form class="form-horizontal" enctype="multipart/form-data" action="{{url('add_stock')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                    
                                <div class="form-group">
                                    <label class="control-label">Product Name</label>
                                    <select class="form-control" name="dd_prodid" id="dd_prodid">
                                        <option>Select</option>
                                        @foreach($product as $value)
                                        <option value="{{$value->m41_product_id}}">{{$value->m41_product_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            

                            
                                <div class="form-group">
                                    <label class="control-label">Stock Qty. Cr.</label>
                                    <input type="text" id="txt_qtycr" name="txt_qtycr" class="form-control" placeholder="Enter Stock Qty. Cr.">
                                </div>
                            

                            
                                <div class="form-group">
                                    <label class="control-label">Stock Qty. Dr.</label>
                                    <input type="text" id="txt_qtydr" name="txt_qtydr" class="form-control" placeholder="Enter Stock Qty. Dr.">
                                </div>
                                                              
                            </div>
                            <div class="panel-footer text-center">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button class="btn btn-primary" type="reset">Reset</button>                           
                            </div>
                        </form>
                        
                    </div>
        
                </div>

            </div>

            <div class="col-md-8">    
            
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">PRODUCT STOCK MASTER</h3>
                    </div>
                
                    <div class="collapse in">
                        <div class="panel-body">
                            <div class="text-right">
                                <div class="form-group">
                                    <button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('Product');">Export To Excel</button>
                                </div>
                            </div>
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Product Name</th>
                                        <th>Product Qty.</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($stock as $value)
                                    <tr>
                                        <td>#</td>
                                        <td>
                                            @foreach($product as $p)
                                            @if($p->m41_product_id == $value->m42_product_id)
                                            {{$p->m41_product_name}}
                                            @endif
                                            @endforeach
                                        </td>
                                        <td>{{$value->m42_stock_qty_cr}}</td>
                                    </tr>      
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

