@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT REQUEST FROM STORE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PRODUCT REQUEST FROM STORE</h3>
                </div>
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>Product Name</th>
                                <th class="min-tablet">Product Quantity</th>
                                <th class="min-tablet">Branch Id</th>
                                <th class="min-tablet">Branch Name</th>
                                <th class="min-tablet">MRP</th>
                                <th class="min-tablet">DP</th>
                                <th class="min-tablet">Date</th>
                                <th class="min-tablet">Status/Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($prod_storereq as $value)
                            <tr>
                                <td>#</td>
                                <td>{{$value->m41_product_name}}</td>
                                <td>{{$value->tr32_qty}}</td>
                                <td>{{$value->m44_store_userid}}</td>
                                <td>{{$value->m44_store_name}}</td>
                                <td>{{$value->m41_product_price}}</td>
                                <td>{{$value->m41_product_dp}}</td>
                                <td>{{date("j-F-Y", strtotime($value->tr32_date))}}</td>
                                <td>
                                    <a href="{{url('/verify_status/'.$value->tr32_id)}}">Verify</a> /
                                    <a href="{{url('/reject_status/'.$value->tr32_id)}}">Reject</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div>


        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
