@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT REQUEST HISTORY</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PRODUCT REQUEST HISTORY</h3>
                </div>
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>Product Name</th>
                                <th class="min-tablet">Product DP</th>
                                <th class="min-tablet">Quantity</th>
                                <th class="min-tablet">Date</th>
                                <th class="min-tablet">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($prod_req as $value)
                            <tr>
                                <td>#</td>
                                <td>{{$value->m41_product_name}}</td>
                                <td>{{$value->m41_product_dp}}</td>
                                <td>{{$value->tr32_qty}}</td>
                                <td>{{date("j-F-Y", strtotime($value->tr32_date))}}</td>
                                <td>
                                    @if($value->tr32_status == 0)
                                    Reject
                                    @elseif($value->tr32_status == 1)
                                    Approve
                                    @elseif($value->tr32_status == 2)
                                    Pending
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div>


        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
