@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Update Bank Account</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{ url('/') }}">Settings</a></li>
			<li class="active">Update Bank Account</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		
        <div class="row">
            <div class="col-lg-4">
				
				<div class="panel">

					@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
						<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
					
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
						<h3 class="panel-title">Edit Bank Details</h3>
					</div>
					
					<div class="collapse in">
						@if(!empty($SB_CA))
						<form id="update_wl_bank_account" action="{{ url('update_wl_bank_account/'.$SB_CA[0]->ADMINBANK_ID ) }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
							<div class="panel-body">
								
								<div class="row">
									<div class="form-group">
										<label class="control-label">SELECT BANK  <span class="text-danger">*</span></label>
									    <select class="form-control opt" name="dd_bank" id="dd_bank" required="required">
											<option value="-1">SELECT BANK</option>
											@foreach( $bank as $bnk)
											<option {{($SB_CA[0]->BANK_ID == $bnk->BANK_ID)?'selected':''}}  value="{{$bnk->BANK_ID}}">{{$bnk->BANK_NAME}}</option>
											@endforeach
										</select>
										<span class="text-danger" id="divdd_bank"></span>
									</div>
								
									<div class="form-group">
										<label class="control-label">NAME at ACCOUNT  <span class="text-danger">*</span></label>
										<input type="text" name="txt_name_atbank_account" class="form-control empty" id="txt_name_atbank_account" value="{{$SB_CA[0]->NAME_AT_BANK}}"  placeholder="Enter Fee">
										<span class="text-danger" id="divtxt_name_atbank_account"></span>
									</div>

									<div class="form-group">
										<label class="control-label">BANK BRANCH  <span class="text-danger">*</span></label>
										<input type="text" name="txt_bank_branch" id="txt_bank_branch" class="form-control empty"  value="{{$SB_CA[0]->BANK_BRANCH}}" placeholder="Enter Bank Branch">
										<span class="text-danger" id="divtxt_bank_branch"></span>
									</div> 
									<div class="form-group">
										<label class="control-label">ACCOUNT NUMBER  <span class="text-danger">*</span></label>
										<input type="text" name="txt_bank_account_no" class="form-control empty_accno" id="txt_bank_account_no" value="{{$SB_CA[0]->BANK_ACCOUNT}}" placeholder="Enter Account Number">
										<span class="text-danger" id="divtxt_bank_account_no"></span>
									</div>

									<div class="form-group">
										<label class="control-label">ACCOUNT TYPE  <span class="text-danger">*</span></label>
										<select name="dd_bank_account_type" id="dd_bank_account_type" class="form-control opt">
											<option value="-1">SELECT ACCOUNT TYPE</option>
											<option value="1" {{($SB_CA[0]->BANKACCOUNT_TYPE == 'SAVING')?'selected':''}}>SAVING</option>
											<option value="2" {{($SB_CA[0]->BANKACCOUNT_TYPE == 'CURRENT')?'selected':''}}>CURRENT</option>
										</select>
										<span class="text-danger" id="divdd_bank_account_type"></span>
									</div>
									  
									<div class="form-group">
										<label class="control-label">IFSCODE  <span class="text-danger">*</span></label> 
										<input type="text" name="txt_bank_ifsc"  id="txt_bank_ifsc" class="form-control empty_ifsc" value="{{$SB_CA[0]->BANK_IFSCODE}}"  placeholder="Enter Bank Ifsc">
										<span class="text-danger" id="divtxt_bank_ifsc"></span>
									</div>

									<div class="form-group">
										<label class="control-label">BANK LOGO  <span class="text-danger">*</span></label> 
										<input type="hidden" name="txt_banklogohd" id="txt_banklogohd" value="{{$SB_CA[0]->BANK_LOGO}}"> 
										<input type="file" class="filestyle" data-size="sm" name="txt_banklogo" id="txt_banklogo" accept="image/*" tabindex="-1" style="position: absolute; clip: rect(0px, 0px, 0px, 0px);">
										<div class="bootstrap-filestyle input-group">
											<input type="text" class="form-control input-sm" placeholder="" disabled="" value=""> 
											<span class="group-span-filestyle input-group-btn" tabindex="0">
												<label for="txt_banklogo" class="btn btn-default btn-sm">
												<span class="icon-span-filestyle glyphicon glyphicon-folder-open"></span> 
											<span class="buttonText">Choose file</span></label></span>
										</div>
										<img src="{{ asset('/images/bank_logo/'. $SB_CA[0]->BANK_LOGO) }}" width="50" height="50">
									</div>

									<div class="form-group">   
										<label class="control-label">STATUS  <span class="text-danger">*</span></label>  
										<select name="dd_bank_account_status" id="dd_bank_account_status" class="form-control opt">
											<option {{($SB_CA[0]->BANK_STATUS == 'ACTIVE')?'selected':''}} value="1">ACTIVE</option>
											<option {{($SB_CA[0]->BANK_STATUS == 'IN ACTIVE')?'selected':''}} value="2">IN ACTIVE</option>
										</select>
										<span class="text-danger" id="divdd_bank_account_status"></span>
									</div>
									
								</div> 
								
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" onclick="conw_v('update_wl_bank_account')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@else
						<form id="add_wl_bank_account" action="{{ url('add_wl_bank_account') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
							<div class="panel-body">
								
								<div class="row">
									
									<div class="form-group">
										<label class="control-label">SELECT BANK  <span class="text-danger">*</span></label>
									    <select class="form-control opt" name="dd_bank" id="dd_bank" required="required">
											<option value="-1">SELECT BANK</option>
											@foreach( $bank as $bnk)
											<option value="{{$bnk->BANK_ID}}">{{$bnk->BANK_NAME}}</option>
											@endforeach
										</select>
										<span class="text-danger" id="divdd_bank"></span>
									</div>
								
									<div class="form-group">
										<label class="control-label">NAME at ACCOUNT  <span class="text-danger">*</span></label>
										<input type="text" name="txt_name_atbank_account" class="form-control empty" id="txt_name_atbank_account" value=""  placeholder="ENTER NAME at ACCOUNT">
										<span class="text-danger" id="divtxt_name_atbank_account"></span>
									</div>
									
									
									<div class="form-group">
										<label class="control-label">BANK BRANCH  <span class="text-danger">*</span></label>
										<input type="text" name="txt_bank_branch" id="txt_bank_branch" class="form-control empty"  value=""  placeholder="Enter Bank Branch">
										<span class="text-danger" id="divtxt_bank_branch"></span>
									</div>
									    
									<div class="form-group">
										<label class="control-label">ACCOUNT NUMBER  <span class="text-danger">*</span></label>
										<input type="text" name="txt_bank_account_no" class="form-control empty_accno" id="txt_bank_account_no" value=""  placeholder="Enter Account Number">
										<span class="text-danger" id="divtxt_bank_account_no"></span>
									</div>

									<div class="form-group">
										<label class="control-label">ACCOUNT TYPE  <span class="text-danger">*</span></label>
										<select name="dd_bank_account_type" id="dd_bank_account_type" class="form-control opt">
											<option value="-1">SELECT ACCOUNT TYPE</option>
											<option value="1">SAVING</option>
											<option value="2">CURRENT</option>
										</select>
										<span class="text-danger" id="divdd_bank_account_type"></span>
									</div>
									
									<div class="form-group">
										<label class="control-label">IFSCODE  <span class="text-danger">*</span></label> 
										<input type="text" name="txt_bank_ifsc"  id="txt_bank_ifsc" class="form-control empty_ifsc" value=""  placeholder="Enter Bank Ifsc">
										<span class="text-danger" id="divtxt_bank_ifsc"></span>
									</div>
									
									<div class="form-group">
										<label class="control-label">BANK LOGO  <span class="text-danger">*</span></label> 
										<input type="hidden" name="txt_banklogohd" id="txt_banklogohd" value=""> 
										<input type="file" class="filestyle" data-size="sm" name="txt_banklogo" id="txt_banklogo" accept="image/*" tabindex="-1" style="position: absolute; clip: rect(0px, 0px, 0px, 0px);">
										<div class="bootstrap-filestyle input-group">
											<input type="text" class="form-control input-sm" placeholder="" disabled="" value=""> 
											<span class="group-span-filestyle input-group-btn" tabindex="0">
											<label for="txt_banklogo" class="btn btn-default btn-sm">
											<span class="icon-span-filestyle glyphicon glyphicon-folder-open"></span> 
											<span class="buttonText">Choose file</span></label></span>
										</div>
										
									</div>
									 
									<div class="form-group">
										<label class="control-label">STATUS  <span class="text-danger">*</span></label>  
										<select name="dd_bank_account_status" id="dd_bank_account_status" class="form-control opt">
											<option value="1">ACTIVE</option>
											<option value="2">IN ACTIVE</option>
										</select>
										<span class="text-danger" id="divdd_bank_account_status"></span>
									</div>

								</div>
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" onclick="conw_v('add_wl_bank_account')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
						@endif
					</div>
					
				</div>
				
			</div>
		

			<div class="col-lg-8">
	            <div class="panel">

	                <div class="panel-heading">

	                    <h3 class="panel-title">BONUS POINT WITHDRAW</h3>
	                </div>
	            
	                <div class="panel-body">
	                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
	                        <thead>   
	                            <tr>
									<th>SNo.</th>
									<th>USER ID</th>
									<th>BANK NAME</th>
									<th>NAME at BANK</th>
									<th>ACCOUNT NUMBER</th>
									<th>IFSCODE</th>
									<th>BRANCH</th>
									<th>STATUS</th>
									<th>ACTION</th>
	                            </tr>
	                        </thead>
	                        <tbody>
	                            @foreach($company_bank_account as $CBA)
								<tr>
									<td >#</td>
									<td>{{strtoupper($CBA->USER_NAME)}}[{{$CBA->USER_CONTACTNO}}]</td>
									<td>{{strtoupper($CBA->BANK_NAME)}}</td>
									<td>{{strtoupper($CBA->NAME_AT_BANK)}}</td>
									<td>{{strtoupper($CBA->BANK_ACCOUNT)}}</td>
									<td>{{strtoupper($CBA->BANK_IFSCODE)}}</td>
									<td>{{strtoupper($CBA->BANK_BRANCH)}}</td>
									<td>{{strtoupper($CBA->BANK_STATUS)}}</td>
									<td>
										<a href="{{url('/wl_bank_account/'.$CBA->ADMINBANK_ID)}}" class="btn btn-info btn-xs">Edit</a>
										<button type="button" class="btn {{($CBA->BANK_STATUS=='ACTIVE')?'btn-success':'btn-danger'}} btn-xs" 
										data-toggle="modal" data-target="#demo-default-modal" title="STATUS" onclick="get_status_details(this,'{{ $CBA->ADMINBANK_ID }}','{{ $CBA->BANK_STATUS }}');" data-name="{{$CBA->BANK_ACCOUNT}}" >
										{{$CBA->BANK_STATUS == 'ACTIVE' ? 'ACTIVE' : 'INACTIVE'}}</button>
									</td>
								</tr>
								@endforeach
	                        </tbody>
	                    </table>
	                </div>
	            
	            </div>
	        </div>
        </div>

        <div class="modal fade" id="demo-default-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                <form action="{{url('wl_bank_account_status')}}" method="POST"> 
                    {{ csrf_field() }}

                    <!--Modal header-->
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                        <h4 class="modal-title">CHANGE BANK ACCOUNT STATUS</h4>
                    </div>

                    <!--Modal body-->
                    <div class="modal-body">
                        <div class="form-group">
							<label class="control-label">BANK ACCOUNT NO :-  <span id="packname"></span></label>
							<input id="txt_admin_bank_id" name="txt_admin_bank_id" type="hidden" class="form-control" required="required">
							<input id="txt_admin_bank_status" name="txt_admin_bank_status" type="hidden" class="form-control" required="required">
						</div>
                        <br>
                        <p class="text-semibold text-main">Would you like to change the status of bank?</p>

                    </div>

                    <!--Modal footer-->
                    <div class="modal-footer">
                        <button data-dismiss="modal" class="btn btn-default" type="button">NO</button>
                        <button class="btn btn-primary" type="submit">Yes</button>
                    </div>

                </form>
                </div>
            </div>
        </div>
		
	</div>
	<!--===================================================-->
	<!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script>
	function get_status_details(obj,id,status)
	{
		$('#txt_admin_bank_id').val(id);
		$('#txt_admin_bank_status').val(status);
		$('#packname').html($(obj).data('name'));
	} 
</script>
@endsection