@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Activity Log Details</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Activity</a></li>
        <li class="active">Activity Log Details</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-md-4 col-sm-12 col-xs-12">
            
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('admin_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("admin_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                </div>

            </div>

            <div class="col-md-12 col-sm-12 col-xs-12">

                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Activity Log Details</h3>
                    </div>
                    
                    <div class="collapse in">
                    <div class="panel-body">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>S.NO.</th>
                                    <th>OLD VALUE</th>
                                    <th>NEW VALUE</th>
                                    <th class="min-tablet">DESC</th>
                                    <th class="min-tablet">UPDATED BY</th>
                                    <th class="min-tablet">UPDATED AT</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1;?>
                                @foreach($user_action_log as $con)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$con->ACT_OLD_VAL}}</td>
                                    <td>{{$con->ACT_NEW_VAL}}</td>
                                    <td>{{$con->ACT_DESC}}</td>
                                    <td>{{$con->ACT_UPDATED_BY}}</td>
                                    <td>{{$con->ACT_DATE}}</td>
                                </tr>
                                @endforeach
                            
                            </tbody>    
                        </table>
                    </div>
</div>
            
                </div>
            
                
            </div>

            
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection