@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Upload KYC</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{ url('/') }}">Join Us</a></li>
			<li class="active">Upload KYC</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
			@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Upload KYC</h3>
					</div>
					
                    <div class="collapse in">
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form action="{{ url('update_userkyc')}}" enctype="multipart/form-data" id="kyc_update" 
						method="post" accept-charset="utf-8">
						{{ csrf_field() }}
                            <div class="panel-body">
							<div class="row">
									<div class="col-md-6" hidden>
		                              <div class="form-group">
		                                 <label class="control-label" for="dd_quali">Qualification  <span class="text-danger">*</span></label>
		                                 <select class="selectpicker opt" name="dd_quali" id="dd_quali" required="required" data-live-search="true" data-width="100%">
		                                    <!-- <option value="">SELECT ID QUALIFICATION</option> -->
		                                    <option value="1" {{($con->Qualification1==1)?'selected':''}}>SSC</option>
		                                    <option value="2" {{($con->Qualification1==2)?'selected':''}}>HSC</option>
		                                    <option value="3" {{($con->Qualification1==3)?'selected':''}}>GRADUATE</option>
		                                    <option value="4" {{($con->Qualification1==4)?'selected':''}}>POST GRADUATE</option>
											<option value="4" {{($con->Qualification1==5)?'selected':''}}>DIPLOMA</option>
		                                 </select>
										<span class="text-danger" id="divdd_quali"></span>
		                              </div>
		                            </div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_yourphoto">Upload Your Photo</label>
											<input type="hidden" name="txt_yourphotohd" id="txt_yourphotohd" value="{{$con->MemberImage}}"> 
											<input type="file" name="txt_yourphoto" id="txt_yourphoto" class="form-control" required>
											<span class="text-danger" id="divtxt_yourphoto"></span>

										</div>
										@if($con->MemberImage!='')
										<img src="{{ asset('/images/USER_PHOTO/'.$con->MemberImage) }}" height="100" />
										@else
										<img src="{{ asset('images/user.png') }}" height="100" />
										@endif
									</div>
										
								</div>
                                <div class="row">
									<legend>Id Proof</legend>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="ddidproof">Id Proof Type  <span class="text-danger">*</span></label>
                                            <select class="form-control opt" name="dd_idprooftype" id="dd_idprooftype" required="required">
												<option value="">SELECT ID PROOF</option>
												<option value="1" {{($con->IDProofType1==1)?'selected':''}}>INTERNATIONAL ID CARD</option>
												<option value="2" {{($con->IDProofType1==2)?'selected':''}}>DRIVING LICENSE</option>
												<option value="3" {{($con->IDProofType1==3)?'selected':''}}>GOVT.ISSUED IDENTITY CARD</option>
												<option value="4" {{($con->IDProofType1==4)?'selected':''}}>PASSPORT</option>
											</select>
											<span class="text-danger" id="divdd_idprooftype"></span>
										</div>

									</div>		

									<div class="col-md-6">
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharcard">Id Proof  <span class="text-danger">*</span></label>
                                            <input type="text" name="txt_aadharcard" id="txt_aadharcard" class="form-control" placeholder="Enter Id Proof Number." required value="{{$con->AadharCard}}">
                                            <span id="txt_aad_err" style="color:red;"></span>
                                            <span class="text-danger" id="divtxt_aadharcard"></span>
										</div>
									</div>
									<div class="col-md-6">	
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharfront">Upload Id Proof Front  <span class="text-danger">*</span></label>
											<input type="hidden" name="txt_aadharfronthd" id="txt_aadharfronthd" value="{{$con->AadharFront}}">
                                            <input type="file" name="txt_aadharfront" id="txt_aadharfront" class="form-control" >
                                            <span class="text-danger" id="divtxt_aadharfront"></span>
                                            </br>
											@if($con->AadharFront!='')
											<img src="{{ asset('/images/USER_IDPROOF/'.$con->AadharFront) }}" height="100" />
											@else
											<img src="{{ asset('images/aadhar.jpg') }}" height="100" />
											@endif
										</div>
									</div>

									<div class="col-md-6">
										<div class="form-group">
                                            <label class="control-label" for="txt_aadharback">Upload Id Proof Back  <span class="text-danger">*</span></label>
											<input type="hidden" name="txt_aadharbackhd" id="txt_aadharbackhd" value="{{$con->AadharBack}}">
                                            <input type="file" name="txt_aadharback" id="txt_aadharback" class="form-control" >
                                            <span class="text-danger" id="divtxt_aadharback"></span>
                                            </br>
			                                @if($con->AadharBack!='')
			                                <img src="{{ asset('/images/USER_IDPROOF/'.$con->AadharBack) }}" height="100" />
			                                @else
			                                <img src="{{ asset('images/aadhar.jpg') }}" height="100" />
			                                @endif
										</div>
									</div>
								</div>
								
                                <div class="row">
                                	<legend>Upload Address Proof</legend>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="ddaddproof">Address Proof  <span class="text-danger">*</span></label>
                                            <select class="form-control opt" id="ddaddproof" name="ddaddproof" required>
                                               <option value="1" {{($con->AddProofType1==1)?'selected':''}}>INTERNATIONAL ID CARD</option>
												<option value="2" {{($con->AddProofType1==2)?'selected':''}}>DRIVING LICENSE</option>
												<option value="3" {{($con->AddProofType1==3)?'selected':''}}>GOVT.ISSUED IDENTITY CARD</option>
												<option value="4" {{($con->AddProofType1==4)?'selected':''}}>PASSPORT</option>
											</select>
											<span class="text-danger" id="divddaddproof"></span>
										</div>
									</div>	
									<div class="col-md-6">		
                                        <div class="form-group">
                                            <label class="control-label" for="txt_pancard">Address Proof Number <span style="color:red">*</span></label>
                                            <input type="text" name="txt_pancard" id="txt_pancard" class="form-control empty" placeholder="Enter Id Number." required value="{{$con->Pancarno}}">
											<span class="text-danger" id="divtxt_pancard"></span>
										</div>
									</div>		
									<div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_idproof">Address Proof Front <span class="text-danger">*</span></label>
											<input type="hidden" name="txt_idproofhd" id="txt_idproofhd" value="{{$con->IDProof}}">
                                            <input type="file" name="txt_idproof" id="txt_idproof" class="form-control" required>
                                            <span class="text-danger" id="divtxt_idproof"></span>
                                            </br>
											@if($con->IDProof!='')
											<img src="{{ asset('/images/USER_IDPROOF/'.$con->IDProof) }}" height="100" />
											@else
											<img src="{{ asset('images/pan_card.jpg') }}" height="100" />
											@endif
										</div>
									</div>	
									<div class="col-md-6">
										
                                        <div class="form-group">
                                            <label class="control-label" for="txt_addressproof">Address Proof  Back<span class="text-danger">*</span></label>
											<input type="hidden" name="txt_addressproofhd" id="txt_addressproofhd" value="{{$con->AddressProof}}"> 
                                            <input type="file" name="txt_addressproof" id="txt_addressproof" class="form-control" required value="{{$con->AddressProof}}">
											<span class="text-danger" id="divtxt_addressproof"></span>
											</br>
                                            @if($con->AddressProof!='')
											<img src="{{ asset('/images/USER_ADDRESSPROOF/'.$con->AddressProof) }}" height="100" />
											@else
											<img src="{{ asset('images/aadhar.jpg') }}" height="100" />
											@endif
										</div>
									</div>

									<div class="col-md-12">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_address">Address <span class="text-danger">*</span></label>
			                              <textarea class="form-control empty" id="txt_address" name="txt_address" rows="5" required>{{$con->Address}}</textarea>
											<span class="text-danger" id="divtxt_address"></span>
			                           </div>
			                        </div>
                                    
                                    <div class="col-md-6 text-center" style="margin-top:10%;">
										
									</div>
									
								</div>
								
							</div>
							@if($con->KYCStatus=='PENDING' || $con->KYCStatus=='RESUBMIT')
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conw_v('kyc_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
							@endif
						</form>
                        
					</div>       
				</div>
			</div>
            
		</div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection