@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Update Bank Account</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Join Us</a></li>
        <li class="active">Update Bank Account</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-3 col-lg-6">
            @if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Update Bank Account</h3>
                    </div>

                    <div class="collapse in">
			@if($get_useralldetail != '')
						@foreach( $get_useralldetail as $con)
						@endforeach
						<form id="bankdetails_update" action="{{ url('update_userbankdetails') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
							{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_nameatbank">A/C Holder Name  <span class="text-danger">*</span></label>
                                            <input type="text" id="txt_nameatbank" name="txt_nameatbank" class="form-control aplha_only" placeholder="Enter A/C Holder Name." value="{{$con->NAMEatBANK}}" required>
                                            <span class="text-danger" id="divtxt_nameatbank"></span>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_cbsacno">CBS A/C Number <span style="color:red">*</span></label>
                                            <input type="number" id="txt_cbsacno" name="txt_cbsacno" class="form-control empty_accno" placeholder="Enter CBS A/C Number." value="{{$con->CBSACno}}" required>
											<span id="txt_acc_err" style="color:red;"></span>
                                            <span class="text-danger" id="divtxt_cbsacno"></span>
										</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_bank">Bank Name <span class="text-danger">*</span></label>
                                            <select class="selectpicker opt" name="txt_bankname" id="txt_bankname" data-live-search="true" data-width="100%">
                                                <option value="">Select Bank Name </option>
                                                @foreach($banks as $b)
                                                <option value="{{$b->BANK_ID}}"  {{$con->BANKNo == $b->BANK_ID? 'selected':''}}>{{$b->BANK_NAME}}</option>
                                                @endforeach
                                            </select>
                                            <span class="text-danger" id="divtxt_bankname"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bankifsccode">IFSC Code <span class="text-danger">*</span></label>
                                            <input type="text" id="txt_bankifsccode" name="txt_bankifsccode" class="form-control empty_ifsc" placeholder="Enter IFSC Code." value="{{$con->IFSCode}}" required>
                                            <span class="text-danger" id="divtxt_bankifsccode"></span>
										</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_bankbranch">Bank Branch  <span class="text-danger">*</span></label>
                                            <input type="text" id="txt_bankbranch" name="txt_bankbranch" class="form-control empty" placeholder="Enter Bank Branch."  value="{{$con->Branch}}" required>
                                            <span class="text-danger" id="divtxt_bankbranch"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                       <div class="form-group">
                                            <label class="control-label" for="txt_cancelchq">Account Proof <span class="text-danger">*</span></label>
											<input type="hidden" name="txt_cancelchqhd" id="txt_cancelchqhd" value="{{$con->CancelCheque}}"> 
                                            <input type="file" name="txt_cancelchq" id="txt_cancelchq" class="form-control" required>
                                        </div>
										
                                    </div>
									<div class="col-md-12">
									@if($con->CancelCheque == '')
									<img src="{{ asset('/images/check_image.jpg') }}" width="100%"/> 
									@elseif($con->CancelCheque != '')
									<img src="{{ asset('/images/CANCEL_CHEQUE/'.$con->CancelCheque) }}" width="100%" /> 
									@endif
									</div>

                                </div>    
                            </div>
                            <div class="panel-footer text-center">
                                @if($con->BankStatus == 'VERIFIED')
                                    <button class="btn btn-success"  type="button"><i class="fa fa-check-square-o" aria-hidden="true"></i> Bank Account Verified</button>
                                @else
                                <button class="btn btn-success"  type="button" onclick="conw_v('bankdetails_update')">Update</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
                                @endif
                            </div>
                        </form>
                        @endif
                    </div>
        
                </div>
            </div>
            
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection