@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">BONUS POINT DETAILS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">DATEWISE TOPUP DETAILS</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{ url('user_datewise_business') }}"  method="post" accept-charset="utf-8">
									{{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_from">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_from" id="txt_from" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>    
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtto">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_to" id="txt_to" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                        </div>
                                    </div>
                                </div> 
                                @if(Session()->get('USER_ROLE_ID') == 'BRANCH')
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtuserid">User Id</label>
                                        <input type="text" name="txtuserid" id="txtuserid" class="form-control" placeholder="Enter User Id." >
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                        </div>
                    </form>
                    
                </div>
    
            </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>TOPUP_DATE</th>
                                <th class="min-tablet">TOTAL_TOPUPLEFT</th>
                                <th class="min-tablet">TOTAL_TOPUPRIGHT</th>
                                <th class="min-tablet">TOTAL_LEFTPV</th>
                                <th class="min-tablet">TOTAL_RIGHTPV</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $sn = 1;?>
								@foreach( $business_report as $con)
								<tr>
									<td>{{ $sn++ }}</td>
								    <td>{{ $con->TOPUP_DATE}}</td>
								    <td>{{ $con->TOTAL_LEFT}}</td>
								    <td>{{ $con->TOTAL_RIGHT}}</td>
								    <td>{{ $con->TOTAL_LEFTPV}}</td>
								    <td>{{ $con->TOTAL_RIGHTPV}}</td>
								</tr>
								@endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
