@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shop Details</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{ url('/') }}">Join Us</a></li>
			<li class="active">Shop Details</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
            @endforeach
		</ul>
	</div>
    @endif
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
				@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Shop Details</h3>
					</div>
					
                    <div class="collapse in">
						@foreach($user_shop_details as $con)
						@endforeach
						<form action="{{url('user_update_shop_details')}}" enctype="multipart/form-data" id="shop_update" 
						method="post" accept-charset="utf-8">
						{{ csrf_field() }}
                            <div class="panel-body">
								<div class="row">
									<input type="hidden" name="txt_shop_id" id="txt_shop_id" class="form-control" value="{{$shop_info[0]->m22_shop_id}}" required>
									<div class="col-md-6">
		                                <div class="form-group">
		                                 	<label class="control-label" for="txt_shop_name">Shop Name <span class="text-danger">*</span></label>
		                                 	<input type="text" name="txt_shop_name" id="txt_shop_name" class="form-control empty" value="{{$con->Shop_CompanyName}}" required>
											<span class="text-danger" id="divtxt_shop_name"></span>
		                                </div>
		                            </div>

		                            <div class="col-md-6">
		                                <div class="form-group">
		                                 	<label class="control-label" for="txt_shop_gst">GST Number</label>
		                                 	<input type="text" name="txt_shop_gst" id="txt_shop_gst" class="form-control" value="{{$con->ShopGST}}" required>
		                                </div>
		                            </div>

		                            <div class="col-md-6">
		                                <div class="form-group">
		                                 	<label class="control-label" for="txt_shop_image">Shop Front Image <span class="text-danger">*</span></label>
		                                 	<input type="file" name="txt_shop_image" id="txt_shop_image" class="form-control">
		                                 	<input type="hidden" name="txt_shophd" id="txt_shophd" value="{{$con->ShopIMAGE}}"> 
		                                </div>
		                                @if($con->ShopIMAGE!='')
										<img src="{{ asset('/images/SHOP_IMAGE/'.$con->ShopIMAGE) }}" height="100" />
										@else
										<img src="{{ asset('images/user.png') }}" height="100" />
										@endif
		                            </div>

		                            <div class="col-md-6">
		                                <div class="form-group">
		                                 	<label class="control-label" for="txt_gst_image">GST Certificate</label>
		                                 	<input type="file" name="txt_gst_image" id="txt_gst_image" class="form-control">
		                                 	<input type="hidden" name="txt_gsthd" id="txt_gsthd" value="{{$con->ShopGSTImage}}"> 
		                                </div>
		                                @if($con->ShopGSTImage!='')
										<img src="{{ asset('/images/GST_CERTIFICATE/'.$con->ShopGSTImage) }}" height="100" />
										@else
										<img src="{{ asset('images/user.png') }}" height="100" />
										@endif
		                            </div>

		                            <div class="col-md-6">
		                              <div class="form-group">
		                                 <label class="control-label" for="dd_shop_type">Shop Type <span class="text-danger">*</span></label>
		                                 <select class="selectpicker opt" name="dd_shop_type" id="dd_shop_type" required="required" data-live-search="true" data-width="100%">
		                                    <option value="">SELECT TYPE</option>
		                                    <option value="1" {{($con->ShopType1==1)?'selected':''}}>Kirana Shop</option>
		                                    <option value="2" {{($con->ShopType1==2)?'selected':''}}>Mobile Shop</option>
		                                    <option value="3" {{($con->ShopType1==3)?'selected':''}}>Copier Shop</option>
		                                    <option value="4" {{($con->ShopType1==4)?'selected':''}}>Internet Cafe</option>
		                                    <option value="5" {{($con->ShopType1==5)?'selected':''}}>Medical Store</option>
		                                    <option value="6" {{($con->ShopType1==6)?'selected':''}}>PanShop</option>
		                                    <option value="7" {{($con->ShopType1==7)?'selected':''}}>Confectionary Store</option>
		                                 </select>
										<span class="text-danger" id="divdd_shop_type"></span>
		                              </div>
		                            </div>

		                            <div class="col-md-6">
		                              <div class="form-group">
		                                 <label class="control-label" for="dd_loc_type">Locality Type <span class="text-danger">*</span></label>
		                                 <select class="selectpicker opt" name="dd_loc_type" id="dd_loc_type" required="required" data-live-search="true" data-width="100%">
		                                    <option value="">SELECT LOCALITY TYPE</option>
		                                    <option value="1" {{($con->ShopLocationType1==1)?'selected':''}}>Rural</option>
		                                    <option value="2" {{($con->ShopLocationType1==2)?'selected':''}}>Urban</option>
		                                    <option value="3" {{($con->ShopLocationType1==3)?'selected':''}}>Semi Urban</option>
		                                 </select>
										<span class="text-danger" id="divdd_loc_type"></span>
		                              </div>
		                            </div>

		                            <div class="col-md-6">
		                              <div class="form-group">
		                                 <label class="control-label" for="dd_loc_type">Select Population</label>
		                                 <select class="selectpicker opt" name="dd_popl" id="dd_popl" required="required" data-live-search="true" data-width="100%">
		                                    <option value="">SELECT POPULATION</option>
		                                    <option value="1" {{($con->ShopNearPollution1==1)?'selected':''}}>0 to 2000</option>
		                                    <option value="2" {{($con->ShopNearPollution1==2)?'selected':''}}>2000 to 5000</option>
		                                    <option value="3" {{($con->ShopNearPollution1==3)?'selected':''}}>5000 to 10000</option>
		                                    <option value="4" {{($con->ShopNearPollution1==4)?'selected':''}}>10000 to 50000</option>
		                                    <option value="5" {{($con->ShopNearPollution1==5)?'selected':''}}>10000 to 50000</option>
		                                 </select>
										<span class="text-danger" id="divdd_popl"></span>
		                              </div>
		                            </div>

		                            <div class="col-sm-6">
										<div class="form-group">
				                            <label class="control-label">Country <span class="text-danger">*</span></label>
				                            <select class="selectpicker opt" id="dd_country" name="dd_country" data-live-search="true" data-width="100%">
				                                <option value="-1">Select Country</option>
				                                @foreach($data['country'] as $value)
				                                <option value="{{$value->LOC_ID}}" {{$con->ShopCountry == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
				                                @endforeach
				                            </select>
										<span class="text-danger" id="divdd_country"></span>
				                        </div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
				                            <label class="control-label">State <span class="text-danger">*</span></label>
											<select class="selectpicker opt" id="dd_state" name="dd_state" data-live-search="true" data-width="100%">
				                                <option value="-1">Select State</option>
												@foreach($data['state'] as $value)
				                                <option value="{{$value->LOC_ID}}" {{$con->ShopState == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
				                                @endforeach
				                            </select>
										<span class="text-danger" id="divdd_state"></span>
					                   </div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
				                            <label class="control-label">City <span class="text-danger">*</span></label>
				                            <select class="selectpicker opt" name="dd_city" id="dd_city" data-live-search="true" data-width="100%">
				                                <option value="-1">Select City</option>
												@foreach($data['city'] as $value)
				                                <option value="{{$value->LOC_ID}}" {{$con->ShopCity == $value->LOC_ID ? 'selected' : ''}}>{{$value->LOC_NAME}}</option>
				                                @endforeach
				                            </select>
										<span class="text-danger" id="divdd_city"></span>
					                  	</div>
									</div>

			                        <div class="col-md-6">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_block">Block <span class="text-danger">*</span></label>
			                              <input type="text" class="form-control empty" id="txt_block" name="txt_block" value="{{$con->ShopBlock}}">
										<span class="text-danger" id="divtxt_block"></span>
			                           </div>
			                        </div>

			                        <div class="col-md-6">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_mohhalla">Mohhalla <span class="text-danger">*</span></label>
			                              <input type="text" class="form-control empty" id="txt_mohhalla" name="txt_mohhalla" value="{{$con->ShopMohhalla}}">
										<span class="text-danger" id="divtxt_mohhalla"></span>
			                           </div>
			                        </div>

			                        <div class="col-md-6">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_landmark">Landmark <span class="text-danger">*</span></label>
			                              <input type="text" class="form-control empty" id="txt_landmark" name="txt_landmark" value="{{$con->ShopLandmark}}">
										<span class="text-danger" id="divtxt_landmark"></span>
			                           </div>
			                        </div>

			                        <div class="col-md-6">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_pincode">Pincode <span class="text-danger">*</span></label>
			                              <input type="text" class="form-control empty_pincode" id="txt_pincode" name="txt_pincode" value="{{$con->ShopPincode}}">
										<span class="text-danger" id="divtxt_pincode"></span>
			                           </div>
			                        </div>

			                        <div class="col-md-12">
			                           <div class="form-group">
			                              <label class="control-label" for="txt_address">Address <span class="text-danger">*</span></label>
			                              <textarea class="form-control empty" id="txt_address" name="txt_address" rows="5">{{$con->Shop_Address}}</textarea>
										<span class="text-danger" id="divtxt_address"></span>
			                           </div>
			                        </div>
										
								</div>

								
							</div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="button" onclick="conw_v('shop_update')">UPDATE</button>
								<button type="reset" class="btn btn-primary">RESET</button>	
							</div>
						</form>
                        
					</div>       
				</div>
			</div>
            
		</div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection