@extends('mainlayout')
@section('content')
<style>

.scroll {
    height: 340px;
    overflow-y: auto;
    overflow-x: hidden;
}

/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

.swal-modal {
    width: 300px;
    opacity: 0;
    pointer-events: none;
    background-color: #fff;
    text-align: center;
    border-radius: 5px;
    position: static;
    margin: 20px auto;
    display: inline-block;
    vertical-align: middle;
    -webkit-transform: scale(1);
    transform: scale(1);
    -webkit-transform-origin: 50% 50%;
    transform-origin: 50% 50%;
    z-index: 10001;
    transition: opacity .2s,-webkit-transform .3s;
    transition: transform .3s,opacity .2s;
    transition: transform .3s,opacity .2s,-webkit-transform .3s;
}
.swal-button {
    background-color: #5cb95d;
    color: #fff;
    border: none;
    box-shadow: none;
    border-radius: 7px;
    font-weight: 600;
    font-size: 14px;
    padding: 3px 16px;
    margin: 0;
    cursor: pointer;
}
.swal-text {
    color: #f44336;
}
.swal-text:first-child {
    margin-top: 30px;
}

</style>
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Mobile Recharge</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/') }}">Recharge</a></li>
			<li class="active">Mobile Recharge</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
				@if($UserService == 'OFF')
                    <div class="alert alert-warning alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">Service Not Active</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
				@endif
			 <div class="col-md-3">
            <div class="panel">
                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                <div class="panel-heading">
                    <h3 class="panel-title">RECHARGE PANEL</h3>
				</div>
                <div class="panel-body">
                    
                  	<div class="" role="tabpanel" data-example-id="togglable-tabs">
						<!-- <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
							<li role="presentation" class="active"><a href="#tab_content1" id="home-tab" role="tab" data-toggle="tab" aria-expanded="true"><span><img src="{{ asset($folder.'/images/icon/mobile.png')}}" style="width:20px;"></span> Mobile</a></li>
						</ul> -->
						<div id="myTabContent" class="tab-content">
							<div role="tabpanel" class="tab-pane fade active in" id="tab_content1" aria-labelledby="home-tab">
								<div class="col-md-12 col-sm-12 col-xs-12">	
									<form action="{{ url('recharge') }}"  class="cmxform form-horizontal" id="prepaidForm" method="post" accept-charset="utf-8"  autocomplete="off">
										{{ csrf_field() }}
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<!--div class="form-group">
												<p>
												<input type="radio" class="flat" name="url_for" id="url_forprepaid" value="1" checked="" required /> PREPAID
												<input type="radio" class="flat" name="url_for" id="url_forpostpaid" value="2" /> POSTPAID
												</p>
												<span id="divtxt_vender" style="color:red;"></span>
											</div-->
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Enter Mobile No</label>  
												<input type="number" id="txt_mobileno" name="txt_mobileno"  @if($UserService == 'ON') oninput="get_plan_and_last_rech(this.id)" @endif class="form-control" required="required" >
												<span id="divtxt_mobileno" style="color:red;"></span> 
											</div>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Select Operator</label>
												<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_brand" id="dd_brand" required="required">
													<option value="-1">SELECT OPERATOR</option>
													@foreach( $OPERATOR as $OPT)
													<option value="{{$OPT->TelecomBrandId}}">{{strtoupper($OPT->BrandName)}}</option>
													@endforeach
												</select>
												<input type="hidden" id="txt_circleid" name="txt_circleid" class="form-control" required="required">
												<input type="hidden" id="txt_circlecode" name="txt_circlecode" class="form-control" required="required">
												<span id="divdd_role" style="color:red;"></span>
											</div>
										</div>   
										<!--div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<a href="#!" data-target="#view-plans" data-toggle="modal" class="view-plans-link">View Plans</a>
											</div>
										</div-->
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Enter Amount</label>  
												<input type="number" id="txt_amount" name="txt_amount" class="form-control" required="required">
												<span id="divtxt_amount" style="color:red;"></span> 
											</div>
										</div>

										<div class="clearfix"></div>
										<div class="clearfix"></div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="form-group">
												<button type="button" class="btn btn-success" onclick=" confirm_details_prepaid('prepaidForm')" {{$UserService == 'OFF'? 'disabled':''}}>RECHARGE NOW</button>
												<button type="reset" class="btn btn-primary">RESET</button>	
											</div>
										</div>
									</form>
								</div>
								<script>
									function confirm_details_prepaid(get_id) {
										var txt;
										var operator=$('#dd_brand').val();
										var txt_mobileno=$('#txt_mobileno').val();
										var txt_amount=$('#txt_amount').val();
										if(txt_mobileno.length != 10)
										{
											$('#divtxt_mobileno').html('<span>Enter Valid Phone Number !</span>');
										}
										else if(operator == -1)
										{
											$('#divdd_role').html('<span>Select Operator !</span>');
										}
										else if(txt_amount < 10)
										{
											swal({
											  text: "Must be a amount greater than 9 !",
											});
										}
										else{
												$('#divtxt_mobileno').html('');
												$('#divdd_role').html('');
										bootbox.confirm('Are you sure to Recharge this number-'+txt_mobileno+' with amount of '+txt_amount+'.Please Confirm.?', function(result){
											if(result==true)
											{
												alert("You pressed OK!");
												document.getElementById(get_id).submit();
											}
											else {
												alert("You pressed Cancel!");
											}
										});
										}
									}
								</script>
							</div>
						</div>
					</div> 
				</div>
			</div>
		</div>

        <div class="col-md-5">
            <div class="panel">
            
                <div class="panel-body scroll">
                    <table class="table table-striped table-bordered" id="plans" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>AMOUNT</th>
								<th>PLAN INFO</th>
								<th>SELECT PLAN</th>
							</tr>
						</thead>
						<tbody>
							<tr>

							</tr>
						</tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="panel">
            
                <div class="panel-body">
                    <table class="table table-striped table-bordered" id="last_trans" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>CONSUMERNO</th>
								<th>AMOUNT</th>
								<th>SELECT PLAN</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
							     <th>S.NO</th>
								<th>CONSUMERNO</th>
								<th>OPERATOR</th>
								<th>STATUS</th>
								<th>AMOUNT</th>
								<th>TXN ID</th>
								<th>TXN DATE</th>
							</tr>
						</thead>
						<tbody>
							@foreach( $rec_report as $key => $con)
							<tr>
								<td>{{$key+1}}</td>
								<td>{{ $con->Account }}</td>
								<td><img src="{{ asset('images/brand_image/'.$con->ServiceProviderIMAGE) }}" style="width:50px;height:50px;"></td>
								<td>
									@if( $con->Status == 'SUCCESS') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
									@elseif( $con->Status == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
									@endif
								</td>
								<td>{{ $con->Amount }}</td>
								<td>{{ $con->LiveId }}</td>
								<td>{{ $con->RequestDate }}</td>
								
							</tr>
							@endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
 <script>
 function get_plan_and_last_rech(id) {
        var phone = $("#"+id).val();
        if(phone.length == 10)
        {
            $.ajax({
               type:"POST",
               url:"{{ url('/check_mobile_roffer')}}",
               data:{"_token": "{{ csrf_token() }}", "mobile":phone },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
						$('#dd_brand').val(result['brand_id']);
						$('#txt_circleid').val(result['circle_id']);
						$('#txt_circlecode').val(result['circle_code']);
                        $('#plans').empty();
						$('#divtxt_mobileno').html('');
						$('#divdd_role').html('');
						if(result['ROFFER'][0].desc != 'Unable to Plans')
						{
						$("#plans").append("<thead><tr><th>AMOUNT</th><th>PLAN INFO</th><th>SELECT PLAN</th></tr></thead><tbody>");
                        $.each(result['ROFFER'],function(key,value){
                            $("#plans").append("<tr><td>"+result['ROFFER'][key].rs+"</td><td>"+result['ROFFER'][key].desc+"</td><td><button class='btn btn-success btn-xs' onclick='select_plan_amo("+result['ROFFER'][key].rs+")'>SELECT </button></td></tr>");
                        });
						}
						else
						{
								$("#plans").append("<thead><tr><th>AMOUNT</th><th>PLAN INFO</th><th>SELECT PLAN</th></tr></thead><tbody>");
						}
					$("#plans").append("</tbody>");

                        $('#last_trans').empty();
						$("#last_trans").append("<thead><tr><th>AMOUNT</th><th>LIVE ID</th><th>DATE</th><th>REPEAT PLAN</th></tr></thead><tbody>");
                        $.each(result['LAST5TRANSACTION'],function(key,value){
                            $("#last_trans").append("<tr><td>"+result['LAST5TRANSACTION'][key].Amount+"</td><td>"+result['LAST5TRANSACTION'][key].LiveId+"</td><td>"+result['LAST5TRANSACTION'][key].RequestDate3+"</td><td><button class='btn btn-success btn-xs' onclick='select_plan_amo("+result['LAST5TRANSACTION'][key].Amount+")'>SELECT </button></td></tr>");
                        });
					$("#last_trans").append("</tbody>");

                        $('.selectpicker').selectpicker('refresh');
                    }    
               }

            });
        }
        }

 function select_plan_amo(prs) {
 $('#txt_amount').empty();
 $('#txt_amount').val(prs);
}
 </script>
@endsection