@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">CashBack Ledger Statement</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Wallet</a></li>
        <li class="active">CashBack Ledger Statement</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">

            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Promotional Ledger</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('/user_promotional_ledger')}}" method="post">
    					{{ csrf_field() }} 
                            <div class="panel-body form-horizontal form-padding">

                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txtfromdate">From Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_from" id="txt_from" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>
                                        </div> 
                                    </div>                               
                                
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txt_to">To Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_to" id="txt_to" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txt_memberid">Member Id</label>
                                            <div class="col-md-9">
                                                <input type="text" name="txt_memberid" id="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                           
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                    </div>
        
                </div>
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID/NAME</th>
								<th>TRANSACTIONID</th>
								<th>TRANSACTIONDATE</th>
								<th>DESCRIPTION</th>
								<th>CR.AMOUNT</th>
								<th>DR.AMOUNT</th>
								<th>BALANCEFOR</th>
								<th>MAINBAL</th>
								<th>PAYOUTBAL</th>			
								<th>REWARDBAL</th>			
							</tr>
						</thead>
						<tbody>
							@foreach( $ledger_report as $con)
							 <tr>
							 <td >{{'#'}}</td >
            <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
			<td>{{$con->Transactionid}}</td>
			<td>{{$con->TransactionDate}}</td>
			<td>{{$con->Description}}</td>
			<td>{{$con->AmountCredited}}</td>
			<td>{{$con->AmountDedited}}</td>
			<td>{{$con->BalanceType}}</td>
			<td>{{$con->CurrentBalance}}</td>
			<td>{{$con->UtilityBalance}}</td>
			<td>{{$con->RemittanceBalance}}</td>
			</tr>
			 @endforeach
			 </tbody>
                    </table>
                </div>
            
            </div>
        </div>   
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection