@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Landline Bill</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/') }}">Bill Pay</a></li>
			<li class="active">Landline Bill</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
				@if($UserService == 'OFF')
                    <div class="alert alert-warning alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">Service Not Active</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
				@endif
			<div class="col-md-4">
            <div class="panel">
				@if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                <div class="panel-heading">
                    <h3 class="panel-title">LANDLINE BILL PANEL</h3>
				</div>
                <div class="panel-body">
                    
                    <div class="" role="tabpanel" data-example-id="togglable-tabs">
							<!-- ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">

						<li role="presentation" class="active"><a href="#tab_content4" role="tab" id="profile-tab4" data-toggle="tab" aria-expanded="false"><span><img src="{{ asset($folder.'/images/icon/landline.png')}}" style="width:20px;"></i></span> Landline</a></li>
					
						</ul> -->
						<div id="myTabContent" class="tab-content">

							<div role="tabpanel" class="tab-pane fade active in" id="tab_content4" aria-labelledby="profile-tab4">
								<div class="col-md-12 col-sm-12 col-xs-12">	
									<form action="{{ url('landline') }}"  class="cmxform form-horizontal" id="llbillForm" method="post" accept-charset="utf-8" autocomplete="off">
										{{ csrf_field() }}
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Select Operator</label>
												<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_brand" id="dd_brand" required="required">
													<option value="-1">SELECT OPERATOR</option>
													@foreach( $LANDLINE as $OPT)
													<option value="{{$OPT->BrandCode}}">{{strtoupper($OPT->BrandName)}}</option>
													@endforeach
												</select>
												<span id="divdd_role" style="color:red;"></span>
											</div>
										</div> 
										<div id="hide">
											<!--div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Enter Customer Mobile Number</label>  
													<input id="txt_llcustmobile" name="txt_llcustmobile" type="text" class="form-control" required="required">
													<span id="divtxt_llcustmobile" style="color:red;"></span> 
												</div>
											</div-->
											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Enter Number</label>  
													<input id="txt_number" name="txt_number" type="text" class="form-control" required="required">
													<span id="divtxt_llnumber" style="color:red;"></span> 
												</div>
											</div>
											<div class="col-md-12 col-sm-12 col-xs-12" id="account">
												<div class="form-group">
													<label class="control-label" id="account_text">Enter Account No</label>  
													<input id="txt_account" type="text" name="txt_account" class="form-control" required="required">
													<span id="divtxt_account" style="color:red;"></span> 
												</div>
											</div>
											  @if($UserService == 'ON')
											<div class="col-md-12 col-sm-12 col-xs-12" >
													<div class="form-group">
														<a href="#!" onClick="find_llbill()"  data-target="#view-plans" data-toggle="modal" class="btn btn-primary">View Bill Amount</a>
													  
													</div>
													<div class="form-group">
														 <span id="divtxt_desc" style="color:red;"></span> 
													</div>
												</div>
												@endif
											<div class="col-md-12 col-sm-12 col-xs-12">
												<div class="form-group">
													<label class="control-label">Enter Amount</label>  
													<input id="txt_amount" name="txt_amount" type="text" class="form-control" required="required">
													<span id="divtxt_amount" style="color:red;"></span> 
												</div>
											</div>
											<div class="clearfix"></div>
											<div class="clearfix"></div>
											<div class="col-md-12 col-sm-12 col-xs-12">
												<div class="form-group">
													<button type="button" class="btn btn-success"  onClick="confirm_details_llbill('llbillForm')" {{$UserService == 'OFF'? 'disabled':''}}>RECHARGE NOW</button>
													<button type="reset" class="btn btn-primary">RESET</button>	
												</div>
											</div>
										</div>
									</form>
								</div>
								<script>
									function find_llbill()
									{
										var dd_brand =$('#dd_brand').val();
											var txt_account =$("input[name='txt_account']").val();
											var txt_number =$("input[name='txt_number']").val();
											$.ajax({	
												type:"POST",
												url:"{{ url('/fetch_bill')}}",
												dataType: 'json',
												data:{"dd_brand":dd_brand,"txt_account":txt_account,"txt_number":txt_number,_token:'{{csrf_token()}}'},
												beforeSend : function(){
													$('img.loader').show('fadein');
												},
												success:function(msg) 
												{
													console.log(msg.DESC);
													$('img.loader').hide('fadeout');
													if(msg.STATUS==1){
													$('#txt_amount').val(msg.BILL_AMOUNT);
													$('#divtxt_desc').html('<span> CUSTOMER NAME:- '+msg.NUMBER+'</br>  BILL DUE DATE:- '+msg.DUEDATE+'</br> BILLNO:- '+msg.BILLNO+'</span>');
													}
													else
													{
													$('#txt_amount').val('');
													$('#divtxt_desc').html(msg.DESC);
													}
												}
											});
									}

									function confirm_details_llbill(get_id)
										{
										
											var dd_brand =$('#dd_brand').val();
											var txt_account =$("input[name='txt_account']").val();
											var txt_number =$("input[name='txt_number']").val();
											var txt_amount=$('#txt_bijlibamount').val();
											bootbox.confirm('Are you sure to Pay Bill this Number -'+txt_number+' with amount of '+txt_amount+'.Please Confirm.', function(result){
												if(result==true)
												{
													alert("You pressed OK!");
													document.getElementById(get_id).submit();
												}
												else {
													alert("You pressed Cancel!");
												}
											});
										}
								</script>
							</div>

						</div>
					</div> 
                       
						
				</div>
			</div>
		</div>

        <div class="col-md-8">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>S.NO.</th>
								<th>TXN DATE</th>
								<th>MEMBERID/NAME</th>
								<th>CONSUMERNO</th>
								<th>OPERATOR</th>
								<th>STATUS</th>
								<th>TXN ID</th>
								<th>OP.BAL</th>
								<th>AMOUNT</th>
								<th>COMMI</th>
								<th>CL.BAL</th>
								<th>VIA</th>
								
							</tr>
						</thead>
						<tbody>
							@foreach( $rec_report as $con)
							<tr>
								<td>{{ '#' }}</td>
								<td>{{ $con->RequestDate }}</td>
								<td>{{ $con->MemberID }}/ {{ $con->MemberFirstName  }}</td>
								<td>{{ $con->Account }}</td>
								<td>{{ $con->ServiceProvider }}</td>
								<td>
									@if( $con->Status == 'SUCCESS') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
									@elseif( $con->Status == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
									@endif
								</td>
								<td>{{ $con->LiveId }}</td>
								
								<td>{{ $con->PreBal }}</td>
								<td>{{ $con->Amount }}</td>
								<td>{{ $con->Commision }}</td>
								<td>{{ $con->PostBal }}</td>
								<td>{{ $con->RequestType }}</td>
								
								
							</tr>
							@endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
</div>
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){

	$('#hide').hide();
	$('#account').hide();
	$('#dd_brand').change(function(){
		var value =	$('#dd_brand option:selected').val();
		//var value =	$('#dd_brand option:selected').val();
		var account =	$(this).find(':selected').data('account');
		var hint =	$(this).find(':selected').data('hint');
		if(value!="-1"){
			$('#hide').show();
			if(account=='1'){
				$('#account').show();
				$('#account_text').text("Enter "+hint);
			}
			else{
				$('#account').hide();
			}
		}
		else{
			$('#hide').hide();
		}
	});
	
});
</script>
@endsection