@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">LEVEL INCOME DETAILS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-3 col-lg-6">
            
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">GEN LEVEL INCOME DETAILS</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{ url('user_genlevel_bonus') }}" class="cmxform form-horizontal" id="signupForm" method="post" accept-charset="utf-8">
    									{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txt_from">From Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_from" id="txt_from" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>    
                                        </div>
                                    </div>    
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label" for="txtto">To Date</label>
                                            <div class="col-md-9">
                                                <div id="demo-dp-txtinput">
                                                    <input type="text" name="txt_to" id="txt_to" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                                </div>
                                            </div>    
                                        </div>
                                    </div> 
                                     <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="col-md-3 control-label">Select Level</label>
                                                    <div class="col-md-9">
                                                        <select name="dd_level" id="dd_level" class="form-control empty selectpicker" data-live-search="true" data-width="100%">
                                                              <option value="1" {{old('dd_level')=='1' ? 'selected' : ''}}>LEVEL 1</option>
                                                              <option value="2" {{old('dd_level')=='2' ? 'selected' : ''}}>LEVEL 2</option>
                                                              <option value="3" {{old('dd_level')=='3' ? 'selected' : ''}}>LEVEL 3</option>
                                                              <option value="4" {{old('dd_level')=='4' ? 'selected' : ''}}>LEVEL 4</option>
                                                              <option value="5" {{old('dd_level')=='5' ? 'selected' : ''}}>LEVEL 5</option>
                                                              <option value="6" {{old('dd_level')=='6' ? 'selected' : ''}}>LEVEL 6</option>
                                                              <option value="7" {{old('dd_level')=='7' ? 'selected' : ''}}>LEVEL 7</option>
                                                              <option value="8" {{old('dd_level')=='8' ? 'selected' : ''}}>LEVEL 8</option>
                                                              <option value="9" {{old('dd_level')=='9' ? 'selected' : ''}}>LEVEL 9</option>
                                                              <option value="10" {{old('dd_level')=='10' ? 'selected' : ''}}>LEVEL 10</option>
                                                              <option value="11" {{old('dd_level')=='11' ? 'selected' : ''}}>LEVEL 11</option>
                                                              <option value="12" {{old('dd_level')=='12' ? 'selected' : ''}}>LEVEL 12</option>
                                                              <option value="13" {{old('dd_level')=='13' ? 'selected' : ''}}>LEVEL 13</option>
                                                              <option value="14" {{old('dd_level')=='14' ? 'selected' : ''}}>LEVEL 14</option>
                                                              <option value="15" {{old('dd_level')=='15' ? 'selected' : ''}}>LEVEL 15</option>
                                                              <option value="16" {{old('dd_level')=='16' ? 'selected' : ''}}>LEVEL 16</option>
                                                              <option value="17" {{old('dd_level')=='17' ? 'selected' : ''}}>LEVEL 17</option>
                                                              <option value="18" {{old('dd_level')=='18' ? 'selected' : ''}}>LEVEL 18</option>
                                                              <option value="19" {{old('dd_level')=='19' ? 'selected' : ''}}>LEVEL 19</option>
                                                              <option value="20" {{old('dd_level')=='20' ? 'selected' : ''}}>LEVEL 20</option>

                                                        </select>
                                                     </div>
                                        </div>
                                   </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            </div>
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>SNO.</th>
                                <th>TRANSACTION DATE</th>
								<th class="min-tablet">DESCRIPTION</th>
								<th>LEVEL</th>
                                <th class="min-tablet">BY REFERRAL</th>
                                <th class="min-tablet">AMOUNT</th>
                                <th class="min-tablet">DEDUCTION</th>
								<th class="min-tablet">STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $sn = 1;?>
								@foreach( $direct_report as $con)
								<tr>
									<td>{{ $sn++ }}</td>
								    <td>{{ $con->DIRECT_ENTRYDATE}}</td>
									<td>{{ $con->DIRECT_DESCRIP}}</td>
									<td>{{ $con->DIRECT_LEVEL }}</td>
									<td>{{ $con->REFERRAL_CODE}}</td>
									<td>{{ $con->DIRECT_AMOUNT}}</td>
									<td>{{ $con->DIRECT_TDSCHARGE}}</td>
									<td><span class="label label-table label-success">{{ $con->DIRECT_ISPUBLISH }}</span></td>
								</tr>
								@endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection