@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Fund Request Detail</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">Fund Request Detail</h3>
                </div>

                <div class="collapse in">
    
                    <form action="{{ url('/user_fund_request_status') }}" method="POST">
					{{ csrf_field() }}
                        <div class="panel-body">

                            <div class="row">

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtfromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txtfromdate" id="txtfromdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>  
                                </div>                              
                            
                                <div class="col-sm-2">                        
                                    <div class="form-group">
                                        <label class="control-label" for="txttodate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txttodate" id="txttodate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtusername">Username</label>
                                        <input type="text" name="txtusername" id="txtusername" class="form-control" placeholder="Enter Username." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="ddpaymode">Status</label>
                                        <select class="form-control" id="ddpaymode">
                                            <option>Select</option>
                                        </select>  
                                    </div>
                                </div>

                                <div class="col-sm-2">                        
                                    <div class="form-group">
                                        <label class="control-label" for="txttodate">Deposit Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txtdepdate" id="txtdepdate" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off" >
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="ddpaymode">Payment Mode</label>
                                        <select class="form-control" id="ddpaymode">
                                            <option>Select</option>
                                        </select>  
                                    </div>
                                </div>

                            </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Show</button>
                        </div>
                    </form>
                </div>
    
            </div>

        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                       <thead>
                <tr>
                  <th >#</th>
                  <th>BANK NAME</th>
                  <th>PAYEE NAME</th>
                  <th>ACCOUNT NUMBER</th>
                  <th>WALLET TYPE</th>
                  <th>MODE</th>
                  <th>AMOUNT</th>
                  <th>UTR/BANK REFRENCE</th>
                  <th>STATUS</th>
                </tr>
              </thead>
              <tbody>
              <?php $sn =  1; ?>
			  @foreach( $fund_req_toadmin as $ba)
             <tr>
			 <td>{{$sn}}</td>
			 <td>{{$ba->BANK_NAME}}</td>
			 <td>{{$ba->FUNDREQ_PAYEE}}</td>
			 <td>{{$ba->FUNDREQ_ACCOUNTNO}}</td>
			 <td>{{$ba->FUNDREQ_TOWALLET}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_MODE)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_AMOUNT)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_UTRNO)}}</td>
			 <td>{{strtoupper($ba->FUNDREQ_STATUS)}}</td>
			 </tr>
			 <?php $sn =  $sn+1; ?>
			 @endforeach
              </tbody>
                    </table>
                </div>
            
            </div>
        </div>   
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

