@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Fund Request</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/') }}">Wallet</a></li>
			<li class="active">Fund Request</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
            <div class="col-md-4">
                <div class="panel">
                    <div class="panel-heading">
						@if(Session::has('message')) 
						<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
							<h4 class="alert-heading">{{ Session::get("message") }}</h4>
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						@endif
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
                        <h3 class="panel-title">Fund Request</h3>
					</div>
					<div class="collapse in">
						<form action="{{('user_fundrequestto_admin')}}" enctype="multipart/form-data" id="fund_request" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 		
							<div class="panel-body">	
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Select Balance For <span class="text-danger">*</span></label>
										<select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_wallet" id="dd_wallet" required="required">
											<option value="-1">Select Wallet</option>
											<option value="1">Main Wallet</option>
											<!--option value="2">DMR Wallet</option-->
										</select>
										<span id="divdd_wallet" class="text-danger"></span>
									</div>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Select Deposited Bank <span class="text-danger">*</span></label>
										<select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_depositedbank" id="dd_depositedbank" required="required">
											<option value="-1">Select Bank</option>
											@foreach( $bank_account as $ba)
											<option value="{{$ba->ADMINBANK_ID}}">{{strtoupper($ba->BANK_ACCOUNT)}}-[{{$ba->BANK_NAME}}]</option>
											@endforeach
										</select>
										<span id="divdd_depositedbank" class="text-danger"></span>
									</div>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Select Payment Method <span class="text-danger">*</span></label>
                                        <select class="selectpicker opt" data-live-search="true" data-width="100%" name="dd_paymentmethod" id="dd_paymentmethod" required="required">
                                            <option value="-1">Select Payment Method</option>
                                            <!--option value="1">BY SAME BANK FUND TRANSFER</option>
                                            <option value="2">BY NEFT / RTGS</option>
                                            <option value="3">BY ATM TRANSFER</option>
                                            <option value="4">BY CHEQUE</option>
                                            <option value="5">BY IMPS</option>
                                            <option value="6">BY UPI </option>
                                            <option value="7">BY CASH</option-->
											<option value="8">BY CRYPTO TRANSFER</option>
										</select>
										<span id="divdd_paymentmethod" class="text-danger"></span>
									</div>
								</div>
								
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Enter Amount <span class="text-danger">*</span></label>  
										<input id="txt_amount" name="txt_amount" type="number" class="form-control numeric" oninput="toWords(this.id)"  autocomplete="off" required="required"  onKeyPress="if(this.value.length==10) return false;" >
										<span id="divtxt_amount" class="text-danger"></span>
									</div>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Amount in words -:<span style="font-weight: bold;" id="txt_amount_in_word"></span></label>  
										<span id="divtxt_amount_in_word" class="text-danger"></span> 
									</div>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Enter UTR / Bank Reference <span class="text-danger">*</span></label>  
										<input id="txt_bankutrn" name="txt_bankutrn" type="text" class="form-control empty" required="required">
										<span id="divtxt_bankutrn" class="text-danger"></span> 
									</div>
								</div>
								<div class="col-md-12 col-sm-12 col-xs-12" >
									<div class="form-group">
										<label class="control-label">Enter Remarks/Description <span class="text-danger">*</span></label>  
										<input id="txt_description" name="txt_description" type="text" class="form-control empty" >
										<span id="divtxt_description" class="text-danger"></span> 
									</div>
								</div>
								
								<div class="clearfix"></div>
								<div class="clearfix"></div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="form-group">
										<button class="btn btn-success" type="button" onclick="conw_v('fund_request')">Submit</button>
										<button class="btn btn-info" type="reset">Reset</button>
									</div>
								</div>
								
							</div>
							
						</form>
						
					</div>
					
				</div>
			</div>
			
			
            <div class="col-md-8">
                <div class="row">
                    <div class="panel">
						
                        <div class="panel-heading">
                            <h3 class="panel-title">BANK ACCOUNT DETAILS</h3>
						</div>
						
                        <div class="panel-body">
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
									<tr>
										<th >#</th>
										<th>BANK NAME</th>
										<th>PAYEE NAME</th>
										<th>ACCOUNT NUMBER</th>
										<th>IFSCODE</th>
									</tr>
								</thead>
								<tbody>
									<?php $sn =  1; ?>
									@foreach( $bank_account as $ba)
									<tr>
										<td>{{$sn}}</td>
										<td>{{$ba->BANK_NAME}}</td>
										<td>{{$ba->NAME_AT_BANK}}</td>
										<td>{{strtoupper($ba->BANK_ACCOUNT)}}</td>
										<td>{{strtoupper($ba->BANK_IFSCODE)}}</td>
									</tr>
									<?php $sn =  $sn+1; ?>
									@endforeach
								</tbody>
							</table>
						</div>
						
					</div>
				</div>
				<!--div class="row">
                    <div class="panel">
						
                        <div class="panel-heading">
                            <h3 class="panel-title">FUND REQUEST TO ADMIN</h3>
						</div>
						
                        <div class="panel-body">
							@if($user[0]->BTC_ADDRESS=="")
							<form action="{{('generate_btcaddress')}}"  class="cmxform form-horizontal" id="signupForm" method="post" accept-charset="utf-8">
								{{ csrf_field() }} 
								<div class="clearfix"></div>
								<div class="clearfix"></div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="form-group">
										<button type="submit" class="btn btn-success">GET BTC ADDRESS</button>
									</div>
								</div>
							</form>
							@endif
							@if($user[0]->BTC_ADDRESS!="")
<b>BTC ADDRESS-:</b><span style="color:black"><b>{{$user[0]->BTC_ADDRESS}}</b></span>
							@endif
						</div>
					</div>
				</div>
				<div class="row">
                    <div class="panel">
						
                        <div class="panel-heading">
                            <h3 class="panel-title">FUND REQUEST TO ADMIN</h3>
						</div>
						
                        <div class="panel-body">
							@if($user[0]->ETH_ADDRESS=="")
							<form  action="{{('generate_ethaddress')}}" class="cmxform form-horizontal" id="signupForm" method="post" accept-charset="utf-8">
								{{ csrf_field() }} 
								<div class="clearfix"></div>
								<div class="clearfix"></div>
								<div class="col-md-12 col-sm-12 col-xs-12">
									<div class="form-group">
										<button type="submit" class="btn btn-success">GET ETH ADDRESS</button>
									</div>
								</div>
							</form>
							@endif
							@if($user[0]->ETH_ADDRESS!="")
							<b>ETH ADDRESS-:</b><span style="color:black"><b>{{$user[0]->ETH_ADDRESS}}</b></span>
							@endif
						</div>
					</div>
				</div-->
                <div class="row">
                    <div class="panel">
						
                        <div class="panel-heading">
                            <div class="col-md-6"><h3 class="panel-title">FUND REQIUEST TO ADMIN</h3></div>
<div class="col-md-6"><button class="btn btn-success pull-right" type="button" onclick="EXPORTTOEXCEL('fund-request');" style="margin-top: 9px;"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
						</div>
						
                        <div class="panel-body">
                            <table id="demo-dt-basic" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
									<tr>
										<th >#</th>
										<th>BANK NAME</th>
										<th>PAYEE NAME</th>
										<th>ACCOUNT NUMBER</th>
										<th>WALLET TYPE</th>
										<th>MODE</th>
										<th>AMOUNT</th>
										<th>UTR/BANK REFRENCE</th>
										<th>STATUS</th>
									</tr>
								</thead>
								<tbody>
									<?php $sn =  1; ?>
									@foreach( $fund_req_toadmin as $ba)
									<tr>
										<td>{{$sn}}</td>
										<td>{{$ba->BANK_NAME}}</td>
										<td>{{$ba->FUNDREQ_PAYEE}}</td>
										<td>{{$ba->FUNDREQ_ACCOUNTNO}}</td>
										<td>{{$ba->FUNDREQ_TOWALLET}}</td>
										<td>{{strtoupper($ba->FUNDREQ_MODE)}}</td>
										<td>{{strtoupper($ba->FUNDREQ_AMOUNT)}}</td>
										<td>{{strtoupper($ba->FUNDREQ_UTRNO)}}</td>
										<td>{{strtoupper($ba->FUNDREQ_STATUS)}}</td>
									</tr>
									<?php $sn =  $sn+1; ?>
									@endforeach
								</tbody>
							</table>
						</div>
						
					</div>
				</div>
			</div>
		</div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script type="text/javascript">
function toWords(id){
 var price = $('#'+id).val();
var word = price_in_words(price)
	$('#txt_amount_in_word').html(word);
	console.log(word);
}
    </script>
@endsection