@extends('mainlayout')
@section('content')
<style>

.scroll {
    height: 340px;
    overflow-y: auto;
    overflow-x: hidden;
}

/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

.swal-modal {
    width: 300px;
    opacity: 0;
    pointer-events: none;
    background-color: #fff;
    text-align: center;
    border-radius: 5px;
    position: static;
    margin: 20px auto;
    display: inline-block;
    vertical-align: middle;
    -webkit-transform: scale(1);
    transform: scale(1);
    -webkit-transform-origin: 50% 50%;
    transform-origin: 50% 50%;
    z-index: 10001;
    transition: opacity .2s,-webkit-transform .3s;
    transition: transform .3s,opacity .2s;
    transition: transform .3s,opacity .2s,-webkit-transform .3s;
}
.swal-button {
    background-color: #5cb95d;
    color: #fff;
    border: none;
    box-shadow: none;
    border-radius: 7px;
    font-weight: 600;
    font-size: 14px;
    padding: 3px 16px;
    margin: 0;
    cursor: pointer;
}
.swal-text {
    color: #f44336;
}
.swal-text:first-child {
    margin-top: 30px;
}

</style>
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Electricity Bill</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/') }}">Bill Pay</a></li>
			<li class="active">Electricity Bill</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
				@if($UserService == 'OFF')
                    <div class="alert alert-warning alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">Service Not Active</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
				@endif
			<div class="col-md-4">
	            <div class="panel">
  @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
	                <div class="panel-heading">
	                    <h3 class="panel-title">ELECTRICITY BILL PANEL</h3>
					</div>
	                <div class="panel-body">
	                    
		                <div class="" role="tabpanel" data-example-id="togglable-tabs">
							<div id="myTabContent" class="tab-content">
								<div role="tabpanel" class="tab-pane fade active in" id="tab_content5" aria-labelledby="profile-tab5">
									<div class="col-md-12 col-sm-12 col-xs-12">	
										<form action="{{ url('electricity') }}"  class="cmxform form-horizontal" id="bbbillForm" method="post" accept-charset="utf-8">
											{{ csrf_field() }}

											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Select Operator</label>
													<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_brand" id="dd_brand" required="required">
														<option value="-1">SELECT OPERATOR</option>
														@foreach($ELECTRICITY as $OPT)
														<option value="{{$OPT->BrandCode}}" data-account="{{$OPT->Account}}" data-hint="{{$OPT->AcDesc}}">{{strtoupper($OPT->BrandName)}}</option>
														@endforeach
													</select>
													<span id="divdd_brand" style="color:red;"></span>
												</div>
											</div>   
											<div id="hide">
												<!--div class="col-md-12 col-sm-12 col-xs-12" >
													<div class="form-group">
														<label class="control-label">Enter Customer Mobile Number</label>  
														<input id="txt_custmobile" name="txt_custmobile" type="text" class="form-control" required="required">
														<span id="divtxt_llcustmobile" style="color:red;"></span> 
													</div>
												</div-->
												<div class="col-md-12 col-sm-12 col-xs-12" >
													<div class="form-group">
														<label class="control-label">Enter Number</label>  
														<input id="txt_number" name="txt_number" type="text" class="form-control" required="required">
														<span id="divtxt_number" style="color:red;"></span> 
													</div>
												</div>
												<div class="col-md-12 col-sm-12 col-xs-12" id="account">
													<div class="form-group">
														<label class="control-label" id="account_text">Enter Account No</label>  
														<input id="txt_account" type="text" name="txt_account" class="form-control" required="required">
														<span id="divtxt_account" style="color:red;"></span> 
													</div>
												</div>
												@if($UserService == 'ON')
												<div class="col-md-12 col-sm-12 col-xs-12" >
													<div class="form-group">
														<a href="#!" onClick="find_bijlibill()"  data-target="#view-plans" data-toggle="modal" class="btn btn-primary">View Bill Amount</a>
													  
													</div>
													<div class="form-group">
														 <span id="divtxt_desc" style="color:red;"></span> 
													</div>
												</div>
													@endif
												<div class="col-md-12 col-sm-12 col-xs-12">
													<div class="form-group">
														<label class="control-label">Enter Amount</label>  
														<input id="txt_amount" name="txt_amount" type="number" class="form-control" autocomplete="off">
														<span id="divtxt_amount" style="color:red;"></span> 
													</div>
												</div>
												<div class="clearfix"></div>
												<div class="clearfix"></div>
												<div class="col-md-12 col-sm-12 col-xs-12">
													<div class="form-group">
														<button type="button" class="btn btn-success"  onclick=" confirm_details_bbbill('bbbillForm')" {{$UserService == 'OFF'? 'disabled':''}}>BILL PAY NOW</button>
														<button type="reset" class="btn btn-primary">RESET</button>	
													</div>
												</div>
											</div>
										</form>
									</div>
									<script>
										function find_bijlibill()
										{
											var dd_brand =$('#dd_brand').val();
											var txt_account =$("input[name='txt_account']").val();
											var txt_number =$("input[name='txt_number']").val();

											if( $('#account').is(':visible') && txt_account.length < 3 || $('#account').is(':visible') && txt_account.length > 25) 
											{ 
												$('#divtxt_account').html('<span>Enter Valid Account Number</span>');
											}
											else if(txt_number.length < 3  || txt_number.length > 25)
											{
												$('#divtxt_number').html('<span>Enter Valid Number</span>');
											}
											else if(dd_brand == -1)
											{
												$('#divdd_brand').html('<span>Select Operator !</span>');
											}
											else{
													$('#divtxt_number').html('');
													$('#divdd_brand').html('');
													$('#divtxt_account').html('');
											$.ajax({	
												type:"POST",
												url:"{{ url('/fetch_bill')}}",
												dataType: 'json',
												data:{"dd_brand":dd_brand,"txt_account":txt_account,"txt_number":txt_number,_token:'{{csrf_token()}}'},
												beforeSend : function(){
													$('img.loader').show('fadein');
												},
												success:function(msg) 
												{
													$('img.loader').hide('fadeout');
													if(msg.STATUS==1){
													$('#txt_amount').val(msg.BILL_AMOUNT);
													$('#divtxt_desc').html('<span> CUSTOMER NAME:- '+msg.NUMBER+'</br>  BILL DUE DATE:- '+msg.DUEDATE+'</br> BILLNO:- '+msg.BILLNO+'</span>');

														$("#plans").append("</tbody>");
															$('#last_trans').empty();
															$("#last_trans").append("<thead><tr><th>AMOUNT</th><th>LIVE ID</th><th>DATE</th><th>REPEAT </th></tr></thead><tbody>");
															$.each(msg['LAST5TRANSACTION'],function(key,value){
																$("#last_trans").append("<tr><td>"+msg['LAST5TRANSACTION'][key].Amount+"</td><td>"+msg['LAST5TRANSACTION'][key].LiveId+"</td><td>"+msg['LAST5TRANSACTION'][key].RequestDate3+"</td><td><button class='btn btn-success btn-xs' onclick='select_plan_amo("+msg['LAST5TRANSACTION'][key].Amount+")'>SELECT </button></td></tr>");
															});
														$("#last_trans").append("</tbody>");
													}
													else
													{
													$('#txt_amount').val('');
													$('#divtxt_desc').html(msg.DESC);

														$("#plans").append("</tbody>");
															$('#last_trans').empty();
															$("#last_trans").append("<thead><tr><th>AMOUNT</th><th>LIVE ID</th><th>DATE</th><th>REPEAT</th></tr></thead><tbody>");
															$.each(msg['LAST5TRANSACTION'],function(key,value){
																$("#last_trans").append("<tr><td>"+msg['LAST5TRANSACTION'][key].Amount+"</td><td>"+msg['LAST5TRANSACTION'][key].LiveId+"</td><td>"+msg['LAST5TRANSACTION'][key].RequestDate3+"</td><td><button class='btn btn-success btn-xs' onclick='select_plan_amo("+msg['LAST5TRANSACTION'][key].Amount+")'>SELECT </button></td></tr>");
															});
														$("#last_trans").append("</tbody>");
													}
												}
											}); }
										}
										function confirm_details_bbbill(get_id)
										{
										
											var dd_brand =$('#dd_brand').val();
											var txt_account =$("input[name='txt_account']").val();
											var txt_number =$("input[name='txt_number']").val();
											var txt_amount=$('#txt_amount').val();

											if( $('#account').is(':visible') && txt_account.length < 3 || $('#account').is(':visible') && txt_account.length > 25) 
											{ 
												$('#divtxt_account').html('<span>Enter Valid Account Number</span>');
											}
											else if(txt_number.length < 3  || txt_number.length > 25)
											{
												$('#divtxt_number').html('<span>Enter Valid Number</span>');
											}
											else if(dd_brand == -1)
											{
												$('#divdd_brand').html('<span>Select Operator !</span>');
											}
											else if(txt_amount < 4)
											{	
												$('#divtxt_number').html('');
												$('#divtxt_account').html('');
												swal({
												  text: "Must be a amount greater than 4 !",
												});
											}
											else{
													$('#divtxt_number').html('');
													$('#divdd_brand').html('');
													$('#divtxt_account').html('');

											bootbox.confirm('Are you sure to Pay Bill this Number -'+txt_number+' with amount of '+txt_amount+'.Please Confirm.', function(result){
												if(result==true)
												{
													alert("You pressed OK!");
													document.getElementById(get_id).submit();
												}
												else {
													alert("You pressed Cancel!");
												}
											});}
										}
									</script>
								</div>			
								
							</div>
						</div> 
	                       
							
					</div>
				</div>
			</div>
        <div class="col-md-8">
            <div class="panel">
            
                <div class="panel-body">
                    <table class="table table-striped table-bordered" id="last_trans" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>AMOUNT</th>
								<th>	LIVE ID</th>
								<th>SELECT</th>
							</tr>
						</thead>
						<tbody>
							

						</tbody>
                    </table>
                </div>
            </div>
        </div>
	        <div class="col-md-12">
	            <div class="panel">
	            
	                <div class="panel-body">
	                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
	                        <thead>
								<tr>
									<th>S.NO.</th>
									<th>TXN DATE</th>
									<th>MEMBERID/NAME</th>
									<th>CONSUMERNO</th>
									<th>OPERATOR</th>
									<th>STATUS</th>
									<th>TXN ID</th>
									<th>OP.BAL</th>
									<th>AMOUNT</th>
									<th>COMMI</th>
									<th>CL.BAL</th>
									<th>VIA</th>
									
								</tr>
							</thead>
							<tbody>
								@foreach( $rec_report as $con)
								<tr>
									<td>{{ '#' }}</td>
									<td>{{ $con->RequestDate }}</td>
									<td>{{ $con->MemberID }}/ {{ $con->MemberFirstName  }}</td>
									<td>{{ $con->Account }}</td>
									<td>{{ $con->ServiceProvider }}</td>
									<td>
										@if( $con->Status == 'SUCCESS') 
										<button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
										@elseif( $con->Status == 'PENDING') 
										<button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
										@else
										<button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
										@endif
									</td>
									<td>{{ $con->LiveId }}</td>
									
									<td>{{ $con->PreBal }}</td>
									<td>{{ $con->Amount }}</td>
									<td>{{ $con->Commision }}</td>
									<td>{{ $con->PostBal }}</td>
									<td>{{ $con->RequestType }}</td>
								</tr>
								@endforeach
							</tbody>
	                    </table>
	                </div>
	            
	            </div>
	        </div>
		
		</div>
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){

	$('#hide').hide();
	$('#account').hide();
	$('#dd_brand').change(function(){
		var value =	$('#dd_brand option:selected').val();
		//var value =	$('#dd_brand option:selected').val();
		var account =	$(this).find(':selected').data('account');
		var hint =	$(this).find(':selected').data('hint');
		if(value!="-1"){
			$('#hide').show();
			if(account=='1'){
				$('#account').show();
				$('#account_text').text("Enter "+hint);
			}
			else{
				$('#account').hide();
			}
		}
		else{
			$('#hide').hide();
		}
	});
	
});

 function select_plan_amo(prs) {
 $('#txt_amount').empty();
 $('#txt_amount').val(prs);
}
</script>
@endsection