@extends('mainlayout')
@section('content')
<style>

.scroll {
    height: 340px;
    overflow-y: auto;
    overflow-x: hidden;
}

/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

.swal-modal {
    width: 300px;
    opacity: 0;
    pointer-events: none;
    background-color: #fff;
    text-align: center;
    border-radius: 5px;
    position: static;
    margin: 20px auto;
    display: inline-block;
    vertical-align: middle;
    -webkit-transform: scale(1);
    transform: scale(1);
    -webkit-transform-origin: 50% 50%;
    transform-origin: 50% 50%;
    z-index: 10001;
    transition: opacity .2s,-webkit-transform .3s;
    transition: transform .3s,opacity .2s;
    transition: transform .3s,opacity .2s,-webkit-transform .3s;
}
.swal-button {
    background-color: #5cb95d;
    color: #fff;
    border: none;
    box-shadow: none;
    border-radius: 7px;
    font-weight: 600;
    font-size: 14px;
    padding: 3px 16px;
    margin: 0;
    cursor: pointer;
}
.swal-text {
    color: #f44336;
}
.swal-text:first-child {
    margin-top: 30px;
}

</style>
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Dth Recharge</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('/') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('/') }}">Recharge</a></li>
			<li class="active">Dth Recharge</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
				@if($UserService == 'OFF')
                    <div class="alert alert-warning alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">Service Not Active</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
				@endif
			<div class="col-md-4">
            <div class="panel">
                @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                <div class="panel-heading">
                    <h3 class="panel-title">DTH PANEL</h3>
				</div>
                <div class="panel-body">
                    
                      <div class="" role="tabpanel" data-example-id="togglable-tabs">
							<!-- <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">

								<li role="presentation" class="active"><a href="#tab_content2" role="tab" id="profile-tab2" data-toggle="tab" aria-expanded="false"><span><img src="{{ asset($folder.'/images/icon/dth.png')}}" style="width:20px;"></span> DTH</a></li>
							</ul> -->
							<div id="myTabContent" class="tab-content">

								<div role="tabpanel" class="tab-pane fade active in" id="tab_content2" aria-labelledby="profile-tab2">
									<div class="col-md-12 col-sm-12 col-xs-12">	
										<form action="{{url('dthrecharge')}}" class="cmxform form-horizontal" id="dthForm" method="post" accept-charset="utf-8"  autocomplete="off">
											{{ csrf_field() }}
											
											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Enter Card No</label>  
													<input id="txt_cardno" name="txt_cardno" type="text"  class="form-control">
													<span id="divtxt_cardno" style="color:red;"></span> 
												</div>
											</div>
											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Select Operator</label>
													<select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_dthbrand" id="dd_dthbrand" onchange="get_dthplan_and_last_rech(this.id)" required="required">
														<option value="-1">SELECT OPERATOR</option>
														@foreach($DTH as $OPT)
														<option value="{{$OPT->TelecomBrandId}}">{{strtoupper($OPT->BrandName)}}</option>
														@endforeach
													</select>
													<span id="divdd_brand" style="color:red;"></span>
												</div>
											</div>   
											@if($UserService == 'ON')
											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<a href="#!" onclick="get_dthplan_and_last_rech('dd_dthbrand')" style="width: 100%;" class="view-plans-link btn btn-xs btn-success">View Plans</a>
												</div>
												<div class="form-group" id="pbutn" style="display:none">
													<button type="button" class="btn" style="width: 100%; font-size: 13px;" ><span id="plans"> </span></button>
												</div>
											</div>
											@endif
											<div class="col-md-12 col-sm-12 col-xs-12" >
												<div class="form-group">
													<label class="control-label">Enter Amount</label>  
													<input id="txt_dthamount" name="txt_dthamount" type="number"  class="form-control" required="required">
													<span id="divtxt_amount" style="color:red;"></span> 
												</div>
											</div>
											<div class="clearfix"></div>
											<div class="clearfix"></div>
											<div class="col-md-12 col-sm-12 col-xs-12">
												<div class="form-group">
													<button type="button" class="btn btn-success" onclick=" confirm_details_dth('dthForm')" {{$UserService == 'OFF'? 'disabled':''}}>RECHARGE NOW</button>
													<button type="reset" class="btn btn-primary">RESET</button>	
												</div>
											</div>
										</form>
									</div>
									<script>
										function confirm_details_dth(get_id) {
											var txt;
											var operator=$('#dd_dthbrand').val();
											var txt_cardno=$('#txt_cardno').val();
											var txt_amount=$('#txt_dthamount').val();
											var pattern=/^[0-9]+$/;
											var result =false;
											if(txt_cardno.length < 4  || txt_cardno.length > 15)
											{
													$('#divtxt_cardno').html('<span>Enter Valid Card Number</span>');
											}
											else if(operator == -1)
											{
												$('#divdd_brand').html('<span>Select Operator !</span>');
											}
											else if(txt_amount < 4)
											{	$('#divtxt_cardno').html('');
												swal({
												  text: "Must be a amount greater than 4 !",
												});
											}
											else{
													$('#divtxt_cardno').html('');
													$('#divdd_brand').html('');

											bootbox.confirm('Are you sure to Recharge this DTH -'+txt_cardno+' with amount of '+txt_amount+'.Please Confirm.', function(result){
												if(result==true)
												{
													alert("You pressed OK!");
													document.getElementById(get_id).submit();
												}
												else {
													alert("You pressed Cancel!");
												}
											});
											}
										}
									</script>
								</div>
								
							</div>
						</div> 
                       
						
				</div>
			</div>
		</div>
        <div class="col-md-8">
            <div class="panel">
            
                <div class="panel-body">
                    <table class="table table-striped table-bordered" id="last_trans" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>CONSUMERNO</th>
								<th>AMOUNT</th>
								<th>SELECT PLAN</th>
							</tr>
						</thead>
						<tbody>
							

						</tbody>
                    </table>
                </div>
            </div>
        </div>
		


        <div class="col-md-12">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>CONSUMERNO</th>
								<th>OPERATOR</th>
								<th>STATUS</th>
								<th>AMOUNT</th>
								<th>TXN ID</th>
								<th>TXN DATE</th>
							</tr>
						</thead>
						<tbody>
							@foreach( $rec_report as $con)
							<tr>
								
								<td>{{ $con->Account }}</td>
								<td><img src="{{ asset('images/brand_image/'.$con->ServiceProviderIMAGE) }}" style="width:50px;height:50px;"></td>
								<td>
									@if( $con->Status == 'SUCCESS') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
									@elseif( $con->Status == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
									@endif
								</td>
								<td>{{ $con->Amount }}</td>
								<td>{{ $con->LiveId }}</td>
								<td>{{ $con->RequestDate }}</td>
								
							</tr>
							@endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
    <!--===================================================-->
    <!--End page content-->
		</div>
</div>

</div>

<!--===================================================-->
<!--END CONTENT CONTAINER-->
 <script>
 function get_dthplan_and_last_rech(id) {
        var opcode = $("#"+id).val();
		var number = $("#txt_cardno").val();
		if(opcode == -1)
		{
				$('#divdd_brand').html('<span>Select Operator  !</span>');
				$('#pbutn').hide();
                $("#plans").html('');
		}
        else if(number)
        {
					$('#divdd_brand').html('');
					$('#divtxt_cardno').html('');
            $.ajax({
               type:"POST",
               url:"{{ url('/get_dth_roffer')}}",
               data:{"_token": "{{ csrf_token() }}", "cardnumber":number , "opt":opcode },
               success:function(result)
               {   
                    if(result == 'DATA NOT FOUND')
                    {
                        alert(result);
                    }
                    else
                    {
						$('#dd_brand').val(result['brand_id']);
                        $('#plans').empty();
						if(result['ERROR'] == 'success')
						{
							$('#pbutn').show();
                            $("#plans").html("<span>Customer Name : "+result['DTHINFO'][0].customerName+" </br> Monthly Recharge: "+result['DTHINFO'][0].MonthlyRecharge+" </br> Next Recharge Date: "+result['DTHINFO'][0].NextRechargeDate+" </br> Last Recharge Amount: "+result['DTHINFO'][0].lastrechargeamount+" </br> Last Recharge Date: "+result['DTHINFO'][0].lastrechargedate+"</span>");
							
								$('#last_trans').empty();
								$("#last_trans").append("<thead><tr><th>AMOUNT</th><th>LIVE ID</th><th>DATE</th><th>REPEAT PLAN</th></tr></thead><tbody>");
								$.each(result['LAST5TRANSACTION'],function(key,value){
									$("#last_trans").append("<tr><td>"+result['LAST5TRANSACTION'][key].Amount+"</td><td>"+result['LAST5TRANSACTION'][key].LiveId+"</td><td>"+result['LAST5TRANSACTION'][key].RequestDate3+"</td><td><button class='btn btn-success btn-xs' onclick='select_plan_amo("+result['LAST5TRANSACTION'][key].Amount+")'>SELECT </button></td></tr>");
								});
							$("#last_trans").append("</tbody>");
						}
						if(result['ERROR'] == 'error')
						{		$('#pbutn').show();
								$("#plans").html("<span>"+result['MSG']+ "</span>");
						}
				
                        $('.selectpicker').selectpicker('refresh');
                    }    
               }

            });
        }
		else{  		
					$('#pbutn').hide();
					$("#plans").html('');		
					$('#divtxt_cardno').html('<span>Enter Valid Card Number</span>');
				}
        }

 function select_plan_amo(prs) {
 $('#txt_dthamount').empty();
 $('#txt_dthamount').val(prs);
}
 </script>
@endsection