@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Customer Registration</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
			<div class="col-lg-offset-3 col-lg-6">
				
                <div class="panel">

                	@if(Session::has('message')) 
					<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
						<h4 class="alert-heading">{{ Session::get("message") }}</h4>
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>
					@endif
				 @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    <div class="panel-heading">
						
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
						</div>
                        <h3 class="panel-title">Customer Registration</h3>
					</div>
                    <div class="collapse in">
                        <form action="{{ url('user_dmtregisterairtel_express') }}" enctype="multipart/form-data"  id="signupForm" method="post" accept-charset="utf-8">
							{{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_mobileno">Customer Mobile Number <span class="text-danger">* </span></label>
                                            <input type="number" id="txt_mobileno" name="txt_mobileno" class="form-control empty" placeholder="Customer Mobile Number" value="{{ Session::get('MOBILENO') }}" required>
                                            <span class="text-danger" id="divtxt_mobileno"></span>
										</div>
									</div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_firstname">Customer First Name <span class="text-danger">* </span></label>
                                            <input type="text" class="form-control aplha_only" placeholder="Customer First Name" name="txt_firstname" id="txt_firstname" required>
											<span class="text-danger" id="divtxt_firstname"></span>
										</div>
									</div>
									<div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_lastname">Customer Last Name <span class="text-danger">* </span></label>
                                            <input type="text" class="form-control aplha_only" placeholder="Customer Last Name" name="txt_lastname" id="txt_lastname" required>
											<span class="text-danger" id="divtxt_lastname"></span>
										</div>
									</div>
									<div class="col-sm-6">    
										<div class="form-group">
											<label class="control-label" for="txt_memberdob">Date Of Birth</label>
											<div id="demo-dp-txtinput">
												<input name="txt_memberdob" id="txt_memberdob" type="text" class="form-control" date-format="mm-dd-yyyy" placeholder="dd/mm/yyyy" autocomplete="off" required>
											</div>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_address">Address</label>
											<textarea class="form-control" name="txt_address" id="txt_address" rows="5" style="height:;" required></textarea>
										</div>
									</div>

									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_pincode">Pin Code</label>
											<input type="number" class="form-control pincode" placeholder="Pin Code" name="txt_pincode" id="txt_pincode" required>
											<span class="text-danger" id="divtxt_pincode"></span>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_pincode">State</label>
											<select class="selectpicker" id="dd_state" name="dd_state" data-live-search="true" data-width="100%">
					                                <option value="">Select State</option>
													<option value="35">Andaman Nicobar</option>
					                                <option value="28">Andhra Pradesh</option>
					                                <option value="12">Arunachal Pradesh</option>
					                                <option value="18">Assam</option>
					                                <option value="10">Bihar</option>
					                                <option value="04">Chandigarh</option>
					                                <option value="22">Chhattisgarh</option>
					                                <option value="26">Dadra Nagar Haveli</option>
					                                <option value="25">Daman Diu</option>
					                                <option value="07">Delhi</option>
					                                <option value="30">Goa</option>
					                                <option value="24">Gujarat</option>
					                                <option value="06">Haryana</option>
					                                <option value="02">Himachal Pradesh</option>
					                                <option value="01">Jammu Kashmir</option>
					                                <option value="20">Jharkhand</option>
					                                <option value="29">Karnataka</option>
					                                <option value="32">Kerala</option>
					                                <option value="31">Lakshadweep</option>
					                                <option value="23">Madhya Pradesh</option>
					                                <option value="27">Maharashtra</option>
					                                <option value="14">Manipur</option>
					                                <option value="17">Meghalaya</option>
					                                <option value="15">Mizoram</option>
					                                <option value="13">Nagaland</option>
					                                <option value="21">Odisha</option>
					                                <option value="34">Puducherry</option>
					                                <option value="03">Punjab</option>
					                                <option value="08">Rajasthan</option>
					                                <option value="11">Sikkim</option>
					                                <option value="33">Tamil Nadu</option>
					                                <option value="36">Telangana</option>
					                                <option value="16">Tripura</option>
					                                <option value="09">Uttar Pradesh</option>
					                                <option value="05">Uttarakhand</option>
					                                <option value="19">West Bengal</option>
					                            </select>
											<span class="text-danger" id="divdd_state"></span>
										</div>
									</div>
								</div>  
								<div class="col-sm-6">
										<div class="form-group">
											<label class="control-label" for="txt_pincode">OTP</label>
											<input type="number" class="form-control pincode" placeholder="Pin Code" name="txt_pin" id="txt_pin" required>
											<span class="text-danger" id="divtxt_pin"></span>
										</div>
									</div>
							</div>
                            <div class="panel-footer text-center">
                                <button id="regbtn" class="btn btn-success" type="button" onclick="dmt_regist('signupForm')">Submit</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
    <!--===================================================-->
    <!--End page content-->
</div>
<script>
	function dmt_regist(get_id)
	{
		var mobileno = $('#txt_mobileno').val();
		var firstname = $('#txt_firstname').val();
		var lastname = $('#txt_lastname').val();
		var pincode = $('#txt_pincode').val();
		var state = $('#dd_state').selectpicker().val();
		var pin = $('#txt_pin').val();
		var pattern=/^[a-zA-Z. ]*$/;
		if(mobileno == '')
		{
			$("#txt_mobileno").focus();
			$("#divtxt_mobileno").html("This Feild is Required.");
		}
		else if(mobileno.length != 10)
		{
			$("#txt_mobileno").focus();
			$("#divtxt_mobileno").html("Mobile Phone must be 10 Digit !. ");
		}
		else if(firstname == '')
		{
			$("#txt_firstname").focus();
			$("#divtxt_firstname").html("This Feild is Required.");
		}
		else if(lastname == '')
		{
			$("#txt_lastname").focus();
			$("#divtxt_lastname").html("This Feild is Required.");
		}
		else if(!firstname.match(pattern))
		{
			$("#txt_firstname").focus();
			$("#divtxt_firstname").html("*Only alpha characters and space allowed !. ");
		}
		else if(!lastname.match(pattern))
		{
			$("#txt_lastname").focus();
			$("#divtxt_lastname").html("*Only alpha characters and space allowed !. ");
		}		
		else if(pincode == '')
		{
			$("#txt_pincode").focus();
			$("#divtxt_pincode").html("This Feild is Required.");
		}
		else if(pincode != '' && pincode.length != 6)
		{
			$("#txt_pincode").focus();
			$("#divtxt_pincode").html("OTP Code must be 6 Digit !. ");
		}
		else if(pin == '')
		{
			$("#txt_pin").focus();
			$("#divtxt_pin").html("This Feild is Required.");
		}
		else if(pin != '' && pin.length != 6)
		{
			$("#txt_pin").focus();
			$("#divtxt_pin").html("OTP Code must be 6 Digit !. ");
		}
		else if($("#txt_memberdob").val() == '')
		{
			$("#txt_memberdob").focus();
			$("#divtxt_memberdob").html("This Feild is Required.");
		}
		else if($("#txt_address").val() == '')
		{
			$("#txt_address").focus();
			$("#divtxt_address").html("This Feild is Required.");
		}
		else if(state == '')
		{
			$("#dd_state").focus();
			$("#divdd_state").html("This Feild is Required.");
		}
		else
		{
			$("#divtxt_mobileno").html('');
			$("#divtxt_firstname").html('');
			$("#divtxt_lastname").html('');
			$("#divtxt_pincode").html('');
			$("#divtxt_pin").html('');
			$("#divdd_state").html('');
			document.getElementById('signupForm').submit();
				$("#resend").hide();
			  setTimeout(function() {
					$("#resend").show();
				  }, 20000);
			
		}
	}

function send_otp()
{
		var mobileno = $('#txt_mobileno').val();
		var user_phone = {{Session()->get('CONTACTNO')}};
            $.ajax({
               type:"POST",
               url:"{{ url('/send_dmt_otp')}}",
               data:{"_token": "{{ csrf_token() }}", "mobileno":mobileno , "user_phone":user_phone },
               success:function(result)
               {
					if(result !='error')
					{
						$("#txt_otp").focus();
						$("#divtxt_otp").html("");
						$("#divstxt_otp").html(result);
						$("#resend").hide();
						  setTimeout(function() {
								$("#resend").show();
							  }, 20000);
					}
				}
			});
}


function otp_verify()
{
		var otp = $('#txt_otp').val();
            $.ajax({
               type:"POST",
               url:"{{ url('/verification_dmt_otp')}}",
               data:{"_token": "{{ csrf_token() }}", "otp":otp },
               success:function(result)
               {  
					if(result == 'success')
					{
						$("#divtxt_otp").html("");
						$("#divstxt_otp").html("OTP match successfully.");
						document.getElementById('signupForm').submit();
					}
					if(result == 'error')
					{
						$("#divtxt_otp").html("");
						$("#divtxt_otp").html("OTP does not match.");
					}
			   }
			});
}
$(document).ready(function() {
  setTimeout(function() {
    $("#resend").show();
  }, 20000);
});
</script>
<!--===================================================-->
<!-- Modal -->
  <!-- Modal -->
  <div class="modal fade" id="exampleModalLong" data-backdrop="static" role="dialog">
    <div class="modal-dialog modal-sm">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">DMT Registration Verification</h4>
        </div>
        <div class="modal-body">
                            <div class="panel-body">
                                <div class="row">
										<div class="form-group">
										<div class="col-sm-2" style="margin-top: -9px;">
											<label class="control-label" for="txt_otp" style="font-size: 14px;">OTP</label>
										 </div>
											<div class="col-sm-10">
											<input type="number" class="form-control pincode" placeholder="Pin Code" name="txt_otp" id="txt_otp" required>
											<span class="text-danger" style="font-size: 12px;" id="divtxt_otp"></span>
											<span class="text-success" style="font-size: 12px;" id="divstxt_otp"></span>
										</div>
									</div>
								</div>  
							</div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-warning" id="resend" style="display: none;" onclick="send_otp()">Resend OTP</button>
		<button type="button" class="btn btn-success"  onclick="otp_verify()">Save</button>
		<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

<!--END CONTENT CONTAINER-->
@endsection