@extends('mainlayout')
@section('content')
<style>
.error {
    border-color: red;
}
.dropdown-menu.open {
    width: 100%;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
			<li><a href="{{url('/'.Session::get("dash_url"))}}">Dashboard</a></li>
			<li class="active">Customer Registration</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
	</div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

				@if(Session::has('addbene_message')) 
                    <div class="alert alert-{{ Session::get('addbene_type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("addbene_message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
    	@if($get_useralldetail != '' && $dmt_user!= '')
        <div class="col-sm-3">
            <div class="panel widget">
                <div class="widget-header bg-warning text-center">
                    <h4 class="text-light mar-no pad-top">{{ $dmt_user['custfirstname']}} {{ $dmt_user['custlastname']}}</h4>
                    <p class="mar-btm text-light">RETAILER</p>
                </div>
                <div class="widget-body" style="padding:72px 15px;">
                    <img src="{{asset('/images/user.png')}}" alt="WELCOME" title="" class="widget-img img-circle img-border-light">                 
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td class="border-top-none"><i class="fa fa-birthday-cake" aria-hidden="true"></i>&nbsp;&nbsp; {{$dmt_user['dob']}} </td>
                            </tr>
                            <tr>
                                <td><i class="fa fa-phone-square" aria-hidden="true"></i>&nbsp;&nbsp; {{$dmt_user['custmobile']}}</td>
                            </tr>
                            <tr>
                                <td><i class="fa fa-bar-chart" aria-hidden="true"></i>&nbsp; Limit&nbsp; {{$dmt_user['total_limit']-$dmt_user['used_limit']}}</td>
                            </tr>
                            <tr>
                                <td><i class="fa fa-address-card" aria-hidden="true"></i>&nbsp;&nbsp;  {{$dmt_user['address']}} {{$dmt_user['pincode']}}</td>
                            </tr>
								<tr>
                                <td><b><a href="{{ url('user_dmtairtel_dashboard') }}" style="color:#000000"><i class="fa fa-list" aria-hidden="true"></i>&nbsp;&nbsp; BENEFICIARY LIST</a></b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

              <div class="col-lg-9">
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax" data-target="#panel-collapse-d1ab" data-toggle="collapse" aria-expanded="true"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">DMT DASHBOARD</h3>
                   
                </div>
            
                <!-- Foo Table - Filtering -->
                <!--===================================================-->
                <div class="collapse in" id="panel-collapse-d1ab">
                           
                                <div class="panel-body">
                                    <div class="row">
					<form action="{{ url('add_dmtairtelbeneficiary') }}" enctype="multipart/form-data" id="signupForm" method="post" accept-charset="utf-8">
                                {{ csrf_field() }} 
                                        <input id="txt_userid" name="txt_userid" type="hidden" class="form-control" required="required" value="{{$dmt_user['custmobile']}}">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="txt_nameatbank">Beneficiary Name</label>
                                                <input type="text" id="txt_nameatbank" name="txt_nameatbank" class="form-control empty" placeholder="Beneficiary Name"  required="">
												<span class="text-danger" id="divtxt_nameatbank"></span> 
                                            </div>
                                        </div>    
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="txt_benemobileno">Beneficiary Mobile Number</label>
                                                <input type="text" class="form-control empty" placeholder="Beneficiary Mobile Number" name="txt_benemobileno" id="txt_benemobileno" required="">
												<span class="text-danger" id="divtxt_benemobileno"></span> 
											</div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="dd_bank">Bank Name</label>
                                                <select class="selectpicker opt" name="dd_bank" id="dd_bank" onchange="get_ifscode()"  data-live-search="true" data-width="100%">
                                                    @foreach($banks as $b)
                                                    <option value="{{$b['bankid']}}">{{$b['bankname']}}</option>
                                                    @endforeach
                                                </select>
												<span class="text-danger" id="divdd_bank"></span> 
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="txt_bankifsccode">IFSC Code</label>
                                                <input type="text" id="txt_bankifsccode" name="txt_bankifsccode" class="form-control empty" placeholder="Enter IFSC Code." onchange="ifscValidate();" required="">
												<span class="text-danger" id="divtxt_bankifsccode"></span> 
											</div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="txt_cbsacno">Account Number</label>
                                                <input type="text" id="txt_cbsacno" name="txt_cbsacno" class="form-control empty" placeholder="Enter Account Number." required="">
												<span class="text-danger" id="divtxt_cbsacno"></span> 
											</div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label class="control-label" for="txt_cbsacno_re">Re-enter Account Number</label>
                                                <input type="text" id="txt_cbsacno_re" name="txt_cbsacno_re" class="form-control empty" placeholder="Re-enter Account Number." required="">
												<span class="text-danger" id="divtxt_cbsacno_re"></span> 
                                            </div>
                                        </div>
                                    </div>  
                                    
                                </div>
                                <div class="panel-footer text-center">
									<span class="text-danger" id="errorshow"></span>
								<button class="btn btn-danger" type="button" onclick="account_validate('signupForm')">Validate Account</button>
                                    <button id="bene1" class="btn btn-success" type="submit">Submit</button>
                                    <button id="bene" class="btn btn-success" type="reset">Reset</button>
                                </div>
                            </form>
                        </div>
                    </div>
            </div>
			
		@endif
	</div>

          <div class="modal fade" id="transfer-beneficiary-modal" role="dialog" tabindex="-1" aria-labelledby="demo-default-modal" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <!--Modal header-->
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><i class="pci-cross pci-circle"></i></button>
                            <h4 class="modal-title text-danger" id="bavs">Beneficiary Account Validate</h4>
                        </div>
                        <!--Modal body-->
                        <div>
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <input id="txt_beneid" name="txt_beneid" type="hidden" class="form-control" required="required">
                                    <input id="txt_contactno" name="txt_contactno" type="hidden" class="form-control" required="required">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_nameatbank">Beneficiary Name</label>
                                            <input type="text" id="txt_name" name="txt_name" class="form-control empty" placeholder="Beneficiary Name" value="" readonly>
                                        </div>
                                    </div>    
                                </div>  
                            </div>
                        </div>

                        <!--Modal footer-->
                        <div class="modal-footer">
                            <button data-dismiss="modal" class="btn btn-default" type="reset">Close</button>
                            <button class="btn btn-primary" type="button"  onclick="autofill()">OK</button>
                        </div>
                    </div>
                </div>
                </div>
    <!--===================================================-->
    <!--End page content-->
</div>
<!--===================================================-->
<script>
function autofill()
{
		var name = $('#txt_name').val();
	   $('#txt_nameatbank').val(name);
		$('#transfer-beneficiary-modal').modal('hide');
}

function account_validate(get_id)
    {
	var txt_userid = $('#txt_userid').val();
	var txt_nameatbank = $('#txt_nameatbank').val();
	var txt_benemobileno = $('#txt_benemobileno').val();
	var dd_bank = $('#dd_bank').val();
	var txt_bankifsccode = $('#txt_bankifsccode').val();
	var txt_cbsacno = $('#txt_cbsacno').val();
	if(check(get_id))
	{
		if($('#txt_cbsacno').val() == $('#txt_cbsacno_re').val()){
			$('#divtxt_cbsacno_re').html("");
         $.ajax({    
                type:"POST",
                url:"{{ url('account_validate_bc')}}",
                data:{"txt_userid":txt_userid,"txt_nameatbank":txt_nameatbank,"txt_benemobileno":txt_benemobileno,"dd_bank":dd_bank,"txt_cbsacno":txt_cbsacno,"txt_bankifsccode":txt_bankifsccode, _token: '{{csrf_token()}}'},
                beforeSend : function(){
                    $('img.loader').show('fadein');
                },
                success:function(msg) 
                {
					if(msg['CODE'] == 'warning')
					{	
						$('#errorshow').html(msg['MSG']);
					}
					else
					{
						if(msg['Data'][0]['messagetext'] == 'Success')
						{
							$('#bavs').html("Beneficiary Account Validate successfully");
						}
						else
						{
							$('#bavs').html(msg['Data'][0]['messagetext']);
						}
						
						$('#txt_name').val(msg['Data'][0]['benename']); 
						$('#transfer-beneficiary-modal').modal('show');
					}
                }
            });}
			else
			{
				$('#divtxt_cbsacno_re').html("Account Number Re-enter Account Number not same");
				return true;
			}
	}
	else
	{
		return false;
	}
    } 

</script>
<!--END CONTENT CONTAINER-->
@endsection