@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Fund Wallet Ledger</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            
                <div class="panel">
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Fund Wallet Ledger</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{ url('/user_creditstatement') }}" method="POST">
						{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div> 

                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID/NAME</th>
								<th>TRANSACTIONID</th>
								<th>TRANSACTIONDATE</th>
								<th>DESCRIPTION</th>
								<th>CR.AMOUNT</th>
								<th>DR.AMOUNT</th>
								<th>BALANCEFOR</th>
								<th>MAINBAL</th>
								<th>PAYOUTBAL</th>			
								<th>REWARDBAL</th>			
							</tr>
						</thead>
						<tbody>
							@foreach( $ledger_report as $con)
							 <tr>
							 <td >{{'#'}}</td >
            <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
			<td>{{$con->Transactionid}}</td>
			<td>{{$con->TransactionDate}}</td>
			<td>{{$con->Description}}</td>
			<td>{{$con->AmountCredited}}</td>
			<td>{{$con->AmountDedited}}</td>
			<td>{{$con->BalanceType}}</td>
			<td>{{$con->CurrentBalance}}</td>
			<td>{{$con->UtilityBalance}}</td>
			<td>{{$con->RemittanceBalance}}</td>
			</tr>
			 @endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection
