@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Update Configuration</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Settings</a></li>
        <li class="active">Update Configuration</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="col-lg-12">
        
        
                <!-- FORM VALIDATION ON TABS -->
                <!--===================================================-->
                <div class="tab-base">
                    
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#demo-bsc-tab-1" data-toggle="tab">General Settings</a></li>
                        <li><a href="#demo-bsc-tab-2" data-toggle="tab">Site Logo</a></li>
                        <li><a href="#demo-bsc-tab-3" data-toggle="tab">Site Background Image</a></li>
                    </ul>

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
        
                    <!-- Tabs Content -->
                        <div class="tab-content">
                            <div class="tab-pane fade in active" id="demo-bsc-tab-1">
                                <p class="text-main text-bold">HOME</p>
                                <hr>

                                @if($singleconfig != "")
                                <form id="userconfig" action="{{url('/user_update_settings/'.$singleconfig[0]->m00_id)}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Variable</label>
                                                <input type="text" class="form-control" name="txt_name" id="txt_name" value="{{$singleconfig[0]->m00_name}}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Value</label>
                                                <input type="text" class="form-control" name="txt_value" id="txt_value" value="{{$singleconfig[0]->m00_value}}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Description</label>
                                                <input type="text" class="form-control" name="txt_desc" id="txt_desc" value="{{$singleconfig[0]->m00_desc}}">
                                            </div>
                                        </div> 

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('userconfig')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>
                                @else
                                <form id="sitelogo" action="{{url('/user_affiliate_sitelogo')}}" method="POST">
                                    {{ csrf_field() }}
                                    <div class="row">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Variable</label>
                                                <input type="text" class="form-control" name="txt_name" id="txt_name" placeholder="Enter Config Variable">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Value</label>
                                                <input type="text" class="form-control" name="txt_value" id="txt_value" placeholder="Enter Config Value">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Config Description</label>
                                                <input type="text" class="form-control" name="txt_desc" id="txt_desc" placeholder="Enter Config Description">
                                            </div>
                                        </div> 

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('sitelogo')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>
                                @endif
                            </div>
                            <div class="tab-pane fade" id="demo-bsc-tab-2">
                                <p class="text-main text-bold">Logo</p>
                                <hr>


                                <form id="update_sitelogo" action="{{url('/user_affiliate_updatesitelogo/SITE_LOGO')}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input name="txt_site_logo" type="hidden" value="txt_site_logo">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Site Logo Name</label>
                                                <input type="text" class="form-control" name="txt_logo_name" id="txt_logo_name" value="SITE_LOGO" readonly>
                                            </div>
                                        </div>    
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Upload Logo Image</label>
                                                <input type="file" class="form-control" name="txt_value" id="txt_value">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('update_sitelogo')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>  
 
                            </div>
                            <div class="tab-pane fade" id="demo-bsc-tab-3">
                                <p class="text-main text-bold">Background Image</p>
                                <hr>

                                <form id="update_bgimage" action="{{url('/user_affiliate_updatesitelogo/SITE_BG_IMAGE')}}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <input name="txt_site_bg" type="hidden" value="site_bg">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Site Background Name</label>
                                                <input type="text" id="txtbank" class="form-control input-inline input-medium" value="SITE_BG_IMAGE" name="m00_name">
                                            </div>
                                        </div>

                                        <?php 
                                            $bg_image ="";
                                            $btn_color ="";
                                            $btn_bg ="";
                                            $bg_image = Helper::get_configwl_ImageByName('SITE_BG_IMAGE');
                                            $btn_color = Helper::get_configwl_ImageByName('SITE_BTN_COLOR');
                                            $btn_bg = Helper::get_configwl_ImageByName('SITE_BTN_BG');
                                        ?>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Upload Background Image</label>
                                                <input type="file" class="form-control" name="txt_value" id="txt_value">
                                                <input type="hidden" name="txt_bg_image" id="txt_bg_image" value="{{ $bg_image->m00_value }}">
                                            </div>
                                        </div>

                                        <!--div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Button Font Color</label>
                                                <input type="text" name="txt_btn_color" id="txt_btn_color" value="{{ $btn_color->m00_value }}" class="form-control" />
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">Menu Background Color</label>
                                                <input type="text" name="txt_btn_bg" id="txt_btn_bg" value="{{ $btn_bg->m00_value }}" class="form-control" />
                                            </div>
                                        </div-->

                                    </div>

                                    <div class="tab-footer clearfix">
                                        <button type="button" class="btn btn-primary" onclick="conwv('update_bgimage')">Update Configuration</button>
                                        <button type="reset" class="btn btn-primary">Reset</button>
                                    </div>

                                </form>
                               
                            </div>
                        </div>
                </div>
                <!--===================================================-->
                <!-- END FORM VALIDATION ON TABS -->
        
            </div>
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Config Variable</th>
                                <th>Config Value</th> 
                                <th>Config Description</th>
                                <th>Edit</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $sn=1; ?>
                        @foreach( $config as $con )
                        <tr>
                            <td>{{$sn++}}</td>
                            <td><a>{{ $con->m00_name}}</a></td>
                            <td class="project_progress">{{ $con->m00_value }}</td> 
                            <td> {{ $con->m00_desc }}</td>
                            <td>
                                <a href="{{ url('user_manage_settings/'. $con->m00_id)}}" class="btn btn-success btn-xs">EDIT</a>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
    $(".val").on("click", function(e) {
        var id = $(this).data('id');
        var packname = $(this).data('packname');
        $('#txt_statusregid').val(id);
        $('#packname').text(packname);
    });
});
</script>
@endsection
