@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">BillPay Reports</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">BillPay Reports</a></li>
            <li class="active">BillPay Reports</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">BillPay Report Filter Here
     @if( count($today_hit) != 0)

            @foreach( $today_hit as $rec_hit)

            @endforeach

         <b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITSUCCESS}}]- &#8377 {{$rec_hit->SUCCESS}}</span></b>

        <b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITFAILED}}]- &#8377 {{$rec_hit->FAILED}}</b></span>

        <b><span class="btn btn-warning btn-xs">[{{$rec_hit->TOTAL_HITPENDING}}]- &#8377 {{$rec_hit->PENDING}}</b></span>

        <b><span class="btn btn-info btn-xs"> [{{$rec_hit->TOTAL_HITREFUND}}]- &#8377 {{$rec_hit->REFUND}}</b></span>

        <b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITREFUNDED}}]- &#8377 {{$rec_hit->REFUNDED}}</b></span>

        <b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITREJECT}}]- &#8377 {{$rec_hit->REJECT}}</b></span> 

@endif</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/user_bill_payreport')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account"  value="{{$txt_account}}" class="form-control" placeholder="Enter Consumer No." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" value="{{$txt_memberids}}"   placeholder="Enter Member Id."  autocomplete="off">
                                        <ul class="list-group costom-list" id="member_name"> </ul>  
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid"  value="{{$txt_transid}}"  class="form-control" placeholder="Enter Transaction Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_status == -1? 'selected':''}}>Select Status</option>
                                          <option value="1"  {{$dd_status == 1? 'selected':''}}>SUCCESS</option>
                                            <option value="2"  {{$dd_status == 2? 'selected':''}}>PENDING</option>
                                            <option value="3"  {{$dd_status == 3? 'selected':''}}>COMPLAINT</option>
                                            <option value="4"  {{$dd_status == 4? 'selected':''}}>FAILED</option>
                                            <option value="5"  {{$dd_status == 5? 'selected':''}}>REJECT</option>
                                            <option VALUE="6"  {{$dd_status == 6? 'selected':''}}>REFUNDED</option>
                                            <option VALUE="7"  {{$dd_status == 7? 'selected':''}}>RE-SUCCESS</option>
                                            <option VALUE="8"  {{$dd_status == 8? 'selected':''}}>RE-FAILED</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_api == -1? 'selected':''}}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}" {{$dd_api == $api->API_ID? 'selected':''}}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" value="{{$txt_noofrecords}}" class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                                 <button class="btn btn-primary" type="reset" >Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            

                <div class="panel-body">
                <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('RECHARGE_REPORT');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>TXN_DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>STATUS</th>
                                <th>TXN_ID</th>
                                <th>OP.BAL</th>
                                <th>AMOUNT</th>
                                <th>COMMI</th>
                                <th>CL.BAL</th>
                                <th>VIA</th>
                                <th>ACTION</th>
                                <th>RECEIPT</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $rec_report as $con)
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->RegCode }}/ {{ $con->MemberFirstName  }}</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
                                <td>
                                    @if( $con->Status == 'SUCCESS') 
                                    <button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
                                    @elseif( $con->Status == 'PENDING') 
                                    <button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
                                    @else
                                    <button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
                                    @endif
                                </td>
                                <td>{{ $con->LiveId }}</td>
                                <td>{{ $con->PreBal }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->Commision }}</td>
                                <td>{{ $con->PostBal }}</td>
                                <td>{{ $con->RequestType }}</td>
                              
                                @if( $con->Status == 'SUCCESS')
                                <td>
                                    <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
                                    data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}" data-recopertid="{{$con->LiveId}}"
                                    data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
                                    data-target="#failed_refunded_modal" title="ACTION" onClick="show_rechdetails1(this)">ACTION</button></td>
                                @else
                                <td></td>
                                @endif
                               
                        @if( $con->Status == 'SUCCESS')
                        <td><a class="btn btn-warning btn-xs" href="{{url('billpay_receipt/'.$con->Transactionid)}}" target="_blank">PRINT RECEIPT</a></td>
                        @else
                                <td></td>
                                @endif
                                               </tr>
                       @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- /page content -->
@endsection