@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Manage Token</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Settings</a></li>
            <li class="active">Manage Token</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
        <div class="row">

            <div class="col-md-4">

                @if(Session::has('message')) 

                <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">

                    <h4 class="alert-heading">{{ Session::get("message") }}</h4>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                        <span aria-hidden="true">&times;</span>

                    </button>

                </div>

                @endif
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">View User Api Token</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('generate_apitoken')}}" id="genet" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">SERVER IP</label>  
                                        <input id="txt_serverip" name="txt_serverip" type="text" minlength="7" maxlength="15" placeholder="xxx.xxx.xxx.xx" class="form-control" required="required" 
                                        value="{{$user[0]->IPAddress}}">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">DOMAIN NAME</label>  
                                        <input id="txt_weburl" name="txt_weburl" placeholder="demo.com" type="text" class="form-control" required="required" 
                                        value="{{$user[0]->DOAMINName}}">
                                    </div>
                                    <div class="panel-footer text-center">
                                        <button type="submit" class="btn btn-success">GENERATE TOKEN</button>
                                        <button type="reset" class="btn btn-primary">RESET</button> 
                                    </div>
                                </div>
                            </div>

                        </form>
                        
                    </div>
        
                </div>

                <div class="panel">

                    @if(Session::has('message_ip')) 

                    <div class="alert alert-{{ Session::get('type_ip') }} alert-dismissible  show" role="alert">

                        <h4 class="alert-heading">{{ Session::get("message_ip") }}</h4>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                            <span aria-hidden="true">&times;</span>

                        </button>

                    </div>

                    @endif       
        
                </div>

                <div class="panel">
                    
                    @if(Session::has('message_cb')) 

                    <div class="alert alert-{{ Session::get('type_cb') }} alert-dismissible  show" role="alert">

                        <h4 class="alert-heading">{{ Session::get("message_cb") }}</h4>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                            <span aria-hidden="true">&times;</span>

                        </button>

                    </div>

                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Callback URL</h3>
                    </div>
                    <div class="collapse in">
                        <form action="{{url('update_callbackurl')}}" id="call_backurl" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">Callback URL</label>  
                                        <input id="txt_callbackurl" name="txt_callbackurl" type="text" class="form-control" required="required" 
                                        value="{{$user[0]->CallbackURL}}">
                                        <span id="divtxt_mobileno" style="color:red;"></span> 
                                    </div>

                                    <div class="panel-footer text-center">
                                        <button type="submit" class="btn btn-success">UPDATE CALLBACK URL</button>
                                        <button type="reset" class="btn btn-primary">RESET</button> 
                                    </div>
                                </div>
                            </div>    
                        </form>
                        
                    </div>
        
                </div>

                <div class="panel">
                                        @if(Session::has('message_dcb')) 

                    <div class="alert alert-{{ Session::get('type_dcb') }} alert-dismissible  show" role="alert">

                        <h4 class="alert-heading">{{ Session::get("message_dcb") }}</h4>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                            <span aria-hidden="true">&times;</span>

                        </button>

                    </div>

                    @endif
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">DMR Callback URL</h3>
                    </div>
                    <div class="collapse in">
                        <form action="{{url('update_dmrcallbackurl')}}" id="call_backurl" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">Callback URL</label>  
                                        <input id="txt_dmrcallbackurl" name="txt_dmrcallbackurl" type="text" class="form-control" required="required" 
                                        value="{{$user[0]->DmrCallbackURL}}">
                                        <span id="divtxt_mobileno" style="color:red;"></span> 
                                    </div>
                                    <div class="panel-footer text-center">
                                        <button type="submit" class="btn btn-success">UPDATE CALLBACK URL</button>
                                        <button type="reset" class="btn btn-primary">RESET</button> 
                                    </div>
                                </div>
                            </div>    
                        </form>
                        
                    </div>
        
                </div>

                <div class="panel">
                                                            @if(Session::has('message_acb')) 

                    <div class="alert alert-{{ Session::get('type_acb') }} alert-dismissible  show" role="alert">

                        <h4 class="alert-heading">{{ Session::get("message_acb") }}</h4>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                            <span aria-hidden="true">&times;</span>

                        </button>

                    </div>

                    @endif
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">AEPS Callback URL</h3>
                    </div>

                    <div class="collapse in">


                        <form action="{{url('update_aepscallbackurl')}}" id="call_backurl" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">Callback URL</label>  
                                        <input id="txt_aepscallbackurl" name="txt_aepscallbackurl" type="text" class="form-control" required="required" 
                                        value="{{$user[0]->AepsCallbackURL}}">
                                        <span id="divtxt_mobileno" style="color:red;"></span> 
                                    </div>

                                    <div class="panel-footer text-center">
                                        <button type="submit" class="btn btn-success">UPDATE CALLBACK URL</button>
                                        <button type="reset" class="btn btn-primary">RESET</button> 
                                    </div>
                                </div>
                            </div>    
                        </form>
                        
                    </div>
        
                </div>

                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">AEPS Check Status URL</h3>
                    </div>

                    <div class="collapse in">


                        <form action="{{url('update_aepsstatuscallbackurl')}}" id="call_backurl" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="form-group">
                                        <label class="control-label">Callback URL</label>  
                                        <input id="txt_status_check" name="txt_status_check" type="text" class="form-control" required="required" 
                                        value="{{$user[0]->AepsStatusCheck}}">
                                        <span id="divtxt_mobileno" style="color:red;"></span> 
                                    </div>

                                    <div class="panel-footer text-center">
                                        <button type="submit" class="btn btn-success">UPDATE CALLBACK URL</button>
                                        <button type="reset" class="btn btn-primary">RESET</button> 
                                    </div>
                                </div>
                            </div>    
                        </form>
                        
                    </div>
        
                </div>

            </div>
            

            <div class="col-md-8">

                <div class="row">
                    <div class="panel">
                            
                        <div class="panel-heading">
                            <div class="panel-control">
                                <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                            </div>
                            <h3 class="panel-title">VIEW USER API TOKEN</h3>
                        </div>

                        <div class="collapse in">
                            <div class="panel-body">
                                <div class="row">
                                    API TOKEN - {{$user[0]->MemberApiToken}}
                                </div>
                            </div>
                            
                        </div>
            
                    </div>

                    <div class="panel">
                            
                        <div class="panel-heading">
                            <div class="panel-control">
                                <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                            </div>
                            <h3 class="panel-title">VIEW USER SERVER IP</h3>
                        </div>

                        <div class="collapse in">
                            <div class="panel-body">
                                <div class="row">
                                    SERVER IP - {{$user[0]->IPAddress}}
                                </div>
                            </div>    
                            
                        </div>
            
                    </div>

                    <div class="panel">
                            
                        <div class="panel-heading">
                            <div class="panel-control">
                                <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                            </div>
                            <h3 class="panel-title">VIEW USER CALLBACK URL</h3>
                        </div>

                        <div class="collapse in">
                            <div class="panel-body">
                                <div class="row">
                                    CALLBACK URL - {{$user[0]->CallbackURL}}
                                    <pre>SAME FOR RECHARGE AND BILL PAYMENT - status,mobile,amount,agentid,opid,tid,bal</pre>
                                    <br>
                                    <pre>status - 'SUCCESS', 'PENDING', 'FAILED', mobile - RECHARGE ACCOUNT NO, amount - RECHARGE AMOUNT</pre>
                                    <br>
                                    <pre>agentid - 'YOUR ID', opid - 'OPERATOR ID' PROVIDE BY OPERATOR, tid - 'OUR TID'</pre>
                                </div>
                            </div>    
                            
                        </div>
            
                    </div>

                    <div class="panel">
                            
                        <div class="panel-heading">
                            <div class="panel-control">
                                <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                            </div> 
                            <h3 class="panel-title">API DOCUMENTS & BASE URL</h3>
                        </div>

                        <div class="collapse in">
                            <div class="panel-body">
                                <div class="row">
                                    BASE URL - <pre>{{config('WEBSITE_NAME')}}</pre>
                                    </br>
                                    <p>API Documents-<a href="{{ asset('API_DOCS/NEWAPI_DOCX.pdf')}}" target="_blank">CLICK HERE</a></p>
                                    <pre>Sample Code for BILL AND MONEY TRANSFER API in Php-</br>
                                        $token='YOUR_TOKEN'; 
                                        $url="{{config('WEBSITE_NAME')}}"; 
                                        $url=$url."api/v1/apibill_check";
                                        $data=json_encode(array(
                                             'customer_number'=>'CUSTOMER MOBILE NO',
                                             'account'=>'ACCOUNT',
                                             'number'=>'NUMBER',
                                             'opt'=>OPERTOR_CODE,
                                             'amount'=>'10'
                                             ));
                                        $result=postdata($url,$data); 
                                        function postdata($url,$data) 
                                        { 
                                            $header_data=array(
                                                        "Content-Type:application/json",
                                                        "Authorization:".$token."");
                                                 $method="POST";
                                                if($method=="POST")
                                                {
                                                    $curl = curl_init();
                                                        curl_setopt_array($curl, array
                                                        (
                                                        CURLOPT_URL => $url,
                                                        CURLOPT_RETURNTRANSFER => true,
                                                        CURLOPT_ENCODING => "",
                                                        CURLOPT_MAXREDIRS => 10,
                                                        CURLOPT_TIMEOUT => 30,
                                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                                        CURLOPT_CUSTOMREQUEST => "POST",
                                                        CURLOPT_POSTFIELDS =>$data,
                                                        CURLOPT_HTTPHEADER =>$header_data
                                                        ));
                                                    $result = curl_exec($curl);
                                                    if(!$result)
                                                    {
                                                        $result=trigger_error(curl_error($curl));
                                                        curl_close($curl);
                                                        print_r($result);
                                                    }
                                                    else
                                                    {                   
                                                        curl_close($curl);
                                                            print_r($result);
                                                    }
                                                }
                                        } 
                                    </pre>
                                </div>
                            </div>
                        </div>
            
                    </div>
                </div>

            </div>
        </div>    

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO</th>
                                <th>SERVICE</th>
                                <th>OPERATOR_NAME</th>
                                <th>OPERATOR_CODE</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach( $operator_code as $con)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$con->ServiceName}} </td>
                                <td>{{$con->BrandName}} </td>
                                <td>{{$con->BrandCode}} </td>
                            </tr>
                            @endforeach

                        </tbody>

                        </table>
{{ $operator_code->links() }}
                </div>
            
            </div>
        </div> 
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script>
$('#demo-dt-selection').dataTable({
    "bPaginate": false
});
$('#demo-dt-selection').dataTable({
    "paging": false
});
</script>
@endsection