@extends('mainlayout')
@section('content')
<style>

.scroll {
    height: 340px;
    overflow-y: auto;
    overflow-x: hidden;
}

/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

.swal-modal {
    width: 300px;
    opacity: 0;
    pointer-events: none;
    background-color: #fff;
    text-align: center;
    border-radius: 5px;
    position: static;
    margin: 20px auto;
    display: inline-block;
    vertical-align: middle;
    -webkit-transform: scale(1);
    transform: scale(1);
    -webkit-transform-origin: 50% 50%;
    transform-origin: 50% 50%;
    z-index: 10001;
    transition: opacity .2s,-webkit-transform .3s;
    transition: transform .3s,opacity .2s;
    transition: transform .3s,opacity .2s,-webkit-transform .3s;
}
.swal-button {
    background-color: #5cb95d;
    color: #fff;
    border: none;
    box-shadow: none;
    border-radius: 7px;
    font-weight: 600;
    font-size: 14px;
    padding: 3px 16px;
    margin: 0;
    cursor: pointer;
}
.swal-text {
    color: #f44336;
}
.swal-text:first-child {
    margin-top: 30px;
}

.btn-primary, .btn-primary:focus {
    background-color: rgb(255 255 255);
    border: 1px solid #f44336 !important;
    color: #f44336;
}

.bootbox-body {
    text-align: center;
    font-size: 19px;
}
</style>
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
   
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">AEPS SETTELMENT REQUEST</h1>
		</div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
		
		
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
			<li><a href="{{ url('#') }}"><i class="fa fa-home"></i></a></li>
			<li><a href="{{ url('#') }}">AEPS</a></li>
			<li class="active">AEPS SETTELMENT REQUEST</li>
		</ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
		
	</div>
	
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
			 <div class="col-md-4">
            <div class="panel">
                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("message") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                <div class="panel-heading">
                    <h3 class="panel-title">AEPS SETTELMENT REQUEST</h3>
				</div>
                <div class="panel-body">
                    
                  	<div class="" role="tabpanel" data-example-id="togglable-tabs">
						<!-- <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
							<li role="presentation" class="active"><a href="#tab_content1" id="home-tab" role="tab" data-toggle="tab" aria-expanded="true"><span><img src="{{ asset($folder.'/images/icon/mobile.png')}}" style="width:20px;"></span> Mobile</a></li>
						</ul> -->
						<div id="myTabContent" class="tab-content">
							<div role="tabpanel" class="tab-pane fade active in" id="tab_content1" aria-labelledby="home-tab">
								<div class="col-md-12 col-sm-12 col-xs-12">	
									<form action="{{ url('aeps_settelment_report') }}"  class="cmxform form-horizontal" id="prepaidForm" method="post" accept-charset="utf-8"  autocomplete="off">
										{{ csrf_field() }}

										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Aeps Wallet</label>  
												<input type="number" id="txt_aeps_wallet" name="txt_aeps_wallet" class="form-control" required="required" value="{{$user[0]->REMIT_BAL}}" readonly>
												<span id="divtxt_aeps_wallet" style="color:red;"></span> 
											</div>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<p>
												<input type="radio" class="flat" name="baltypeto" id="bal_type1" value="2" /> MAIN
												<input type="radio" class="flat" name="baltypeto" id="bal_type2" value="3" checked="" /> DMR
												<input type="radio" class="flat" name="baltypeto" id="bal_type3" value="1" checked="" /> Move To Bank
												</p>
												<span id="divbal_type" style="color:red;"></span>
											</div>
										</div>

										<div class="col-md-12 col-sm-12 col-xs-12" >
											<div class="form-group">
												<label class="control-label">Enter Amount</label>  
												<input type="number" id="txt_amount" name="txt_amount" class="form-control empty" required="required" >
												<span id="divtxt_amount" style="color:red;"></span> 
											</div>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="form-group">
												<button type="button" class="btn btn-success" onclick=" conw_v('prepaidForm')" >Submit</button>
												<button type="reset" class="btn btn-danger">RESET</button>	
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div> 
				</div>
			</div>
		</div>

        <div class="col-md-8">
            <div class="panel">
            
                <div class="panel-body">
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
							<tr>
							     <th>S.NO</th>
								<th>AMOUNT</th>
								<th>MODE</th>
								<th>ADMIN REP</th>
								<th>STATUS</th>
								<th>TXN DATE</th>
							</tr>
						</thead>
						<tbody>
							@foreach($data as $key => $value)
							<tr>
							     <td>{{$key+1}}</td>
								<td>{{$value->FUNDREQ_AMOUNT}}</td>
								<td>{{$value->FUNDREQ_MODE}}</td>
								<td>{{$value->FUNDREQ_ADMINRES}}</td>
								<td>{{$value->FUNDREQ_STATUS}}</td>
								<td>{{$value->FUNDREQ_CREATEDAT}}</td>
							</tr>
							@endforeach
						</tbody>
                    </table>
                </div>
            
            </div>
        </div>
		
	</div>
    <!--===================================================-->
    <!--End page content-->
	
</div>
</div>
<!--===================================================-->

@endsection