@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<style>
@media only screen and (min-width:768px){
.absolute{position:absolute;}}
@media only screen and (max-width:768px){
.absolute{width: 100%;
    margin-bottom: 10px;}}
    
</style>
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Submit Query Here</li>
        </ol>
		
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

                    @if(session('success'))
                  <div class="alert alert-success">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-smile-o fa-2" aria-hidden="true"> </i><strong> {{ session('success') }}</strong>
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <strong> {{ session('error') }}</strong>
                    </div>
                @endif
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		 <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ticket Reply Filter</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('/filter-ticket-reply')}}" method="POST">
							{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2 col-md-offset-1">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket No</label>
                                            <input type="text" id="txt_ticket" name="txt_ticket" class="form-control input-inline input-medium" placeholder="Enter Ticket  No." >
										@if(count($tickets) > 0) <input type="hidden" id="txt_status" name="txt_status" value="{{$tickets[0]->STATUS}}"> @endif                                        
										</div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket Type</label>
                                            <select name="dd_ticket" id="dd_ticket"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">SUPPORT</option>
										<option value="2">ACCOUNT</option>
										<option value="3">SALES</option>
									</select>
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Urgency</label>
                                            <select name="dd_urgency" id="dd_urgency"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">HIGH</option>
										<option value="3">LOW</option>
										<option value="2">MEDIUM</option>
									</select>
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>
        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
					 
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<a class="btn btn-primary absolute" href="{{url('user_submit_query')}}">Create New Ticket </a>
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Ticket No.</th>
                                <th class="min-tablet">Ticket Type </th>
								<th class="min-tablet">Urgency</th>
                                <th class="min-tablet">Full Name</th>
                                <th class="min-tablet">Title</th>
                                <th class="min-tablet">Status</th>
                                <th class="min-tablet">Created Date</th>
                            </tr>
                        </thead>
                        <tbody>
							@php $sn=0; @endphp
                            @foreach($tickets as $tr)
                            <tr>
                                <td>{{++$sn}}</td> 
								<td><a class="btn-link" href="{{url('user_ticket_reply/'.$tr->TICKET_ID)}}"> {{$tr->TICKET_NO}} </a></td>
                                <td>{{$tr->TICKET_FOR}}</td>
                                <td>{{$tr->URGENCY}}</td>
                                <td>{{$user[0]->MemberName}}<br><b> {{$user[0]->RegCode}}</b></td>
                                <td>{{$tr->SUBJECT}}</td>
                                <td>{{$tr->STATUS}}</td>
								<td>{{$tr->CREATED_AT}}</td>
                            </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
  

</div>

<!--END CONTENT CONTAINER-->
@endsection