@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Refund Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Refund Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Refund Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="refund-report" action="{{url('/user_refundereport')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" value="{{$end}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" value="{{$txt_account}}" class="form-control" placeholder="Enter Consumer No." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member ID</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" value="{{$txt_memberids}}"  class="form-control input-inline input-medium" placeholder="Enter Member ID." >
                                    </div>
                                </div> 

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_status == -1? 'selected':''}}>Select Status</option>
                                            <option value="3"  {{$dd_status == 3? 'selected':''}}>COMPLAINT PENDING</option>
                                            <option value="5"  {{$dd_status == 5? 'selected':''}}>REJECT</option>
                                            <option VALUE="6"  {{$dd_status == 6? 'selected':''}}>REFUNDED</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator ==  $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" value="{{$txt_noofrecords}}" class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('user-wise');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID</th>
								<th>ACCOUNT </th>
								<th>LIVE ID</th>	
								<th>REASON</th>	
                                <th>RECHARGE DATE</th> 
                                <th>REQUEST DATE</th> 
                                <th>STATUS</th> 
                              
							</tr>
						</thead>
						<tbody>
							@foreach( $refund_report as $key => $con)
                            <tr>
                                <td>{{ $key +1}}</td>
								<td>{{ $con->RegCode }}-</br>[{{ $con->MemberFirstName}} {{ $con->MemberLastName}}]</td>
                                
								<td>{{ $con->ACCOUNT }}</br>[{{ $con->AMOUNT }}]</br>[{{ $con->OPERATORNAME }}]</td>
                            
                                
                                <td>{{ $con->OPERATORID }}</td>
								<td>{{ $con->DESCRIPTION }}</td>
								<td>{{ $con->RECHARGEDATE }}</td>
								<td>{{ $con->REFUNDREQUESTDATE }}</td>
								<td>
									@if( $con->REFUNDSTATUS == 'REFUND') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@elseif( $con->REFUNDSTATUS == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@endif
									</td>
</tr>
 @endforeach
						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection