@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Recharge Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
            <li class="active">Recharge Panel</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                          <h3 class="panel-title">Recharge Report Filter Here
	 @if( count($today_hit) != 0)
		@foreach( $today_hit as $rec_hit)
		@endforeach
        <b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITSUCCESS}}]- &#8377 {{$rec_hit->SUCCESS}}</span></b>
		<b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITFAILED}}]- &#8377 {{$rec_hit->FAILED}}</b></span>
		<b><span class="btn btn-warning btn-xs">[{{$rec_hit->TOTAL_HITPENDING}}]- &#8377 {{$rec_hit->PENDING}}</b></span>
		<b><span class="btn btn-info btn-xs"> [{{$rec_hit->TOTAL_HITREFUND}}]- &#8377 {{$rec_hit->REFUND}}</b></span>
		<b><span class="btn btn-danger btn-xs"> [{{$rec_hit->TOTAL_HITREFUNDED}}]- &#8377 {{$rec_hit->REFUNDED}}</b></span>
		<b><span class="btn btn-success btn-xs">[{{$rec_hit->TOTAL_HITREJECT}}]- &#8377 {{$rec_hit->REJECT}}</b></span> 
	@endif</h3>
                    </div>

                    <div class="collapse out">
                        <form action="{{url('/user_rechargereport')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_fromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_todate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_account">Consumer No</label>
                                            <input type="text" id="txt_account" name="txt_account"  value="{{$txt_account}}" class="form-control input-inline input-medium" placeholder="Enter Consumer No." >
                                        </div>
                                    </div> 
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_transid">Trnx ID</label>
                                            <input type="text" id="txt_transid" name="txt_transid" value="{{$txt_transid}}" class="form-control input-inline input-medium" placeholder="Enter User ID." >
                                        </div>
                                    </div>  
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select name="dd_status" id="dd_status"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
                                        <option value="-1"  {{$dd_status == -1? 'selected':''}}>Select Status</option>
                                        <option value="1" {{$dd_status == 1? 'selected':''}}>SUCCESS</option>
                                        <option value="2" {{$dd_status == 2? 'selected':''}}>PENDING</option>
                                        <option value="3" {{$dd_status == 3? 'selected':''}}>COMPLAINT PENDING</option>
                                        <option value="4" {{$dd_status == 4? 'selected':''}}>FAILED</option>
                                        <option value="5" {{$dd_status == 5? 'selected':''}}>REJECT</option>
                                        <option value="6" {{$dd_status == 6? 'selected':''}}>REFUNDED</option>
                                    </select>
                                        </div>
                                    </div> 

                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label">Operator</label>
                                            <select name="dd_operator" id="dd_operator" class="form-control  selectpicker" data-live-search="true" data-width="100%">
                                                <option value="-1"  {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                                @foreach($OPERATOR as $op)
                                                <option value="{{ $op->TelecomBrandId }}" {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                               <button class="btn btn-success" type="submit">Search</button>
								 <button class="btn btn-primary" type="reset" >Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('RECHARGE_REPORT');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
               
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>TXN DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>STATUS</th>
                                <th>TXN ID</th>
                                <th>OP.BAL</th>
                                <th>AMOUNT</th>
                                <th>COMMI</th>
                                <th>CL.BAL</th>
                                <th>VIA</th>
                                <th>ACTION</th>
								<th>PRINT RECEIPT</th>
                            </tr>
                        </thead>
                        <tbody>

                            @php 
                            $PreBal = 0.00; 
                            $Amount = 0.00; 
                            $Commision = 0.00; 
                            $PostBal = 0.00; 
                            $RequestType = 0.00; 
                            @endphp

                            @foreach( $rec_report as $con)
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->RegCode }}/ {{ $con->MemberFirstName  }}</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
                                <td>
                                    @if( $con->Status == 'SUCCESS') 
                                    <button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
                                    @elseif( $con->Status == 'PENDING') 
                                    <button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
                                    @else
                                    <button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
                                    @endif
                                </td>
                                <td>{{ $con->LiveId }}</td>
                                
                                <td>{{ $con->PreBal }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->Commision }}</td>
                                <td>{{ $con->PostBal }}</td>
                                <td>{{ $con->RequestType }}</td>
                                @if( $con->Status == 'SUCCESS' || $con->Status == 'FOR REFUND' || $con->Status == 'REJECT') 
                                <td>
                                       <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" 
							data-account="{{$con->Account}}" data-recstatus="{{$con->Status}}"
							data-amount="{{$con->Amount}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->Transactionid}}" 
							data-target="#complaint_modal" title="COMPLAINT" onClick="raise_dispute(this)">COMPLAINT</button>

                                    </td>
									<td><a class="btn btn-warning btn-xs" href="{{url('bill_receipt/'.$con->Transactionid)}}" target="_blank">PRINT RECEIPT</a></td>
                                @else
                                    <td></td>
									<td></td>
                                @endif
                            </tr>

                            @php 
                             $PreBal = $PreBal+$con->PreBal;
                             $Amount = $Amount+$con->Amount;
                             $Commision = $Commision+$con->Commision;
                             $PostBal = $PostBal+$con->PostBal;
                             @endphp   

                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th>{{$PreBal}}</th>
                                <th>{{$Amount}}</th>
                                <th>{{$Commision}}</th>
                                <th>{{$PostBal}}</th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

	<div class="modal fade" id="complaint_modal" role="dialog">
		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form name="rec_statuschng" action="{{'update_rech_status'}}" class="cmxform form-horizontal" enctype="multipart/form-data" method="post" >
		  	{{ csrf_field() }}
			<div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="status_modallabel"><center>RAISED COMPLAINT OR DISPUTE</center></h4>
            </div>
			<div class="modal-body"  style="font-size: 18px;">
				<div class="col-md-12 col-sm-12 col-xs-12">
					<div class="form-group mb0">
						<label class="control-label">MOBILE NUMBER :- <span id="statususer_mobileno"></span></label>
						<input id="txt_mobileno" name="txt_mobileno" type="hidden" class="form-control" required="required">
						<input id="txt_status" name="txt_status" type="hidden" class="form-control" required="required">
						<input id="txt_forrefundtxnid"   name="txt_forrefundtxnid" type="hidden" class="form-control" required="required" >
						<input id="txt_forrefundrechid" name="txt_forrefundrechid" type="hidden" class="form-control" required="required" >
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group">
						<label class="control-label">RECHARGE AMOUNT :- <span id="statususer_amount"></span></label>
						<input id="txt_amount" name="txt_amount" type="hidden" class="form-control" required="required">
					</div>
				</div>

				<div class="col-md-12 col-sm-12 col-xs-12 mb0">
					<div class="form-group">
											<label class="control-label mb0">ISSUE or REASON</label>
											<select name="dd_complaintreason" id="dd_complaintreason" class="form-control empty">
											<option value="-1">SELECT ISSUE or REASON</option>
												<option value="1">CUSTOMER NOT GOT BALANCE</option>
												<option value="2">WRONG OPERATOR RECHARGE</option>
												<option value="3">WRONG AMOUNT OPERATOR</option>
												<option value="4">LATE RECHARGE SUCCESS</option>
												<option value="5">DOUBLE RECHARGE SUCCESS</option>
											</select>
										</div>

				</div>
				<center>Would you like to raised complaint or dispute of recharge?</center>
			</div>

			<div class="modal-footer">
			<script type="text/javascript">
				function raise_dispute(obj)
				{
					$('#txt_status').val($(obj).data('recstatus'));
					$('#statususer_mobileno').html($(obj).data('account'));
					$('#txt_mobileno').val($(obj).data('account'));
					$('#statususer_amount').html($(obj).data('amount'))
					$('#txt_amount').val($(obj).data('amount'));
					$('#txt_forrefundtxnid').val($(obj).data('transid'));
					$('#txt_forrefundrechid').val($(obj).data('rechid'));
				} 
			</script>
			   <script type="text/javascript">
				function update_complaint()
				{
				   var txt_rechtxnid=$('#txt_forrefundtxnid').val();
				   var txt_rechid=$('#txt_forrefundrechid').val();
                   var dd_complaintreason=$('#dd_complaintreason').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_forrefundtxnid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('complaint_recharge')}}",
							dataType: 'json',
							data:{"txt_forrefundtxnid":txt_rechtxnid,"txt_rechid":txt_rechid,"dd_complaintreason":dd_complaintreason,"txt_forrefundstatus":"FOR REFUND",_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								//alert(msg);
							    if(msg==1)
								{
								alert("COMPLAINT UPDATE SUCCESFULLY");
										window.location.reload();
								}
								else
								{
									alert(msg);
								}
							}
						});
					}
				} 
			</script>
				<button type="button" onClick="update_complaint()" class="btn btn-info"> FOR REFUND</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">CANCEL</button>
			</div>
			</form>
		  </div>
		</div>
	</div>
@endsection