@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pending Recharge</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
            <li class="active">Pending Recharge</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->


    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Pending Recharge Report</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/user_pendingrecharge_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="YYYY-MM-DD" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Consumer No</label>
                                            <input type="text" id="txt_account" name="txt_account" class="form-control input-inline input-medium" placeholder="Enter Consumer No." >
                                        </div>
                                    </div> 
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txtuserid">Trnx ID</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control input-inline input-medium" placeholder="Enter User ID." >
                                    </div>
                                </div>  

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1">Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}">{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                    
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								<button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
 <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('pendingrecharge_report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>TXN DATE</th>
                                <th>MEMBERID/NAME</th>
                                <th>CONSUMERNO</th>
                                <th>OPERATOR</th>
                                <th>STATUS</th>
                                <th>TXN ID</th>
                                <th>OP.BAL</th>
                                <th>AMOUNT</th>
                                <th>COMMI</th>
                                <th>CL.BAL</th>
                                <th>VIA</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $rec_report as $con)
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>{{ $con->RequestDate }}</td>
                                <td>{{ $con->MemberID }}/ {{ $con->MemberFirstName  }}</td>
                                <td>{{ $con->Account }}</td>
                                <td>{{ $con->ServiceProvider }}</td>
                                <td>
                                    @if( $con->Status == 'SUCCESS') 
                                    <button type="button" class="btn btn-success btn-xs">{{ $con->Status }}</button>
                                    @elseif( $con->Status == 'PENDING') 
                                    <button type="button" class="btn btn-warning btn-xs">{{ $con->Status }}</button>
                                    @else
                                    <button type="button" class="btn btn-danger btn-xs">{{ $con->Status }}</button>
                                    @endif
                                </td>
                                <td>{{ $con->LiveId }}</td>
                                
                                <td>{{ $con->PreBal }}</td>
                                <td>{{ $con->Amount }}</td>
                                <td>{{ $con->Commision }}</td>
                                <td>{{ $con->PostBal }}</td>
                                <td>{{ $con->RequestType }}</td>
                                
                                
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection