@extends('mainlayout')
@section('content')
<?php $folder = ''; ?>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pending AEPS</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
            <li><a href="{{url('/'.Session::get("dash_url"))}}">Aeps Reports</a></li>
            <li class="active">Pending AEPS</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
    </div>
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
         <div class="row">
            
                <div class="panel">
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Pending AePS Report Filter Here</h3>
                    </div>

                    <div class="collapse out">
        
                        <form action="{{url('/user_pendingapestransfer_report')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                     <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1">Select Status</option>
										  <option value="1">SUCCESS</option>
											<option value="2">PENDING</option>
											<option value="3">COMPLAINT</option>
											<option value="4">FAILED</option>
                                            <option value="5">REJECT</option>
                                            <option VALUE="6">REFUNDED</option>
                           
                                        </select>
                                    </div>
                                </div>
								<div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>
                                    </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
<button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('pendingaeps-report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                     <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">

						<thead>
							<tr>
								<th>S.NO.</th>
								<th>TXN DATE</th>
								<th>MEMBER ID</th>
								<th>MEMBER NAME</th>
								<th>END USER CONTACT NO</th>
								<th>AMOUNT</th>
								<th>BANK REF NO</th>
								<th>TXN TYPE</th>
								<th>STATUS</th>
							
							
							</tr>
						</thead>
						<tbody>
	                   @foreach( $aeps_report as $con)
						<tr>
						<td>{{ '#' }}</td>
						<td>{{ $con->AEPS_TIMESTAMP }}</td>
						<td>{{ $con->MEMBER_CONTACTNO}}</td>
						<td>{{ $con->MEMBER_FIRSTNAME }} {{ $con->MEMBER_LASTNAME }}</td>
						<td>{{ $con->END_CUSTOMERNO }}</td>
						<td>{{ $con->AMOUNT }}</td>
						<td>{{ $con->AEPS_BANK_TID }}</td>
						<td>{{$con->AEPS_TXNTYPE}}</td>
						<td>@if( $con->AEPS_STATUS == 'SUCCESS' || $con->AEPS_STATUS == 'REJECT' || $con->AEPS_STATUS == 'RSUCCESS') 
						<button type="button" class="btn btn-success btn-xs">{{ $con->AEPS_STATUS }}</button>
						@elseif( $con->AEPS_STATUS == 'PENDING') 
						<button type="button" class="btn btn-warning btn-xs">{{ $con->AEPS_STATUS }}</button>
						@elseif( $con->AEPS_STATUS == 'FAILED'|| $con->AEPS_STATUS == 'REFUNDED'|| $con->AEPS_STATUS == 'RFAILED') 
						<button type="button" class="btn btn-danger btn-xs">{{ $con->AEPS_STATUS }}</button>
						@else
						<button type="button" class="btn btn-info btn-xs">{{ $con->AEPS_STATUS }}</button>
						@endif</td>
						
						

						</tr>
                        @endforeach
						</tbody>
					</table>
                </div>
            
            </div>
        </div>
        
    </div>
    <!--===================================================-->
    <!--End page content-->
    
</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection