@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Payment Summary</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Payment Summary</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Payment Summary</h3>
                </div>

                <div class="collapse out">
    
                    <form id="payment-summary" action="{{url('/user_credit_statement')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Trnx Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid"  value="{{$txt_transid}}" class="form-control" placeholder="Enter Transaction Id." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords"  value="{{$txt_noofrecords}}"  class="form-control" placeholder="Enter No. of Records." >
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Ledger Status</label>
                                        <select name="dd_ledgertype" id="dd_ledgertype" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_ledgertype == -1 ? 'selected':''}}>Select Ledger</option>
                                            <option value="1" {{$dd_ledgertype == 1 ? 'selected':''}}>CREDIT</option>
                                            <option value="4" {{$dd_ledgertype == 4 ? 'selected':''}}>RECHARGE FAILED</option>
                                            <option value="5" {{$dd_ledgertype == 5 ? 'selected':''}}>CASHBACK</option>
                                        </select>
                                    </div>
                                </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                               <button class="btn btn-success" type="submit">Search</button>
								 <button class="btn btn-primary" type="reset" >Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
  <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('payment_summary');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>

                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID/NAME</th>
								<th>TRANSACTION ID</th>
								<th>TRANSACTION DATE</th>
								<th>DESCRIPTION</th>
								<th>CR.AMOUNT</th>
								<th>DR.AMOUNT</th>	
								<th>BALANCE FOR</th>	
                                <th >MAINBAL</th>
                               <th >DMRBAL</th>
								<th >AEPSBAL</th>
							</tr>
						</thead>
						<tbody>
                            @foreach( $ledger_report as $con)
                             <tr>
                                 <td >{{'#'}}</td >
                                <td>{{$con->MemberID}}<span style="color:red;">/</span>{{$con->MemberFirstName}} {{$con->MemberLastName}}</td>
                                <td>{{$con->Transactionid}}</td>
                                <td>{{$con->TransactionDate}}</td>
                                <td>{{$con->Description}}</td>
                                <td>{{$con->AmountCredited}}</td>
                                <td>{{$con->AmountDedited}}</td>
                                <td>{{$con->BalanceType}}</td>
                                <td>{{$con->CurrentBalance}}</td>
                                <td>{{$con->UtilityBalance}}</td>
								<td>{{$con->RemittanceBalance}}</td>
                            </tr>
                             @endforeach
						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection