@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Pan Token Request</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Pan Token</a></li>
        <li class="active">Pan Token Request</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-md-4">
                <div class="panel">

					@if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('panup_msg')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
                        <h4 class="alert-heading">{{ Session::get("panup_msg") }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Pan Token Request</h3>
                    </div>

                    <div class="collapse in">
        
                    <form action="{{url('/pan_request')}}" enctype="multipart/form-data" id="pan_transfer" method="post" accept-charset="utf-8">
                        {{ csrf_field() }} 
                          <div class="panel-body">

                <div class="form-group">
                  <label class="control-label">Request Pan Token</label> 
                  <input id="txt_pan_token" name="txt_pan_token" type="number" class="form-control" required="required">                 
                </div>
                <div class="form-group">
                  <label class="control-label">Enter Remark</label>  
                  <input id="txt_remark" name="txt_remark" type="text" class="form-control" required="required">
                </div>
                
                <div class="form-group">
                  <button class="btn btn-success" type="button" onclick="conwv('pan_transfer')">Submit</button>
                  <button class="btn btn-primary" type="reset">Reset</button>
                </div>
              </div>
                       
                    </form>

                </div>

                </div>
            </div>
        

            <div class="col-md-8">
                <div class="row">
                    <div class="panel">

                        <div class="panel-heading">
                            <h3 class="panel-title">Pan Token Request <span class="pull-right"><button class="btn btn-success" id="excel" onclick="EXPORTTOEXCEL('fund_request');">Export To Excel</button></span></h3>
                        </div>
                    
                        <div class="panel-body">
                            
                            <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="min-tablet">S.NO.</th>
                                        <th class="min-tablet">PAN TOKEN</th>
                                        <th class="min-tablet">TOKEN AMOUNT</th>
                                        <th class="min-tablet">PAN TOKEN AMOUNT</th>
                                        <th>REMARK</th>
                                        <th>STATUS</th>
                                        <th>CREATED AT</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pan_token as $key=>$value)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$value->PAN_TOKEN}}</td>
                                        <td>{{107}}</td>
                                        <td>{{$value->PAN_TOKEN*107}}</td>
                                        <td>{{$value->REMARK}}</td>
                                        <td>{{$value->STATUS}}</td>
                                        <td>{{$value->CREATED_AT}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    
                    </div>
                </div>

            </div>
        </div>

    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">
get_member_name2();
function get_member_name2()
{
  var user_contactno = $("input[name='txt_mobileno']").val();
//alert(user_contactno);
  user_contactno = user_contactno.split(' ');
  var txt_contactno=user_contactno[0];
  
  console.log(user_contactno);
  //var csrf = $("input[name='csrf_token']").val();
  if($("#txt_mobileno").val()!="" && txt_contactno.length==10)
  {
    $.ajax({  
      type:"POST",
      url:'get_details',
      dataType: 'json',
      data:{"txt_contactno":txt_contactno,"_token": "{{ csrf_token() }}"},
      beforeSend : function(){
        $('img.loader').show('fadein');
      },
      success:function(msg) 
      {
        console.log(msg);
        $('img.loader').hide('fadeout');
          $('#user_name').html(msg[0].FirstName+' '+msg[0].LastName);
          //alert($("input[name='baltype']").val());
          if($("input[name='baltype']:checked").val()==1)
          {
          $("#user_balance").html(msg[0].RECHARGE_BAL);
            $('#user_outstanding').html(msg[0].RECHARGE_BAL_OUTSTANDING);
          }
          if($("input[name='baltype']:checked").val()==2)
          {
          $("#user_balance").html(msg[0].UTILITY_BAL);
          $('#user_outstanding').html(msg[0].UTILITY_BAL_OUTSTANDING);
          }
      }
    });
  }
}
 </script>
@endsection