@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Operator Wise</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Operator Wise</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Operator Wise</h3>
                </div>

                <div class="collapse out">
    
                    <form id="payment-summary" action="{{url('/user_operatorwise')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" value="{{$start}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate"  value="{{$end}}" class="form-control" placeholder="dd/mm/yyyy" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control">
                                            <option value="-1" {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}" {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
            
                <div class="panel-body">
   <div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('operator-wise');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>DATE</th>
								<th>OPERATOR</th>
								<th>TOTAL (SUCCESS+PENDING+REJECT)</th>
                            </tr>
						</thead>
						<tbody>
                            @foreach( $rec_report as $con)
                            <tr>
                                <td>{{ '#' }}</td>
                                <td>{{ $con->RECDATE }}</td>
                                <td>{{ $con->TELECOM_BRAND }}</td>
                                <td>{{ $con->SUCCESS + $con->PENDING + $con->REJECT}}</td>
                            </tr>
                            @endforeach
						</tbody>

					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection