@extends('mainlayout')
@section('content')
<style >
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Shopping Product</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->
        
        
        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
            <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
            <li><a href="{{ url('/admin_dashboard') }}">Shopping Product</a></li>
            <li class="active">EDIT ORDER</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->
        
    </div>
    
    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-lg-offset-3 col-lg-6">
                <div class="panel">

                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    @if(Session::has('message')) 
                    <div class="alert alert-{{ Session::get('type') }} alert-dismissible show" role="alert">
                        <h4 class="alert-heading">{{ Session::get('message') }}</h4>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">EDIT ORDER</h3>
                    </div>
                    
                    <div class="collapse">   
                        
                        <form action="{{url('user_edit_order')}}" id="profile_edit" method="post" accept-charset="utf-8">
                            {{ csrf_field() }} 
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" for="txt_orderid">Order Id *</label>
                                            <input type="text" id="txt_orderid" name="txt_orderid" class="form-control" placeholder="Enter Order Id." autocomplete="off">
                                        </div>
                                    </div>    
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="control-label" style="display:block;">&nbsp;</label>
                                            <button class="btn btn-success" type="submit">Find</button>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </form>
                    </div>
                    
                </div>
            </div>
            
        </div>
        @if($single_order != '')
        <div class="row">

            <div class="col-sm-6">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Order Detail</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <tr>
                                        <td class="border-top-none">Order Id.</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->ORDER_CODE}}</strong></td>
                                    </tr>
                                    <tr>    
                                        <td class="border-top-none">User Code </td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->USER_CODE}}</strong></td>
                                    </tr>
                                    <tr>    
                                        <td class="border-top-none">User Name </td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->USER_NAME}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Address</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->FLAT, $single_order[0]->AREA, $single_order[0]->LANDMARK, $single_order[0]->PINCODE, $single_order[0]->ADDRESS_TYPE}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Amount</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->FINAL_AMOUNT}}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div>

            <div class="col-sm-6">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Order Status</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <tr>
                                        <td class="border-top-none">Order Status</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->ORDER_STATUS}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Payment Status</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->PAYMENT_STATUS}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Payment Method</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->PAYMENT_METHOD}}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="border-top-none">Created At</td>
                                        <td class="border-top-none"><strong>{{$single_order[0]->CREATED_AT}}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div>
                
        

        <div class="col-sm-12">
            
            <div class="panel panel-bordered panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title text-light">Order Status</h3>
                </div>
                    
                <!-- Striped Table -->
                <!--===================================================-->
                <div class="panel-body">
                    <form id="update_order" action="{{ url('user_update_order') }}" enctype="multipart/form-data" method="post" accept-charset="utf-8">      
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <input id="txt_order_id" name="txt_order_id" type="hidden" required="required" value="{{$single_order[0]->ORDER_ID}}" readonly>
                            <div class="row">
                               <!--  <legend>Order Status</legend> -->
                                <div class="col-sm-6">
                                     <div class="form-group">
                                         <label class="control-label" for="dd_orstatus">Order Status</label>
                                         <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_orstatus" id="dd_orstatus" required="required">
                                            <option value="">Select Order Status</option>
                                            <option value="1" {{$single_order[0]->ORDER_STATUS == 'PENDING' ? 'selected' : ''}}>Pending</option>
                                            <option value="2" {{$single_order[0]->ORDER_STATUS == 'ACCEPTED' ? 'selected' : ''}}>Accepted</option>
                                            <option value="3" {{$single_order[0]->ORDER_STATUS == 'CANCELLED' ? 'selected' : ''}}>Cancelled</option>
                                            <option value="4" {{$single_order[0]->ORDER_STATUS == 'DELIVERED' ? 'selected' : ''}}>Delivered</option>
                                         </select>
                                      </div>
                                </div>    
                                <div class="col-sm-6">
                                     <div class="form-group">
                                         <label class="control-label" for="dd_paystatus">Payment Status</label>
                                         <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_paystatus" id="dd_paystatus" required="required">
                                            <option value="">Select Payment Status</option>
                                            <option value="1" {{$single_order[0]->PAYMENT_STATUS == 'PENDING' ? 'selected' : ''}}>Pending</option>
                                            <option value="2" {{$single_order[0]->PAYMENT_STATUS == 'SUCCESS' ? 'selected' : ''}}>Success</option>
                                            <option value="3" {{$single_order[0]->PAYMENT_STATUS == 'FAILED' ? 'selected' : ''}}>Failed</option>
                                         </select>
                                      </div>
                                </div>
                                
                            </div>
                            
                           
                     
                            
                        </div>
                        <div class="panel-footer text-center">
                            @if($single_order[0]->ORDER_STATUS == 'PENDING' || $single_order[0]->ORDER_STATUS == 'ACCEPTED')
                            <button class="btn btn-success" type="button" onclick="conwv('update_order')">UPDATE</button>
                            <button type="reset" class="btn btn-primary">RESET</button> 
                            @endif
                        </div>
                    </form>
            
                </div>
                <!--===================================================-->
                <!-- End Striped Table -->
                    
            </div>   
        </div>
                <div class="col-sm-12">
                <div class="panel panel-bordered panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title text-light">Products</h3>
                    </div>
                        
                    <!-- Striped Table -->
                    <!--===================================================-->
                    <div class="panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <tbody>
                                    <th>
                                        <td class="border-top-none"><strong>Name</strong></td>
                                        <td class="border-top-none"><strong>Image</strong></td>
                                        <td class="border-top-none"><strong>Unit</strong></td>
                                        <td class="border-top-none"><strong>Variant</strong></td>
                                        <td class="border-top-none"><strong>Type </strong></td>
                                        <td class="border-top-none"><strong>Qty</strong></td>
                                       <!--  <td class="border-top-none"><strong>Revised Qty</strong></td> -->
                                        <td class="border-top-none"><strong>Price </strong></td>
                                        <td class="border-top-none"><strong>Disc Price </strong></td>
                                        <td class="border-top-none"><strong>Total </strong></td>
                                    </th>
                                    @foreach(json_decode($single_order[0]->PRODUCT_DETAILS) as $kye => $provalue)
                                    @php  $image = explode(",",$provalue->image); if(count($image) > 0){ $img = $image[0]; }else{ $img = ''; } 
                                        
                                    @endphp
                                    <tr>
                                        <td class="border-top-none">{{$kye+1}}</td>
                                        <td class="border-top-none">{{$provalue->name}}</td>
                                        <td class="border-top-none"><img src="{{asset('images/prod_logo/'.$img)}}" width="50"></td>
                                        <td class="border-top-none">{{$provalue->capacity}} {{$provalue->unit_name}}</td>
                                        <td class="border-top-none">{{$provalue->is_variant}}</td>
                                        <td class="border-top-none">@if($provalue->is_variant == 'YES'){{$provalue->group_name}}{{$provalue->option_name}} @endif</td>
                                        <td class="border-top-none">{{$provalue->quantity}}</td>
                                  <!--       <td class="border-top-none" style="display: flex;">  
                                            <input class="form-control input-sm" style="width: 62px;" type="number" id="new_qty_revqty_{{$provalue->prod_id}}" value="{{$provalue->new_quantity}}" />  
                                            <button class="btn btn-success" type="button" onclick="revised_qty(this.id)" id="revqty_{{$provalue->prod_id}}" data-pro_id="{{$provalue->prod_id}}" data-vari_id="{{$provalue->varnt_id}}" data-is_variant="{{$provalue->is_variant}}" data-quantity="{{$provalue->quantity}}" style="padding: 4px 12px;"><i class="fa fa-upload" aria-hidden="true"></i> </button> </td> -->
                                        <td class="border-top-none"><i class="fa fa-inr"></i> {{number_format($provalue->price,2)}}</td>
                                        <td class="border-top-none"><i class="fa fa-inr"></i>  {{number_format($provalue->disc_price,2)}}</td>
                                        <td class="border-top-none"><i class="fa fa-inr"></i>  {{number_format($provalue->new_quantity*$provalue->disc_price,2)}}</td>
                                    </tr>
                                    @endforeach
                                    <th>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"></td>
                                        <td class="border-top-none"><strong>SubTotal </strong></td>
                                        <td class="border-top-none"><strong><i class="fa fa-inr" aria-hidden="true"></i> {{number_format($single_order[0]->FINAL_AMOUNT,2)}} </strong></td>
                                    </th>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!--===================================================-->
                    <!-- End Striped Table -->
                        
                </div>
            </div> 
             </div>      
        @endif
    </div>
    <!--===================================================-->
    <!--End page content-->
        
</div>
<script type="text/javascript">
function revised_qty(id) {
    var reviseqty = $('#new_qty_'+id).val();
    var order_id = $('#txt_order_id').val();
    var prod_id = $('#'+id).data('pro_id');
    var provar_id = $('#'+id).data('vari_id');
    var proisvar = $('#'+id).data('is_variant');
    var quantity = $('#'+id).data('quantity');
    if(reviseqty < 0)
    {
        alert('Please enter revised Qty greater than 0');
    }
    else if(reviseqty > quantity)
    {
        alert('Please enter revised Qty less than or equal to Qty')
    }
    else if(order_id === undefined)
    {
        alert('Order Id Not Found!')
    }
    else
    {
         $.ajax({
            type:'POST',
            url:"{{url('user_update_revised_qty')}}",
            data:{"_token": "{{ csrf_token() }}", 'prod_id': prod_id, 'provar_id': provar_id, 'proisvar': proisvar, 'quantity': reviseqty , 'order_id': order_id },
           success:function(result)
           {       
                if (result == 1) 
                {
                    alert('Product Revised Qty successfuly');
                    location.reload();
                }
           }
        });
    }
}
</script>
@endsection
    