@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">Submit Query Here</li>
		<a class="btn btn-primary" style="float: right;" href="{{url('submit_query')}}">View Ticket </a> 
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

                    @if(session('success'))
                  <div class="alert alert-success">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-smile-o fa-2" aria-hidden="true"> </i><strong> {{ session('success') }}</strong>
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <strong> {{ session('error') }}</strong>
                    </div>
                @endif
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="col-lg-offset-2 col-lg-8">
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                        </div>
                        <h3 class="panel-title">Submit Query Here</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('/submit_query')}}" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="panel-body form-horizontal form-padding">                               
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_department">Department</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_department" id="txt_department" class="form-control" placeholder="Enter Subject." value="Support" readonly>
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_urgency">Urgency</label>
                                    <div class="col-md-9">
                                        <select class="selectpicker" data-live-search="true" name="txt_urgency" data-width="100%">
                                                    <option value="">SELECT URGENCY</option>
                                                    <option value="3">LOW</option>
                                                    <option value="2">MEDIUM</option>
                                                    <option value="1">HIGH</option>
                                        </select>
                                @error('txt_urgency')
                                    <div class="control-label text-danger text-left">{{ $message }}</div>
                                @enderror
                                    </div>
                                </div>  
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_title">Subject</label>
                                    <div class="col-md-9">
                                        <input type="text" name="txt_title" id="txt_title" class="form-control" placeholder="Enter Subject." required>
                                @error('txt_title')
                                    <div class="control-label text-danger">{{ $message }}</div>
                                @enderror
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label class="col-md-3 control-label" for="txt_msg">Text Message</label>
                                    <div class="col-md-9">
                                        <textarea id="txt_msg" name="txt_msg" data-provide="markdown" rows="6" class="form-control" required></textarea>
                                @error('txt_msg')
                                    <div class="control-label text-danger">{{ $message }}</div>
                                @enderror
                                    </div>
                                </div>  
                                <div class="form-group">
                                  <label class="col-md-3 control-label" for="txt_title">File</label>
                                <div class="media-left" style="padding-left: 9px;">
                                    <span class="btn btn-primary btn-file">
                                    Attachment <input type="file" name="file_image">
                                </span>
                                </div>
                                <div id="demo-attach-file" class="media-body"></div>
                                @error('file_image')
                                    <div class="control-label text-danger">{{ $message }}</div>
                                @enderror
                                </div>  

                            </div>
                           
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit" onclick="return confirm('Are you sure you want to send the query?');">Query</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>          
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection