@extends('mainlayout')
@section('content')
<style type="text/css">


.gr-1 {
    background: linear-gradient(170deg, #01E4F8 0%, #1D3EDE 100%);
}

 .ico-card {
    position: absolute;
    top: 0;
    left: 0;
    bottom: 0;
    right: 0;
    width: 100%;
    height: 100%;
    overflow: hidden;
}
.ico-card i {
    position: relative;
    right: -50%;
    top: 55%;
    font-size: 20rem;
    line-height: 0;
    opacity: 0.2;
    color: white;
    z-index: 0;
}

 .ico-card i:hover {
 	right: -41%;
 }
 /* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}

</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Add Fund</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Wallet</a></li>
        <li class="active">Add Fund</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        <div class="row">
			<div class="col-md-4">
				<div class="panel">
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
						<h3 class="panel-title">Available Balance</h3>
					</div>
					<div class="collapse in pad-all">
						<div class="panel panel-success panel-colorful wallet-card">
							<div class="pad-all" style="padding: 56px 10px;">
								<p class="text-lg text-semibold"><i class="demo-pli-data-storage icon-fw"></i>Available Wallet Balance</p>
								<p class="mar-no" style="font-size: 50px;">$ {{number_format($user[0]->RECHARGE_BAL,2)}}</p>
									<div class="ico-card">
							        	<i class="fa-solid fa-wallet"></i>
							     	</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			@if($vclemail=='')
			<div class="col-md-8" >
				@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
				<div class="panel">
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
						<h3 class="panel-title">Add fund to fund wallet</h3>
					</div>
					<div class="collapse in">
						<form id="show-qr-code" action="{{url('add-fund-wallet-vcl')}}" method="post">
							{{ csrf_field() }}
							<div class="panel-body">
								<div class="form-group">
                                    <label class="control-label" for="txt_amount">Enter Amount</label>
                                    <input type="number" name="txt_amount" id="txt_amount" class="form-control" placeholder="Enter Amount." required="">
                                    <span class="text-danger" id="divtxt_amount"> </span>
								</div>
								<div class="form-group">
                                    <label class="control-label">Mode of Payment</label>
                                    <select id="dd_user_forwallet" name="dd_user_forwallet" class="form-control opt">
										<option value="1">VCRRLIVE (VCL)</option>
									</select>
								</div>
								<div class="form-group">
                                    <label class="control-label" for="txt_amount">Enter Vcrrlive (VCL) ID</label>
                                    <input type="text" name="txt_vcrrlive" id="txt_vcrrlive" class="form-control" placeholder="Enter Vcrrlive Id." required @if($user[0]->VCLCode != '') readonly value="{{$user[0]->VCLCode}}" @endif>
                                    <span class="text-danger" id="divtxt_vcrrlive"> </span>
								</div>
								<span>Minimum Deposit $10</span>
							</div>
							<div class="panel-footer text-center">
								<button class="btn btn-success" type="button" id="proceed-to-add-funds">Proceed to add funds</button>
							</div>
						</form>
					</div>
				</div>
			</div> 
			@else
			<!-- QR CODE -->
			<div class="col-md-8">
				@if(Session::has('message')) 
				<div class="alert alert-{{ Session::get('type') }} alert-dismissible  show" role="alert">
					<h4 class="alert-heading">{{ Session::get("message") }}</h4>
					<button type="button" class="close" data-dismiss="alert" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				@endif
				<div class="panel">
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
						<h3 class="panel-title">Add fund to fund wallet</h3>
					</div>
					<div class="collapse in">
						<form id="ledger-report" action="{{url('add-fund-wallet-vcl-verify')}}" method="post">
							{{ csrf_field() }}
							<div class="panel-body">
								<div class="text-center">
									<h2 style="text-align: left;">Verify This Email <span id="amount-usd"></span></h2>
									<div class="form-group">
					                    <input type="text" id="txt_vcl_email" value="{{$vclemail}}" class="form-control" readonly>
					                </div>
					                <input type="hidden" name="txt_amount" value="{{$vclamount}}">
					                <input type="hidden" name="txt_vcrrlive" value="{{$vclcode}}">
					                <input type="hidden" name="txt_email" value="{{$vcl_email}}">
					                <div class="form-group">
					                	<label style="font-weight: 700;" for="txt_vcl_otp">OTP</label>
					                    <input type="number" id="txt_vcl_otp" name="txt_vcl_otp" value="" class="form-control">
					                </div>
									<p style="display: flex;">
										<a href="{{url('cancelled-vcl-verify')}}" class="btn btn-success" type="button" id="back_btn" style="width: 100%;">Back</a> &emsp;&emsp;
										<button type="submit" class="btn btn-success" style="width: 100%;">Verify</button>
									</p>
								</div>
							</div>
						<!-- 	<div class="panel-footer">
								<h4><strong>Important</strong></h4>
								<p>1) Do not refresh or close window until fund will be received.</p>
								<p>2) Do not deposit TRX or any other TRC20 assets/Tokens except USDT may result in the loss of your deposit.</p>
								<p>3) Fund will be deposited after 10 network confirmations.</p>
								<p>4) Click on procedd of dun is not received automatically.</p>
							</div> -->
						</form>
					</div>
				</div>
			</div> 
			@endif

				<div class="col-md-12">
				<div class="panel">
					<div class="panel-heading">
						<div class="panel-control">
							<button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
						</div>
						<h3 class="panel-title">Report</h3>
					</div>
					<div class="collapse in">
						<table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
							<thead>
								<tr>
									<th>Sr. No.</th>
									<th>Amount</th>
									<th>Trans Id.</th>
									<th>Status</th>
									<th>Updated</th>
								</tr>
							</thead>
							<tbody>
								@foreach($tron_recharge as $key => $value)
								<tr>
									<td>{{$key+1}}</td>
									<td>{{$value->AMOUNT}}</td>
									<td>{{$value->TRANS_ID}}</td>
									<td>{{$value->STATUS}}</td>
									<td>{{date('d-m-Y H:i:s', strtotime($value->UPDATED_AT))}}</td>
								</tr>
								@endforeach
							</tbody>
					    </table>
					</div>
				</div>
			</div> 
		</div> 
		
		



          
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script type="text/javascript">
	$("#proceed-to-add-funds").click(function () {

		$("#divtxt_amount").text('');

		if($("#txt_amount").val() == '') {
			$("#divtxt_amount").text('Please enter amount.');
		} else if($("#txt_vcrrlive").val() == '') {
			$("#divtxt_vcrrlive").text('Please enter VCL Id.');
		} else if ($("#txt_amount").val() < 10) {
			$("#divtxt_amount").text('min amount enter $10');
		} else if ($("#txt_amount").val() > 1000000) {
			$("#divtxt_amount").text('max amount enter $1000000');
		} else {
			$("#amount-usd").text($("#txt_amount").val());
			//$("#add-fund-form").hide();
			//$("#show-qr-code").show();

			$("#show-qr-code").submit();
		}
	});

</script>
@endsection