@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Ticket Reassigned</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/admin_dashboard') }}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{ url('/admin_dashboard') }}">Support</a></li>
        <li class="active">Ticket Reassigned</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
		 <div class="row">
            
                <div class="panel">
                                        @if(session('success'))
                  <div class="alert alert-success">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-smile-o fa-2" aria-hidden="true"> </i><strong> {{ session('success') }}</strong>
                    </div>
                @elseif(session('error'))
                    <div class="alert alert-danger">
                        <button class="close" data-dismiss="alert"><i class="pci-cross pci-circle"></i></button>
                        <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> <strong> {{ session('error') }}</strong>
                    </div>
                @endif
            
                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class=" fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Ticket Filter</h3>
                    </div>

                    <div class="collapse in">
        
                        <form action="{{url('/filter-assign-tickets')}}" method="POST">
							{{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtfromdate">From Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txtfromdate" id="txtfromdate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>    
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txttodate">To Date</label>
                                            <div id="demo-dp-txtinput">
                                                <input type="text" name="txttodate" id="txttodate" class="form-control input-inline input-medium" placeholder="dd/mm/yyyy" autocomplete="off" >
                                            </div>
                                        </div>
                                    </div>
                                <div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket No</label>
                                            <input type="text" id="txt_ticket" name="txt_ticket" class="form-control input-inline input-medium" placeholder="Enter Ticket  No." >
										@if(count($tickets) > 0) <input type="hidden" id="txt_status" name="txt_status" value="{{$tickets[0]->STATUS}}"> @endif                                        
										</div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_client">Client</label>
                                            <select name="dd_client" id="dd_client"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT CLIENT</option>
										@foreach($users as $u)
										<option value="{{$u->RegId}}">{{$u->MemberName}}  {{$u->RegCode}}</option>
										@endforeach
									</select>
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_employee">Employee</label>
                                            <select name="dd_employee" id="dd_employee"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT EMPLOYEE</option>
                                        @foreach($emp as $values)
										<option value="{{$values->RegId}}">  {{$values->MemberName}} {{$values->RegCode}}</option>
                                       <br> <b>  </b>

                                        @endforeach
						
									</select>
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Ticket Type</label>
                                            <select name="dd_ticket" id="dd_ticket"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">SUPPORT</option>
										<option value="2">ACCOUNT</option>
										<option value="3">SALES</option>
									</select>
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="txtuserid">Urgency</label>
                                            <select name="dd_urgency" id="dd_urgency"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">HIGH</option>
										<option value="3">LOW</option>
										<option value="2">MEDIUM</option>
									</select>
                                        </div>
                                    </div> 
									<div class="col-sm-2">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_status">Status</label>
                                            <select name="dd_status" id="dd_status"  class="form-control empty selectpicker" data-live-search="true" data-width="100%">
										<option value="">SELECT STATUS</option>
										<option value="1">Active</option>
										<option value="2">InActive</option>
									</select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
								<button class="btn btn-primary" type="reset">Reset</button>
                            </div>
                        </form>
                        
                    </div>
        
                </div>
            
        </div>
        <div class="row">
            <div class="panel">

                <div class="panel-body">
<div class="mb-10 pull-left"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('ticket-reassign');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-addrow" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Ticket No.</th>
                                <th class="min-tablet">Ticket Type </th>
								<th class="min-tablet">Urgency</th>
                                <th class="min-tablet">Full Name</th>
                                <th class="min-tablet">Title</th>
								<th class="min-tablet">Assigned</th>
                                <th class="min-tablet">Status</th>
                                <th class="min-tablet">Created Date</th>
                            </tr>
                        </thead>
                        <tbody>
							@php $sn=0; @endphp
                            @foreach($tickets as $tk)
                            <tr>
                                <td>{{++$sn}}</td> 
                                <td>@if($tk->STATUS != 'InActive')<a class="btn-link" href="{{url('ticket_reply/'.$tk->TICKET_ID)}}"> {{$tk->TICKET_NO}} </a> @else  {{$tk->TICKET_NO}} @endif</td>
                                <td>{{$tk->TICKET_FOR}}</td>
								 <td>{{$tk->URGENCY}}</td>
                                <td>
                                    @foreach($users as $u)
                                    @if($u->RegId == $tk->USER_ID)
                                    {{$u->MemberName}} <br><b>{{$u->RegCode}}</b>
                                    @endif
                                    @endforeach
                                </td>
                                <td>{{$tk->SUBJECT}}</td>
								@if($tk->STATUS == 'InActive')
									 <td>		@foreach($emp as $values)
											@if($tk->EMP_ID == $values->RegId)
											 {{$values->MemberName}} <br> <b>{{$values->RegCode}}</b>
											@endif
											@endforeach </td>
								@else
								<td class="text-center">
									@if($tk->EMP_ID == $tk->ASSIGNED_TO)
					                      <select class="selectpicker" data-live-search="true"  data-width="100%" id="{{$tk->TICKET_ID}}" onchange="assign_ticket(this.id)">
									
									@if($tk->ASSIGNED_TO == null)
										<option value="">Select Name</option>
									@else
                                        @foreach($emp as $values)
                                        @if($tk->ASSIGNED_TO == $values->RegId)
                                         <option value="">{{$values->MemberName}} {{$values->RegCode}}</option>
                                        @endif
                                        @endforeach
										@endif
										

										@foreach($emp as $value)
										@if($tk->TICKET_FOR == $value->MemberRole)
					                      	<option value="{{$value->RegId}}">{{$value->MemberName}} {{$value->RegCode}}</option>
										@endif
										@endforeach
					                      </select> 
										@else
											@foreach($emp as $values)
											@if($tk->EMP_ID == $values->RegId)
											 {{$values->MemberName}} <br> <b>{{$values->RegCode}}</b>
											@endif
											@endforeach
										@endif
                                </td>
									@endif
                                <td>{{$tk->STATUS}}</td>
                                <td>{{$tk->CREATED_AT}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>


<!--===================================================-->
<!--END CONTENT CONTAINER-->

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
  function assign_ticket(id){
	var empid = $('#'+id).val();
		var tick_id = id;
		if (confirm("You want to Assigned Ticket This User ?")) {
			$.ajax({
			   type:"POST",
			   url:"{{ url('/reassigned_ticket') }}",
			   data:{"_token": "{{ csrf_token() }}", "empid": empid, "tick_id":tick_id},
			   success:function(result)
				{
					location.reload();
				}
			});
		}	
        }
</script>
@endsection