@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">User Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT REQUEST HERE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PRODUCT REQUEST HERE</h3>
                </div>
                <div class="text-center">
                    <button type="submit" id="req-btn" class="btn btn-success btn-md">REQUEST</button>
                </div>
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>Quantity</th>
                                <th class="min-tablet">Product Name</th>
                                <th class="min-tablet">Product Price</th>
                                <th class="min-tablet">Distributer Price</th>
                                <th class="min-tablet">Product Weight</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($product as $value)
                            <tr>
                                <td><input class="ckb_id" type="checkbox" id="{{$loop->index}}" name="{{$loop->index}}" data-chk-id="{{$value->m41_product_id}}"></td>
                                <td><input type="number" id="ord_qty{{$loop->index}}" name="ord_qty{{$loop->index}}"></td>
                                <td>{{$value->m41_product_name}}</td>
                                <td>&#8377;{{$value->m41_product_price}}</td>
                                <td>&#8377;{{$value->m41_product_dp}}</td>
                                <td>{{$value->m41_product_weight}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div>


        
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

<script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
  $(document).on('click', '#checkAll', function() {
  
    if ($(this).val() == 'Check All') {
      $('.check input').prop('checked', true);
      $(this).val('Uncheck All');
    } else {
      $('.check input').prop('checked', false);
      $(this).val('Check All');
    }
  });
  $('.ckb_id').on('click', function(e){
        var id = $(this).attr('id');
        var val = $('#ord_qty'+id).val();
        if(val){
            $(this).val(val);
        }else{
            alert('Please fill value.');
        }
  });
  $('#req-btn').on('click', function(e){
    var prods = [];
    var qty = [];
    $('#demo-dt-selection input:checked').each(function(){
      prods.push($(this).data('chk-id'));
      qty.push($(this).val());
    });
    if(prods.length<=0){
      alert("Please select records.");
    }
      else
      {
        WRN_PROFILE_DELETE = "Are you sure you want to request "+(prods.length>1?"these":"this")+" row?";
        var checked = confirm(WRN_PROFILE_DELETE);
        if(checked == true){
          var selected_values = prods.join(",");
          var quant = qty.join(",");
          $.ajax({
            type:"POST",
            url:"{{url('/get_request')}}",
            data:{"_token": "{{ csrf_token() }}", "prods_id": selected_values, "qty": quant},
            success: function(response){
              var prod_ids = response.split(",");
              for(var i=0; i<prod_ids.length; i++){
                $("#"+prod_ids[i]).remove();
              }
            }
          });
        }
      }
  });
});
</script>
