@extends('mainlayout')
@section('content')
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Master Panel</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{ url('/') }}"><i class="demo-pli-home"></i></a></li>
        <li><a href="{{ url('/') }}">Dashboard</a></li>
        <li class="active">PRODUCT PURCHASE</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <div class="row">
            
            <div class="panel">
                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="demo-psi-chevron-up"></i></button>
                    </div>
                    <h3 class="panel-title">PRODUCT PURCHASE HERE</h3>
                </div>

                <div class="collapse in">
                    <form class="form-horizontal">
                        {{ csrf_field() }}
                        <div class="panel-body">
                            <div class="row">  

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">User ID *</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_userid" name="txt_userid" class="form-control" placeholder="Enter User ID." onkeyup="getuser();" required>
                                        <input type="hidden" id="txt_uid" name="txt_uid">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">User Name</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_name" name="txt_name" class="form-control">
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Mode</label>
                                      <div class="col-md-8 col-xs-12">
                                        <select class="form-control" name="dd_mode" id="dd_mode" required>
                                            <option value="">Select</option>
                                            <option value="1">Cash</option>
                                            <option value="2">Wallet</option>
                                            <option value="3">Cash+Wallet</option>
                                        </select>
                                      </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Wallet</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_wallet" name="txt_wallet" class="form-control" disabled>
                                      </div>
                                    </div>
                                </div>          
                                 
                                <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                      <label class="control-label col-md-4 col-xs-12">Total Amount</label>
                                      <div class="col-md-8 col-xs-12">
                                        <input type="text" id="txt_totalamt" name="txt_totalamt" class="form-control" disabled>
                                      </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="panel-footer text-center">
                            <button id="purchase_btn" type="button" class="btn btn-success"  onclick="purchase();">Submit</button>
                            <button class="btn btn-primary" type="reset">Cancel</button>                           
                        </div>
                    </form>
                    
                    
                </div>
    
            </div>

        </div> 

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PRODUCT PURCHASE HERE</h3>
                </div>
                
                <div class="panel-body">
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>S.NO.</th>
                                <th>Quantity</th>
                                <th class="min-tablet">Product Name</th>
                                <th class="min-tablet">Product Price</th>
                                <th class="min-tablet">Distributer Price</th>
                                <th class="min-tablet">Product Weight</th>
                                <th class="min-tablet">Stock</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php ?>
                            @foreach($product as $p)
                            <tr>
                                <td>
                                    <input class="ckb_id" type="checkbox" id="{{$p->m41_product_id}}" name="ckb_{{$p->m41_product_id}}" data-chk-id="{{$p->m41_product_id}}">
                                </td>
                                <td>
                                    <select id="dd_quant{{$p->m41_product_id}}" name="dd_quant{{$p->m41_product_id}}">
                                        <?php 
                                            $i=0;
                                            for($i=1;$i<=890;$i++) {
                                        ?>
                                        <option value="{{$i}}">Select {{$i}}</option>
                                        <?php 
                                            }
                                        ?>
                                    </select>
                                </td>
                                <td>{{$p->m41_product_name}}</td>
                                <td>&#8377;{{$p->m41_product_price}}</td>
                                <td>&#8377;{{$p->m41_product_dp}}</td>
                                <td>{{$p->m41_product_weight}}</td>
                                <td>{{$p->m41_product_bussn_volume}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
        
            </div>
        </div> 
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
@endsection

<script src="http://code.jquery.com/jquery-2.1.4.min.js"></script>
<script type="text/javascript">

        function getuser(){
            var user = $('#txt_userid').val();
            
            if(user){
                $.ajax({
                   type:"POST",
                   url:"{{url('/get_user')}}",
                   data:{"_token": "{{ csrf_token() }}", "userid": user},
                   success:function(result)
                   {       
                        if(result)
                        {
                            $("#txt_uid").empty();
                            $("#txt_name").empty();
                            $("#txt_uid").val(result[0].m11_user_id);
                            $("#txt_name").val(result[0].m11_user_name);
                        }else{
                            $("#txt_uid").empty();
                            $("#txt_name").empty(); 
                        }
                   }

                });
            }
        };


        function purchase(){

            var prod_id = $('.ckb_id:checked').data('chk-id');
            var qty = $('#dd_quant'+prod_id).val();
            var uid = $('#txt_uid').val();
            var userid = $('#txt_userid').val();
            var user_name = $('#txt_name').val();
            var pay_mode = $('#dd_mode').val();
            var txt_totalamt = $('#txt_totalamt').val();
            var txt_wallet = $('#txt_wallet').val();

            if(userid == ""){
                alert("UserID is required.");
            }


            if(prod_id){
                $.ajax({
                   type:"POST",
                   url:"{{url('/purchase_entry')}}",
                   data:{"_token": "{{ csrf_token() }}", "prod_id": prod_id, "qty": qty, "uid": uid, "userid": userid, "user_name": user_name, "pay_mode": pay_mode, "txt_totalamt": txt_totalamt, "txt_wallet": txt_wallet},
                   success:function(result)
                   {       
                        if(result)
                        {
                            console.log(result);
                            location.reload();
                        }

                   }

                });
            }
            else{
                alert("Please select product.");
            }

        };

</script>
