@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Utility Surcharge Slab Wise</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Slab</a></li>
        <li class="active">Utility Surcharge Slab Wise</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Utility Surcharge Slab Wise</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('/utility_surcharge')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_group" id="dd_group" required>
                                                <option value="-1" {{ $grid == '-1'? 'selected':'' }}>Select Group</option>
                                                @foreach($slab as $sb)
                                                <option value="{{ $sb->GROUP_ID }}" {{ $grid == $sb->GROUP_ID? 'selected':'' }}>{{$sb->GROUP_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_service">Services</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_service" id="dd_service" required>
                                                <option value="-1" {{ $opid == '-1'? 'selected':'' }}>Select Service</option>
                                                @foreach($SERVICE as $service)
                                                <option value="{{ $service->SR_TYPEID }}" {{ $opid == $service->SR_TYPEID? 'selected':'' }}>{{ $service->SR_NAME }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                                <button class="btn btn-default" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Utility Surcharge Slab Wise</h3>
                </div>
                <div class="col-md-12 mb-10">
                    @if(Session::get('USER_ID') == -1 )
                    <button type="button" id="activate_all" class="btn btn-success pull-left" data-toggle="tooltip" data-placement="bottom" title="UPDATE ALL" data-original-title="UPDATE ALL">UPDATE ALL</button>
                    @endif
	<div id="message" style="text-align: center;"></div>
<div class=" text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('utility_surcharge');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                </div>
                <div class="panel-body">
                    <div style="width: 100%;overflow-x:scroll;">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th class="min-tablet"><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                    <th  class="min-tablet">S NO.</th>
                                    <th  class="min-tablet">SERVICE TYPE</th>
                                    <th class="min-tablet">START AMOUNT</th>
                                    <th class="min-tablet">END AMOUNT</th>
                                    <th class="min-tablet">RETAILER</th>
                                    <th class="min-tablet">FOS</th>
                                    <th class="min-tablet">DISTRIBUTER</th>
                                    <th class="min-tablet">MASTER DISTRIBUTER</th>
                                    <th class="min-tablet">BRANCH / WHITE LABEL / API</th>
                                    <th class="min-tablet">METHOD</th>
                                    <th class="min-tablet">TYPE</th>
                                    <th class="min-tablet">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($margin as $mr)
                                <form action="{{url('update_utility_surcharge/'.$mr->UTILITY_ID)}}" method="post" id="dmr_surcharge{{$mr->UTILITY_ID}}">
                                    <div id="{{$mr->UTILITY_ID}}">
                                        {{ csrf_field() }} 
                                    <tr>
                                        <td><input type="checkbox" id="txt_check{{$mr->UTILITY_ID}}" class="txt_check" name="txt_check" value="{{$mr->UTILITY_ID}}"></td>
                                        <td>{{$mr->SN}}</td>
                                        <td>{{$mr->SERVICE_NAME}}</td>
                                         <td>{{$mr->START_AMT}}</td>
                                          <td>{{$mr->END_AMT}}</td>
										<td><input class="form-control sm-div" type="number" id="txt_retailer_margin_{{$mr->UTILITY_ID}}" name="txt_retailer_margin_{{$mr->UTILITY_ID}}" value="{{$mr->MAIN_VALUE}}"></td>
                                        <td><input class="form-control sm-div" type="number" id="txt_distr_margin_{{$mr->UTILITY_ID}}" name="txt_distr_margin_{{$mr->UTILITY_ID}}" value="{{$mr->D_VALUE}}"></td>
                                        <td><input class="form-control sm-div" type="number" id="txt_master_distr_margin_{{$mr->UTILITY_ID}}" name="txt_master_distr_margin_{{$mr->UTILITY_ID}}" value="{{$mr->MD_VALUE}}"></td>
                                        <td><input class="form-control sm-div" type="number" id="txt_super_distr_margin_{{$mr->UTILITY_ID}}" name="txt_super_distr_margin_{{$mr->UTILITY_ID}}" value="{{$mr->SD_VALUE}}"></td>
                                        <td><input class="form-control" type="number" id="txt_admin_distr_margin_{{$mr->UTILITY_ID}}" name="txt_admin_distr_margin_{{$mr->UTILITY_ID}}" value="{{$mr->ADMIN_VALUE}}"></td>
                                        <td>
                                            <select class="form-control" name="dd_distribution{{$mr->UTILITY_ID}}" id="dd_distribution{{$mr->UTILITY_ID}}">
                                                <option value="1" {{$mr->MARGIN_DISTRI == 'MARGIN' ? 'selected' : ''}}>MARGIN</option>
                                                <option value="2" {{$mr->MARGIN_DISTRI == 'SURCHARGE' ? 'selected' : ''}}>SURCHARGE</option>
                                            </select>
                                        </td>
                                        <td>
                                            <select class="form-control" name="dd_margintype{{$mr->UTILITY_ID}}" id="dd_margintype{{$mr->UTILITY_ID}}">
                                                <option value="1" {{$mr->MARGIN_TYPE == 'PERCENTAGE' ? 'selected' : ''}}>PERCENTAGE</option>
                                                <option value="2" {{$mr->MARGIN_TYPE == 'FIX' ? 'selected' : ''}}>FIX</option>
                                            </select>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-md val"   onclick="conwv_pm('dmr_surcharge{{$mr->UTILITY_ID}}')">UPDATE</button>
                                        </td>
                                        <td>
                                        </td>
                                    </tr>
                                </div>
                                </form>
                                @endforeach
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            
            </div>
        </div>

            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">

    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });



    $('#activate_all').click(function(){
        bootbox.confirm('Are you sure to Submit from?', function(result){
            if((result==true))
            {
                var clicked = false;
                var id = [];
                var check_id = '';
                var value = [];
                var value1 = [];
                var value2 = [];
                var value3 = [];
                var value4 = [];
                var method = [];
                var type = [];
            /*    $.each($("input[name='txt_check']:checked"), function(){
                    check_id = $(this).val();
                    id.push($(this).val());
                    value.push($("#txt_retailer_margin_" + check_id).val());
                    value1.push($("#txt_distr_margin_" + check_id).val());
                    value2.push($("#txt_master_distr_margin_" + check_id).val());
                    value3.push($("#txt_super_distr_margin_" + check_id).val());
                    value4.push($("#txt_admin_distr_margin_" + check_id).val());
                    method.push($("#dd_distribution" + check_id).val());            
                    type.push($("#dd_margintype" + check_id).val());
					error = true;
                }); */

				var error =false;
                $.each($("input[name='txt_check']:checked"), function(){
					op_nm = [];
                    check_id = $(this).val();
                    id.push($(this).val());
					op_nm.push($("#txt_op_nm" + check_id).val());

                   if(parseFloat($("#txt_admin_distr_margin_" + check_id).val()) < parseFloat($("#txt_super_distr_margin_" + check_id).val()))
					{
                        alert('Branch / White Label / Api  value should be greater than Super Distributer value for this '+op_nm);
                        error = false;
						return false;
                    }
                     else if((parseFloat($("#txt_super_distr_margin_" + check_id).val())>0.00) && parseFloat($("#txt_super_distr_margin_" + check_id).val())<parseFloat($("#txt_master_distr_margin_" + check_id).val()))
					{
                        alert('Super Distributer value should be greater than  Distributer value for this operator '+op_nm);
                        error = false;
						return false;
                    }
                     else if((parseFloat($("#txt_master_distr_margin_" + check_id).val())>0.00) && parseFloat($("#txt_master_distr_margin_" + check_id).val())<parseFloat($("#txt_distr_margin_" + check_id).val()))
                    {
                        alert('Distributer value should be greater than FOS value for this operator '+op_nm);
                        error = false;
						return false;
                    }
                    else if((parseFloat($("#txt_distr_margin_" + check_id).val())>0.00) && parseFloat($("#txt_distr_margin_" + check_id).val())<parseFloat($("#txt_retailer_margin_" + check_id).val()))
					{
                       alert('FOS value should be greater than Retailer value for this operator '+op_nm);
                       error = false;
						return false;  
					}
					else
					{
						value.push($("#txt_retailer_margin_" + check_id).val());
						value1.push($("#txt_distr_margin_" + check_id).val());
						value2.push($("#txt_master_distr_margin_" + check_id).val());
						value3.push($("#txt_super_distr_margin_" + check_id).val());
						value4.push($("#txt_admin_distr_margin_" + check_id).val());
						method.push($("#dd_distribution" + check_id).val());  
						type.push($("#dd_margintype" + check_id).val());
						error = true;
						return true;
						
					}

                });

                if(id.length > 0 && error == true)
                {
                    $.ajax({
                       type:"POST",
                       url:"{{url('/update_all_utility_surcharge')}}",
                       data:{"_token": "{{ csrf_token() }}", "ids": id, "values": value, "values1": value1, "values2": value2, "values3": value3, "values4": value4, "methods": method, "types": type},
                       success:function(result)
                       {   
                           if(result == 1 )
                        {
                            $("#message").html('<h4 class="alert-heading text-success">Update Successfully</h4>');
                            setTimeout(function() 
                            {
                                 //window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                          }
                        if(result == 2 )
                        {
                            $("#message").html('<h4 class="alert-heading text-danger">Not Update Successfully</h4>');
                            setTimeout(function() 
                            {
                                // window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                          }
                       },
                        error: function( req, status, err ) {
                            //console.log( 'something went wrong', status, err );
                            //alert(err);
                            $("#message").html('<h4 class="alert-heading text-danger">Something Went Wrong'+err+'</h4>');
                            setTimeout(function() 
                            {
                                 //window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                        } 
                    });
                }
                else
                {
                    alert("Please select values for updation.");
                }
            }
        
        });
    });


    function conwv_pm(name){
        bootbox.confirm('Are you sure to Submit?', function(result){
            if(result==true)
            {
                var id = name.replace( /^\D+/g, '');
                var op_nm = '';
                var retailer = '';
                var dist = '';
                var master_dist = '';
                var super_dist = '';
                var admin = '';
                
                    op_nm = $("#txt_op_nm" + id).val();
                    retailer = parseFloat($("#txt_retailer_margin_" + id).val());
                    dist = parseFloat($("#txt_distr_margin_" + id).val());
                    master_dist = parseFloat($("#txt_master_distr_margin_" + id).val());
                    super_dist = parseFloat($("#txt_super_distr_margin_" + id).val());
                    admin =parseFloat($("#txt_admin_distr_margin_" + id).val());
                    if(super_dist>0.00 && super_dist > admin )
                    {
                        alert('Branch / White Label / Api  value should be greater than Super Distributer value for this operator '+op_nm);
                    }
                    else if(master_dist>0.00 && master_dist > super_dist)
                    {
                        alert('Super Distributer value should be greater than Master Distributer value for this operator '+op_nm);
                    }
                     else if(dist>0.00 && dist > master_dist)
                    {
                        alert(' Distributer value should be greater than FOS value for this operator '+op_nm);
                    }
                    else if(retailer>0.00 && retailer > dist)
                    {
                        alert('FOS value should be greater than Retailer value for this operator '+op_nm);
                    }
                    else 
                    {
                        if((result==true))
                        {
                            document.getElementById(name).submit();
                        }
                        else
                        {
                             return false;
                        }
                    }
        }
        else
        {
            return false;
        }
        });
    }
</script>
@endsection