@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Allow Limit In Prepaid</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Slab</a></li>
        <li class="active">Allow Limit In Prepaid</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Allow Limit In Prepaid</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('fetch_prepaidapilimit')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_group" id="dd_group" required>
                                                <option value="-1">Select Group</option>
                                                @foreach( $GROUP as $group)
                                                <option value="{{$group->GROUP_ID}}" {{$grid ==$group->GROUP_ID? 'selected':'' }}>{{strtoupper($group->GROUP_NAME)}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                     <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_operator">Operator</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_operator" id="dd_operator" required>
                                                <option value="-1"  {{ '-1'== $opid ? 'selected' : ''}}>Select Operator</option>
                                                @foreach($OPERATOR as $op)
                                                <option value="{{ $op->TelecomBrandId }}" {{ $op->TelecomBrandId== $opid ? 'selected' : ''}}>{{ $op->BrandName }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                                <button class="btn btn-primary" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
            
        </div>

        <div class="row">

            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Prepaid API Limit Slab Wise</h3>
                </div>
                <div class="col-md-12 mb-10">
                    @if( Session::get('USER_ID') == -1 )
            
                    <button type="button" id="activate_all" class="btn btn-success pull-left" data-toggle="tooltip" data-placement="bottom" title="UPDATE ALL" data-original-title="UPDATE ALL">UPDATE ALL</button>
                    @endif
		<div id="message" style="text-align: center;"></div>
<div class=" text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('utility_surcharge');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                </div>
                <div class="panel-body">
                    <table id="demo-dt-basic" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
								<th>GROUP NAME</th>
                                <th>SERVICE TYPE</th>
                                <th class="min-tablet">TELECOM OPERATOR</th>
                                <th class="min-tablet">LIMIT</th>
                                <!--th class="min-tablet">ACTION</th-->
                            </tr>
                        </thead>
                        <tbody>
                            @foreach( $slab_report as $con)
                            <form id="slabAPI{{$con->OPRID}}" action="{{url('update_prepaidapi_limit/'.$con->OPRID)}}" method="post">
                                <div id="{{$con->OPRID}}">
                                 {{ csrf_field() }} 
                                  <tr>
                                    <td><input type="checkbox" id="txt_check{{$con->OPRID}}" class="txt_check" name="txt_check" value="{{$con->OPRID}}"></td>
									<td>{{$con->Group_Name}}</td>
                                    <td>{{$con->ServiceName}}</td>
                                    <td>{{$con->BrandName}}
                                        <input id="txt_op_nm{{$con->OPRID}}" name="txt_op_nm{{$con->OPRID}}" type="hidden" class="form-control" value="{{$con->BrandName}}">
                                    </td>
                                    <td>
                                    <div class="form-group">
                                     <input id="txt_limitvalue{{$con->OPRID}}" name="txt_limitvalue{{$con->OPRID}}" type="number" class="form-control" required="required" value="{{$con->MAXALLOWQTY}}">
                                    </div>
                                    </td>
                                    <!--td>
                                        <button type="button" id="btn_{{$con->OPRID}}" class="btn btn-primary btn-md val" data-id="{{$con->OPRID}}" onclick="conwv('slabAPI{{$con->OPRID}}')">UPDATE</button>
                                    </td-->
                                  </tr>
                                </div>
                            </form>
                          @endforeach
                            
                        </tbody>
                    </table>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">

    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });



    $('#activate_all').click(function(){
        bootbox.confirm('Are you sure to Submit from?', function(result){
            if((result==true))
            {
                var clicked = false;
                var id = [];
                var check_id = '';
                var op_nm = [];
                var value = [];
                $.each($("input[name='txt_check']:checked"), function(){
                    op_nm = [];
                    check_id = $(this).val();
                    id.push($(this).val());
                    op_nm.push($("#txt_op_nm" + check_id).val());

                    if((parseFloat($("#txt_limitvalue" + check_id).val()) >= 0.00) && (parseFloat($("#txt_limitvalue" + check_id).val()) <= 10000.00)){
                        value.push($("#txt_limitvalue" + check_id).val());
                    }
                    else{
                        alert('Please select limit between 0 to 10000 for this operator '+op_nm);
                        return false;
                    }
                });
                if(id.length > 0)
                {
                    $.ajax({
                       type:"POST",
                       url:"{{url('/update_prepaidapilimitto_all')}}",
                       data:{"_token": "{{ csrf_token() }}", "ids": id, "values": value},
                       success:function(result)
                       {   
                          if(result == 1 )
                        {
                            $("#message").html('<h4 class="alert-heading text-success">Update Successfully</h4>');
                            setTimeout(function() 
                            {
                                 //window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                          }
                        if(result == 2 )
                        {
                            $("#message").html('<h4 class="alert-heading text-danger">Not Update Successfully</h4>');
                            setTimeout(function() 
                            {
                                // window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                          }
                       },
                        error: function( req, status, err ) {
                            //console.log( 'something went wrong', status, err );
                            //alert(err);
                            $("#message").html('<h4 class="alert-heading text-danger">Something Went Wrong'+err+'</h4>');
                            setTimeout(function() 
                            {
                                 //window.location.href = "{{url('/prepaidapi_sequences')}}";
                            }, 2000);
                        } 
                    });
                }
                else
                {
                    alert("Please select values for updation.");
                }
            }
        
        });
    });

</script>
@endsection