@extends('mainlayout')
@section('content')
<style>
.form-control.sm-div {
    width:100px !important;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">PanToken Margin</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Group</a></li>
        <li class="active">PanToken Margin</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">PanToken Margin</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_group" id="dd_group" required>
                                                <option value="-1">Select Group</option>
                                                @foreach($GROUP as $values)
                                                <option value="{{ $values->GROUP_ID }}"  {{ $values->GROUP_ID== $groupid ? 'selected' : ''}}>{{$values->GROUP_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                                <button class="btn btn-primary" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
        </div>    
            
        

        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">PanToken Margin</h3>
                </div>
                <div class="col-md-12 mb-10">
                    @if( Session::get('USER_ID') == -1 )
            
                    <button type="button" id="activate_all" class="btn btn-success pull-left" data-toggle="tooltip" data-placement="bottom" title="UPDATE ALL" data-original-title="UPDATE ALL">UPDATE ALL</button>
                    @endif

					<div class="text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('pantoken_margin');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                </div>
                <div class="panel-body">
                    <div style="width: 100%;overflow-x:scroll;">
                        <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                    <th>GROUP_NAME</th>
                                    <th>TOKEN_AMOUNT</th>
                                    <th>RETAILER</th>
                                    <th>FOS</th>
                                    <th>DISTRIBUTER</th>
                                    <th>SUPER_DISTRIBUTER</th>
                                    <th>BRANCH/WL/API</th>
                                    <th>METHOD</th>
                                    <th>TYPE</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($slab_margin as $mr)
                                <form id="pantoken_margin{{$mr->PANTOKENID}}"  name="pantoken_margin{{$mr->PANTOKENID}}" action="{{url('update_pantoken_margin/'.$mr->PANTOKENID)}}" method="post">
                                    <div id="{{$mr->PANTOKENID}}">
                                        {{ csrf_field() }} 
                                        <tr>
                                            <td><input type="checkbox" id="txt_check{{$mr->PANTOKENID}}" class="txt_check" name="txt_check" value="{{$mr->PANTOKENID}}"></td>
                                            <td>{{$mr->Group_Name}}</td>
                                            <td>{{$mr->PANTOKEN_AMT}}</td>
                                            <td><input class="form-control sm-div" type="number" id="txt_retailer_margin_{{$mr->PANTOKENID}}" name="txt_retailer_margin_{{$mr->PANTOKENID}}" value="{{$mr->pantoken}}"></td>
                                            <td><input class="form-control sm-div" type="number" id="txt_distr_margin_{{$mr->PANTOKENID}}" name="txt_distr_margin_{{$mr->PANTOKENID}}" value="{{$mr->D_pantoken}}"></td>
                                            <td><input class="form-control sm-div" type="number" id="txt_master_distr_margin_{{$mr->PANTOKENID}}" name="txt_master_distr_margin_{{$mr->PANTOKENID}}" value="{{$mr->MD_pantoken}}"></td>
                                            <td><input class="form-control sm-div" type="number" id="txt_super_distr_margin_{{$mr->PANTOKENID}}" name="txt_super_distr_margin_{{$mr->PANTOKENID}}" value="{{$mr->SD_pantoken}}"></td>
                                            <td><input class="form-control sm-div" type="number" id="txt_admin_distr_margin_{{$mr->PANTOKENID}}" name="txt_admin_distr_margin_{{$mr->PANTOKENID}}" value="{{$mr->AD_pantoken}}"></td>
                                            <td>
                                                <select class="form-control sm-div" name="dd_distribution{{$mr->PANTOKENID}}" id="dd_distribution{{$mr->PANTOKENID}}">
                                                    <option value="1" {{$mr->TYPE == 'MARGIN' ? 'selected' : ''}}>MARGIN</option>
                                                    <option value="2" {{$mr->TYPE == 'SURCHARGE' ? 'selected' : ''}}>SURCHARGE</option>
                                                </select>
                                             </td>
                                            <td>
                                                <select class="form-control sm-div" name="dd_margintype{{$mr->PANTOKENID}}" id="dd_margintype{{$mr->PANTOKENID}}">
                                                    <option value="1" {{$mr->TYPE == 'PERCENTAGE' ? 'selected' : ''}}>PERCENTAGE</option>
                                                    <option value="2" {{$mr->TYPE == 'FIX' ? 'selected' : ''}}>FIX</option>
                                                </select>
                                            </td>
                                            <td>
                                                <button type="button" id="btn_{{$mr->PANTOKENID}}" class="btn btn-primary btn-md val" data-id="{{$mr->PANTOKENID}}" onclick="conwv_pm('pantoken_margin{{$mr->PANTOKENID}}')">UPDATE</button>
                                            </td>
                                            <td></td>
                                            
                                        </tr>
                                    </div>
                                </form>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">

    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });



    $('#activate_all').click(function(){
        bootbox.confirm('Are you sure to Submit from?', function(result){
            if((result==true))
            {
                var clicked = false;
                var id = [];
                var check_id = '';
                var op_nm = [];
                var value = [];
                var value1 = [];
                var value2 = [];
                var value3 = [];
                var value4 = [];
                var method = [];
                var type = [];
					$.each($("input[name='txt_check']:checked"), function(){
                    op_nm = [];
                    check_id = $(this).val();
                    id.push($(this).val());
                    op_nm.push($("#txt_op_nm" + check_id).val());
                  
                  
                  
                   if(parseFloat($("#txt_admin_distr_margin_" + check_id).val()) < parseFloat($("#txt_super_distr_margin_" + check_id).val()))
					{
                        alert('Branch / White Label / Api  value should be greater than Super Distributer value for this '+op_nm);
                        return false;
                    }
                     else if(parseFloat($("#txt_super_distr_margin_" + check_id).val())>0.00 && parseFloat($("#txt_super_distr_margin_" + check_id).val())<parseFloat($("#txt_master_distr_margin_" + check_id).val()))
					{
                        alert('Super Distributer value should be greater than  Distributer value for this operator '+op_nm);
                        return false;
                    }
                     else if(parseFloat($("#txt_master_distr_margin_" + check_id).val())>0.00 && parseFloat($("#txt_master_distr_margin_" + check_id).val())<parseFloat($("#txt_distr_margin_" + check_id).val()))
                    {
                        alert('Distributer value should be greater than FOS value for this operator '+op_nm);
                        return false;
                    }
                    else if(parseFloat($("#txt_distr_margin_" + check_id).val())>0.00 && parseFloat($("#txt_distr_margin_" + check_id).val())<parseFloat($("#txt_retailer_margin_" + check_id).val()))
					{
                       alert('FOS value should be greater than Retailer value for this operator '+op_nm);
                       return false;  
					}
					else
					{
						value.push($("#txt_retailer_margin_" + check_id).val());
						value2.push($("#txt_master_distr_margin_" + check_id).val());
						value1.push($("#txt_distr_margin_" + check_id).val());
						value3.push($("#txt_super_distr_margin_" + check_id).val());
						value4.push($("#txt_admin_distr_margin_" + check_id).val());
						method.push($("#dd_distribution" + check_id).val());  
						type.push($("#dd_margintype" + check_id).val());
					}
                });
                if(id.length > 0)
                {
                    $.ajax({
                       type:"POST",
                       url:"{{url('/update_pantokento_all')}}",
                       data:{"_token": "{{ csrf_token() }}", "ids": id, "values": value, "values1": value1, "values2": value2, "values3": value3, "values4": value4, "methods": method, "types": type},
                       success:function(result)
                       {   
                            if(result){
                                //alert(result);
                                window.location.href = "{{url('/pan_margin')}}";
                            }
                       }
                    });
                }
                else
                {
                    alert("Please select values for updation.");
                }
            }
        
        });
    });

    function conwv_pm(name){
        bootbox.confirm('Are you sure to Submit from?', function(result){
            if(result==true)
            {
                var id = name.replace( /^\D+/g, '');
                var op_nm = '';
                var retailer = '';
                var dist = '';
                var master_dist = '';
                var super_dist = '';
                var admin = '';
                
                    op_nm = $("#txt_op_nm" + id).val();
                    retailer = parseFloat($("#txt_retailer_margin_" + id).val());
                    dist = parseFloat($("#txt_distr_margin_" + id).val());
                    master_dist = parseFloat($("#txt_master_distr_margin_" + id).val());
                    super_dist = parseFloat($("#txt_super_distr_margin_" + id).val());
                    admin =parseFloat($("#txt_admin_distr_margin_" + id).val());

                   
                   
                    
                    if(super_dist>0.00 && super_dist > admin )
                    {
                        alert('Branch / White Label / Api  value should be greater than Super Distributer value for this operator '+op_nm);
                    }
                    else if(master_dist>0.00 && master_dist > super_dist)
                    {
                        alert('Super Distributer value should be greater than Master Distributer value for this operator '+op_nm);
                    }
                     else if(dist>0.00 && dist > master_dist)
                    {
                        alert(' Distributer value should be greater than FOS value for this operator '+op_nm);
                    }
                    else if(retailer>0.00 && retailer > dist)
                    {
                        alert('FOS value should be greater than Retailer value for this operator '+op_nm);
                    }
                    else 
                    {
                        if((result==true) )
                        {
                            document.getElementById(name).submit();
                        }
                        else
                        {
                             return false;
                        }
                    }
        }
        else
        {
            return false;
        }
        });
    }

</script>
@endsection