@extends('mainlayout')
@section('content')
<style>
.form-control.sm-div {
    width:100px !important;
}
</style>
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">API Sequence Denomination Range Wise</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Slab</a></li>
        <li class="active">API Sequence Denomination Range Wise</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">

        <div class="row">

            <div class="col-lg-offset-4 col-lg-4">
            
                <div class="panel">

                    <div class="panel-heading">
                        <div class="panel-control">
                            <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                        </div>
                        <h3 class="panel-title">Prepaid API Sequence  Denomination Range Wise</h3>
                    </div>

                    <div class="collapse in">
                        
                        <form action="{{url('/denomination_range_sequences')}}" method="POST">
                            {{ csrf_field() }}
                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_group">Group</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_group" id="dd_group" required>
                                                <option value="-1" {{ '-1'== $grid ? 'selected' : ''}}>Select Group</option>
                                                @foreach($slab as $sb)
                                                <option value="{{ $sb->GROUP_ID }}"  {{ $sb->GROUP_ID== $grid ? 'selected' : ''}}>{{$sb->GROUP_NAME}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label class="control-label" for="dd_operator">Operator</label>
                                            <select class="form-control selectpicker" data-live-search="true" data-width="100%" name="dd_operator" id="dd_operator" required>
                                                <option value="-1"  {{ '-1'== $opid ? 'selected' : ''}}>Select Operator</option>
                                                @foreach($OPERATOR as $op)
                                                <option value="{{ $op->TelecomBrandId }}" {{ $op->TelecomBrandId== $opid ? 'selected' : ''}}>{{ $op->BrandName }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                </div>

                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-success" type="submit">Search</button>
                                <button class="btn btn-primary" type="button">Close</button>
                            </div>
                        </form>

                        
                    </div>
        
                </div>

            </div>
            
        </div>

        <div class="row">

            <div class="panel">

                <div class="panel-heading">
                    <h3 class="panel-title">Prepaid API Sequence Slab Wise</h3>
                </div>
                <div class="col-md-12 mb-10">
                    @if( Session::get('USER_ID') == -1 )
                    <button type="button" id="activate_all" class="btn btn-success pull-left" data-toggle="tooltip" data-placement="bottom" title="UPDATE ALL" data-original-title="UPDATE ALL">UPDATE ALL</button>
                    @endif
					<div id="message" style="text-align: center;"></div>
<div class=" text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('denomination_range');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                </div>
                <div class="panel-body">
                    <div style="width: 100%;overflow-x:scroll;">
                    <table id="demo-dt-basic" class="table table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="all_check" id="all_check" value="-1"/></th>
                                <th>S. NO.</th>
								<th>GROUP NAME</th>
                                <th>SERVICE TYPE</th>
                                <th class="min-tablet">TELECOM OPERATOR</th>
                                <th class="min-tablet">DENOMINATION API</th>
                                <th class="min-tablet">DENOMINATION RANGE</th>
                                <!-- th class="min-tablet">ACTION</th -->
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($margin as $key => $mr)
                            <form id="prepaid_apiseq{{$mr->SN}}" action="{{url('update_denomination_range_sequences/'.$mr->SN)}}" method="post">
                            <div id="{{$mr->SN}}">
                                {{ csrf_field() }} 
                            <tr>
                                <td><input type="checkbox" id="txt_check{{$mr->SN}}" class="txt_check" name="txt_check" value="{{$mr->SN}}"></td>
                                <td>{{$key+1}}</td>
								<td>{{$mr->Group_Name}}</td>
                                <td>{{$mr->ServiceName}}</td>
                                <td>{{$mr->BrandName}}
                                <input id="txt_operator_nm{{$mr->SN}}" name="txt_operator_nm{{$mr->SN}}" type="hidden" value="{{$mr->BrandName}}"/>
								<input id="txt_operator{{$mr->SN}}" name="txt_operator{{$mr->SN}}" type="hidden" value="{{$mr->BrandId}}"/>
								<input id="txt_operator_sq{{$mr->SN}}" name="txt_operator_sq{{$mr->SN}}" type="hidden" value="{{$mr->OPRID}}"/>
								</td>
                                <td>
                                    <select class="form-control" name="dd_api1_{{$mr->SN}}" id="dd_api1_{{$mr->SN}}">
                                        <option value="0">SELECT DENOMINATION API</option>
                                        @foreach($api as $ap)
                                        <option value="{{ $ap->API_ID }}" {{$ap->API_ID == $mr->DenominRangeAPI ? 'selected' : ''}}>{{$ap->API_NAME}} </option>
                                        @endforeach
                                    </select>
                                </td>
                                <td>
                                    <select class="form-control" name="dd_deno_{{$mr->SN}}" id="dd_deno_{{$mr->SN}}">
                                        <option value="0">SELECT DENOMINATION RANGE</option>
                                        @foreach($deno as $dvalue)
                                        <option value="{{ $dvalue->ID }}"  {{$dvalue->ID == $mr->DenominRangeId ? 'selected' : ''}}>MIN : {{$dvalue->MIN}} > MAX : {{$dvalue->MAX}}</option>
                                        @endforeach
                                    </select>
                                </td>
                                <!-- td>
                                    <button type="button" id="btn_{{$mr->SN}}" class="btn btn-primary btn-md val" onclick="conwv('prepaid_apiseq{{$mr->SN}}')">UPDATE</button>
                                </td -->
                            </tr>
                            </div>
                            </form>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script type="text/javascript">

    $('#all_check').click(function (e){
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });

    $('#activate_all').click(function(){
        bootbox.confirm('Are you sure to Submit from?', function(result){
          
 if((result==true))
            {
                var clicked = false;
                var id = [];
                var check_id = '';
        		var op = [];
				var oprid = [];
                var op_nm = [];
                var api = [];
                var deno = [];

                $.each($("input[name='txt_check']:checked"), function(){
                    op_nm = [];
                    check_id = $(this).val();
                    id.push($(this).val());
        			op.push($("#txt_operator" + check_id).val());
					oprid.push($("#txt_operator_sq" + check_id).val());
                    op_nm.push($("#txt_operator_nm" + check_id).val());

                    if($("#dd_api1_" + check_id).val() != '-1')
                    {
                        api.push($("#dd_api1_" + check_id).val());
                    }
                    else{
                        alert('Please select API 1 for this operator '+op_nm);
                        return false;
                    }

                    if($("#dd_deno_" + check_id).val() != '-1')
                    {
                        deno.push($("#dd_deno_" + check_id).val());
                    }
                    else{
                        alert('Please select Denomin Range for this operator '+op_nm);
                        return false;
                    }
                });

                if(id.length > 0)
                {
                    $.ajax({
                       type:"POST",
                       url:"{{url('/update_all_denomination_range_sequences')}}",
                       data:{"_token": "{{ csrf_token() }}", "ids": id, "opsq": oprid,"ops": op, "api": api, "deno": deno},
                       success:function(result)
                       {   
							if(result == 1 )
							{
									$("#message").html('<h4 class="alert-heading text-success">Update Successfully</h4>');
									setTimeout(function() 
									{
										 //window.location.href = "{{url('/denomination_range_sequences')}}";
									}, 2000);
							  }
                            if(result == 2 )
							{
									$("#message").html('<h4 class="alert-heading text-danger">Not Update Successfully</h4>');
									setTimeout(function() 
									{
										 //window.location.href = "{{url('/denomination_range_sequences')}}";
									}, 2000);
							  }
                       }
                    });
                }
                else
                {
                    alert("Please select values for updation.");
                }
            }
        });
    
    });

</script>
@endsection