@extends('mainlayout')
@section('content')
<!--CONTENT CONTAINER-->
<!--===================================================-->
<div id="content-container">
    <div id="page-head">
        
        <!--Page Title-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <div id="page-title">
            <h1 class="page-header text-overflow">Refund Report</h1>
        </div>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End page title-->


        <!--Breadcrumb-->
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <ol class="breadcrumb">
        <li><a href="{{url('/'.Session::get("dash_url"))}}"><i class="fa fa-home"></i></a></li>
        <li><a href="{{url('/'.Session::get("dash_url"))}}">Recharge Report</a></li>
        <li class="active">Refund Report</li>
        </ol>
        <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
        <!--End breadcrumb-->

    </div>

    
    <!--Page content-->
    <!--===================================================-->
    <div id="page-content">
        
        <div class="row">
            <div class="panel">

                <div class="panel-heading">
                    <div class="panel-control">
                        <button class="btn btn-default" data-panel="minmax"><i class="fa fa-arrow-circle-up"></i></button>
                    </div>
                    <h3 class="panel-title">Refund Report</h3>
                </div>

                <div class="collapse out">
    
                    <form id="refund-report" action="{{url('/refund_report')}}" method="post">
                        {{ csrf_field() }}
                            <div class="panel-body">

    

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_fromdate">From Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_fromdate" id="txt_fromdate" class="form-control"  value="{{$start}}"  placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>                                
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_todate">To Date</label>
                                        <div id="demo-dp-txtinput">
                                            <input type="text" name="txt_todate" id="txt_todate" class="form-control"  value="{{$end}}" placeholder="YYYY-MM-DD" autocomplete="off">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_account">Consumer No</label>
                                        <input type="text" id="txt_account" name="txt_account" class="form-control" placeholder="Enter Consumer No."  value="{{$txt_account}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_memberid">Member Id</label>
                                        <input type="text" id="txt_memberid" name="txt_memberid" class="form-control" placeholder="Enter Member Id."  autocomplete="off"  value="{{$txt_memberids}}" >
										<ul class="list-group costom-list" id="member_name"> </ul> 
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_transid">Transaction Id</label>
                                        <input type="text" id="txt_transid" name="txt_transid" class="form-control" placeholder="Enter Transaction Id." value="{{$txt_transid}}">
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Status</label>
                                        <select name="dd_status" id="dd_status" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="3" {{$dd_status == 3? 'selected':'' }}>COMPLAINT</option>
											
                                            <option value="5" {{$dd_status == 5? 'selected':'' }}>REJECT</option>
                                            <option value="6" {{$dd_status == 6? 'selected':'' }}>REFUNDED</option>
                                           
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Api</label>
                                        <select name="dd_api" id="dd_api" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_api == -1? 'selected':''}}>Select Api</option>
                                            @foreach($API as $api)
                                            <option value="{{ $api->API_ID }}"  {{$dd_api == $api->API_ID? 'selected':''}}>{{$api->API_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label">Operator</label>
                                        <select name="dd_operator" id="dd_operator" class="form-control selectpicker" data-live-search="true" data-width="100%">
                                            <option value="-1" {{$dd_operator == -1? 'selected':''}}>Select Operator</option>
                                            @foreach($OPERATOR as $op)
                                            <option value="{{ $op->TelecomBrandId }}"  {{$dd_operator == $op->TelecomBrandId? 'selected':''}}>{{ $op->BrandName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <label class="control-label" for="txt_noofrecords">No. of Records</label>
                                        <input type="text" id="txt_noofrecords" name="txt_noofrecords" class="form-control" placeholder="Enter No. of Records." value="{{$txt_noofrecords}}">
                                    </div>
                                </div>

                        </div>
                       
                        <div class="panel-footer text-center">
                            <button class="btn btn-success" type="submit">Search</button>
                            <button class="btn btn-primary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
    
            </div>
        </div> 

        <div class="row">
            <div class="panel">
                <div class="panel-body">
				<div class="mb-10 text-right"><button class="btn btn-success " type="button" onclick="EXPORTTOEXCEL('refund_report');"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Export To Excel</button></div>
                    <table id="demo-dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
						<thead>
							<tr>
								<th>S.NO.</th>
								<th>MEMBERID</th>
								<th>ACCOUNT</th>
								<th>API</th>
								<th>LIVE ID</th>	
								<th>REASON</th>	
                                <th>TXN DATE</th> 
                                <th>REQUEST DATE</th> 
                                <th>STATUS</th> 
                                <th>ACTION</th> 
							</tr>
						</thead>
						<tbody>
							@php 
							$AMOUNT = 0;
							@endphp
							@foreach( $rec_report as $key => $con)
                            <tr>
                                <td>{{ $key +1}}</td>
								<td>{{ $con->RegCode }}-</br>[{{ $con->MemberFirstName}} {{ $con->MemberLastName}}]</br>[{{ $con->MemberAffiliate}}]</br>[{{ $con->MemberRole}}]</td>
                                
								<td>{{ $con->ACCOUNT }}</br>[{{ $con->AMOUNT }}]</br>[{{ $con->OPERATORNAME }}]</td>
                            
                                <td>{{ $con->APINAME }}</td>
                                <td>{{ $con->OPERATORID }}</td>
								<td>{{ $con->DESCRIPTION }}</td>
								<td>{{ $con->RECHARGEDATE }}</td>
								<td>{{ $con->REFUNDREQUESTDATE }}</td>
								<td>
									@if( $con->REFUNDSTATUS == 'REFUND') 
									<button type="button" class="btn btn-success btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@elseif( $con->REFUNDSTATUS == 'PENDING') 
									<button type="button" class="btn btn-warning btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@else
									<button type="button" class="btn btn-danger btn-xs">{{ $con->REFUNDSTATUS }}</button>
									@endif
									</td>
									
									<td>
									@if( Session::get('USER_ID') == -1 )
										@if( $con->REFUNDSTATUS == 'PENDING') 
											<button type="button" class="btn btn-info btn-xs" data-toggle="modal" 
											data-account="{{$con->ACCOUNT}}" data-recstatus="{{$con->REFUNDSTATUS}}" data-recopertid="{{$con->OPERATORID}}"
											data-amount="{{$con->AMOUNT}}" data-rechid="{{$con->RechargeID}}" data-transid="{{$con->TRANSID}}" 
											data-target="#tid_modal" title="ACTION" onClick="show_rechdetails(this)">ACTION</button>
										@endif
								
									@endif

									</td>
	</tr>
@php 
$AMOUNT = $con->AMOUNT+$AMOUNT;
@endphp
 @endforeach
						</tbody>
						<tfoot>
							<tr>
								<th></th>
								<th>Total</th>
								<th>{{number_format($AMOUNT,2) }}</th>
								<th></th>
								<th></th>	
								<th></th>	
                                <th></th> 
                                <th></th> 
                                <th></th> 
                                <th></th> 
							</tr>
						</tfoot>
					    </table>
                </div>
            
            </div>
        </div>     
            
    </div>
    <!--===================================================-->
    <!--End page content-->

</div>
<!--===================================================-->
<!--END CONTENT CONTAINER-->

	<div class="modal fade" id="tid_modal" role="dialog">
            

		<div class="modal-dialog">
		  <!-- Modal content-->
		  <div class="modal-content">
		  <form name="rec_statuschng" action="{{'refund_recharge'}}" class="cmxform form-horizontal"  method="post" >
		  	{{ csrf_field() }}
			<div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
                <h4 class="modal-title" id="status_modallabel"><center>CHANGE RECHARGE STATUS</center></h4>
            </div>
			<div class="modal-body fs-12">
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group">
						<label class="control-label">MOBILE NUMBER :- <span id="pendingstatususer_mobileno"></span></label>
						<input id="txt_pendingmobileno" name="txt_pendingmobileno" type="hidden" class="form-control" required="required">
					<input id="txt_pendingstatus" name="txt_pendingstatus" type="hidden" class="form-control" required="required" value="REFUNDED">
						<input id="txt_pendingrechid" name="txt_pendingrechid" type="hidden" class="form-control" required="required">
						<input id="txt_successtxnid" name="txt_successtxnid" type="hidden" class="form-control" required="required" >
						
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group">
						<label class="control-label">RECHARGE AMOUNT :- <span id="pendingstatususer_amount"></span></label>
						<input id="txt_pendingamount" name="txt_pendingamount" type="hidden" class="form-control" required="required">
					</div>
				</div>
				<div class="col-md-12 col-sm-12 col-xs-12" >
					<div class="form-group">
						<label class="control-label">REMARKS OR OPERATOR TXN ID :-<span id="pendingoperater_tid"></span></label>
						<input id="txt_optid" name="txt_optid" type="text" class="form-control" required="required">
					</div>
				</div>
				<center>Would you like to change the status of recharge?</center>
			</div>
			<div class="modal-footer">
				<button type="button" onClick="update_tid()" class="btn btn-primary">REJECT</button>
				<button type="button" onClick="update_failed()" class="btn btn-danger">REFUND</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">CANCEL</button>
			</div>
			<script type="text/javascript">
				function show_rechdetails(obj)
				{
					$('#txt_successtxnid').val($(obj).data('transid'));
					$('#txt_pendingrechid').val($(obj).data('rechid'));
				
					$('#pendingstatususer_mobileno').html($(obj).data('account'));
					$('#txt_pendingmobileno').val($(obj).data('account'));
					$('#pendingstatususer_amount').html($(obj).data('amount'));
					$('#txt_pendingamount').val($(obj).data('amount'));
					$('#pendingoperater_tid').html($(obj).data('recopertid'));
					$('#txt_optid').val($(obj).data('recopertid'));
				} 
			</script>
			<script type="text/javascript">
				function update_tid()
				{
					var txt_rechtxnid=$('#txt_successtxnid').val();
					
					var txt_rechopid=$('#txt_optid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_successtxnid").val()!="" && $("#txt_optid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"REJECT","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								if(msg==1)
								alert("RECHARGE COMPLAINT REJECT SUCCESFULLY");
								window.location.reload();
							}
						});
					}
				} 
			</script>
				<script type="text/javascript">
				function update_failed()
				{
				
					var txt_rechtxnid=$('#txt_successtxnid').val();
					
					var txt_rechopid=$('#txt_optid').val();
					var csrf = $("input[name='csrf_token']").val();
					if($("#txt_successtxnid").val()!="" && $("#txt_optid").val()!="")
					{
						$.ajax({	
							type:"POST",
							url:"{{ url('refund_recharge')}}",
							dataType: 'json',
							data:{"txt_pendingtxnid":txt_rechtxnid,"txt_pendingstatus":"REFUNDED","txt_pendingoperaterid":txt_rechopid,_token: '{{csrf_token()}}'},
							beforeSend : function(){
								$('img.loader').show('fadein');
							},
							success:function(msg) 
							{
								if(msg==1)
								alert("RECHARGE REFUND SUCCESFULLY");
								window.location.reload();
							}
						});
					}
				} 
			</script>
			</form>
		  </div>
		 
		</div>
	</div>
<!-- /page content -->

@endsection